package ru.yandex.autotests.direct.api.campaigns.update;

import java.util.Arrays;

import org.json.simple.JSONObject;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ArrayOfStringMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;

/**
 * Created by pavryabov on 09.09.15.
 * https://st.yandex-team.ru/TESTIRT-6809
 */
@Aqua.Test
@Features(CampaignsFeatures.UPDATE)
@Description("Проверка обязательности указания полей")
@Issue("https://st.yandex-team.ru/DIRECT-34570")
@Tag(TagDictionary.TRUNK)
public class RequiredFieldsTest {

    private static final String CLIENT = CampaignsLogins.CLIENT;
    private static Long id;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(5).as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
        id = api.userSteps.campaignSteps().addDefaultTextCampaign();
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("874")
    public void negativeKeywordsWithoutItems() {
        api.userSteps.campaignSteps().expectErrorOnCampaignsUpdate(
                new UpdateRequestMap().withCampaigns(new CampaignUpdateItemMap()
                        .withId(id)
                        .withNegativeKeywords(new ArrayOfStringMap())),
                new Api5Error(8000, Api5ErrorDetails.MISSING_REQUIRED_FIELD,
                        capitalize(CampaignUpdateItemMap.NEGATIVE_KEYWORDS),
                        capitalize(ArrayOfStringMap.ITEMS)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("875")
    public void campaignWithoutId() {
        JSONObject request = new JSONObject();
        JSONObject campaignUpdateItem = new JSONObject();
        request.put(capitalize(UpdateRequestMap.CAMPAIGNS), Arrays.asList(campaignUpdateItem));
        api.userSteps.campaignSteps().expectErrorOnCampaignsUpdate(request,
                new Api5Error(8000, Api5ErrorDetails.IN_ELEMENT_OF_ARRAY_MISSING_REQUIRED_FIELD,
                        capitalize(UpdateRequestMap.CAMPAIGNS),
                        capitalize(CampaignUpdateItemMap.ID)));
    }
}
