package ru.yandex.autotests.direct.api.campaigns.update;

import java.util.Arrays;

import org.json.simple.JSONObject;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.beans.JsonObject;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.NotificationMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TimeTargetingMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;

/**
 * Created by ginger on 28.08.15.
 * https://st.yandex-team.ru/TESTIRT-6809
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-34570")
@Features(CampaignsFeatures.UPDATE)
@Description("Валидация JSON-запроса на обновление кампании")
@Tag(TagDictionary.TRUNK)
public class UpdateCampaignJsonValidationTest {

    private static String client = CampaignsLogins.UPDATE_CLIENT;
    private static final String PARAMS = "params";
    private static Long id;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(5).as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        id = api.userSteps.campaignSteps().addDefaultTextCampaign();
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("876")
    public void invalidFieldInParams() {
        JsonObject request = new JsonObject().with(UpdateRequestMap.CAMPAIGNS, new CampaignUpdateItemMap()
                .withId(id).getBean());
        api.userSteps.campaignSteps().expectErrorOnCampaignsUpdate(
                request,
                new Api5Error(8000, Api5ErrorDetails.FIELD_CONTAIN_UNKNOWN_FIELD, PARAMS, UpdateRequestMap.CAMPAIGNS)
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("877")
    public void arrayInParams() {
        UpdateRequestMap updateRequestMap = new UpdateRequestMap().withCampaigns(new CampaignUpdateItemMap()
                .withId(id));
        api.userSteps.campaignSteps().expectErrorOnCampaignsUpdate(
                new Object[]{updateRequestMap.getBean()},
                new Api5Error(8000, Api5ErrorDetails.FIELD_MUST_NOT_CONTAIN_ARRAY, PARAMS)
        );
    }

    @Test
    @Description("Несуществующее поле в структуре CampaignUpdateItem")
    @ru.yandex.qatools.allure.annotations.TestCaseId("885")
    public void updateWithUnknownFieldCampaigns() {
        String unknownField = "Ids";
        JSONObject request = new JSONObject();
        JSONObject campaignUpdateItem = new JSONObject();
        campaignUpdateItem.put(capitalize(CampaignUpdateItemMap.ID), id);
        campaignUpdateItem.put(unknownField, id);
        request.put(capitalize(UpdateRequestMap.CAMPAIGNS), Arrays.asList(campaignUpdateItem));

        api.userSteps.campaignSteps().expectErrorOnCampaignsUpdate(request,
                new Api5Error(8000, Api5ErrorDetails.ELEMENT_OF_ARRAY_CONTAIN_UNKNOWN_FIELD,
                        capitalize(UpdateRequestMap.CAMPAIGNS), unknownField));
    }

    @Test
    @Description("Не массив в поле Campaigns")
    @ru.yandex.qatools.allure.annotations.TestCaseId("878")
    public void notAnArrayInCampaignsField() {
        JSONObject request = new JSONObject();
        JSONObject campaignUpdateItem = new JSONObject();
        campaignUpdateItem.put(capitalize(CampaignUpdateItemMap.ID), id);
        request.put(capitalize(UpdateRequestMap.CAMPAIGNS), campaignUpdateItem);

        api.userSteps.campaignSteps().expectErrorOnCampaignsUpdate(request,
                new Api5Error(8000, Api5ErrorDetails.FIELD_MUST_CONTAIN_ARRAY,
                        capitalize(UpdateRequestMap.CAMPAIGNS)));
    }

    @Test
    @Description("Массив внутри массива Campaigns")
    @ru.yandex.qatools.allure.annotations.TestCaseId("879")
    public void arrayInCampaignsFieldArray() {
        JSONObject request = new JSONObject();
        JSONObject campaignUpdateItem = new JSONObject();
        campaignUpdateItem.put(capitalize(CampaignUpdateItemMap.ID), id);
        request.put(capitalize(UpdateRequestMap.CAMPAIGNS), Arrays.asList(Arrays.asList(campaignUpdateItem)));

        api.userSteps.campaignSteps().expectErrorOnCampaignsUpdate(request,
                new Api5Error(8000, Api5ErrorDetails.ELEMENT_OF_ARRAY_MUST_CONTAIN_OBJECT,
                        capitalize(UpdateRequestMap.CAMPAIGNS)));
    }


    @Test
    @Description("Массив в поле Campaigns.TextCampaign")
    @ru.yandex.qatools.allure.annotations.TestCaseId("880")
    public void anArrayInTextCampaignField() {
        JSONObject request = new JSONObject();
        JSONObject campaignUpdateItem = new JSONObject();
        campaignUpdateItem.put(capitalize(CampaignUpdateItemMap.TEXT_CAMPAIGN), Arrays.asList("text"));
        campaignUpdateItem.put(capitalize(CampaignUpdateItemMap.ID), id);
        request.put(capitalize(UpdateRequestMap.CAMPAIGNS), Arrays.asList(campaignUpdateItem));

        api.userSteps.campaignSteps().expectErrorOnCampaignsUpdate(request,
                new Api5Error(8000, Api5ErrorDetails.FIELD_MUST_NOT_CONTAIN_ARRAY,
                        capitalize(CampaignUpdateItemMap.TEXT_CAMPAIGN)));
    }

    @Test
    @Description("Массив в поле Campaigns.Notification")
    @ru.yandex.qatools.allure.annotations.TestCaseId("881")
    public void anArrayInNotification() {
        JSONObject request = new JSONObject();
        JSONObject campaignUpdateItem = new JSONObject();
        campaignUpdateItem
                .put(capitalize(CampaignUpdateItemMap.NOTIFICATION), Arrays.asList(new NotificationMap().getBean()));
        campaignUpdateItem.put(capitalize(CampaignUpdateItemMap.ID), id);
        request.put(capitalize(UpdateRequestMap.CAMPAIGNS), Arrays.asList(campaignUpdateItem));

        api.userSteps.campaignSteps().expectErrorOnCampaignsUpdate(request,
                new Api5Error(8000, Api5ErrorDetails.FIELD_MUST_NOT_CONTAIN_ARRAY,
                        capitalize(CampaignUpdateItemMap.NOTIFICATION)));
    }

    @Test
    @Description("String в поле Campaigns.Notification")
    @ru.yandex.qatools.allure.annotations.TestCaseId("882")
    public void integerInNotification() {
        JSONObject request = new JSONObject();
        JSONObject campaignUpdateItem = new JSONObject();
        campaignUpdateItem.put(capitalize(CampaignUpdateItemMap.NOTIFICATION), "notificationNotObject");
        campaignUpdateItem.put(capitalize(CampaignUpdateItemMap.ID), id);
        request.put(capitalize(UpdateRequestMap.CAMPAIGNS), Arrays.asList(campaignUpdateItem));

        api.userSteps.campaignSteps().expectErrorOnCampaignsUpdate(request,
                new Api5Error(8000, Api5ErrorDetails.FIELD_MUST_CONTAIN_OBJECT,
                        capitalize(CampaignUpdateItemMap.NOTIFICATION)));
    }

    @Test
    @Description("Массив в поле Campaigns.TimeTarget")
    @ru.yandex.qatools.allure.annotations.TestCaseId("883")
    public void anArrayInTimeTarget() {
        JSONObject request = new JSONObject();
        JSONObject campaignUpdateItem = new JSONObject();
        campaignUpdateItem
                .put(capitalize(CampaignUpdateItemMap.TIME_TARGETING), Arrays.asList(new TimeTargetingMap().getBean()));
        campaignUpdateItem.put(capitalize(CampaignUpdateItemMap.ID), id);
        request.put(capitalize(UpdateRequestMap.CAMPAIGNS), Arrays.asList(campaignUpdateItem));

        api.userSteps.campaignSteps().expectErrorOnCampaignsUpdate(request,
                new Api5Error(8000, Api5ErrorDetails.FIELD_MUST_NOT_CONTAIN_ARRAY,
                        capitalize(CampaignUpdateItemMap.TIME_TARGETING)));
    }

    @Test
    @Description("String в поле Campaigns.TimeTarget")
    @ru.yandex.qatools.allure.annotations.TestCaseId("884")
    public void integerInTimeTarget() {
        JSONObject request = new JSONObject();
        JSONObject campaignUpdateItem = new JSONObject();
        campaignUpdateItem.put(capitalize(CampaignUpdateItemMap.TIME_TARGETING), "timeTargetingNotObject");
        campaignUpdateItem.put(capitalize(CampaignUpdateItemMap.ID), id);
        request.put(capitalize(UpdateRequestMap.CAMPAIGNS), Arrays.asList(campaignUpdateItem));

        api.userSteps.campaignSteps().expectErrorOnCampaignsUpdate(request,
                new Api5Error(8000, Api5ErrorDetails.FIELD_MUST_CONTAIN_OBJECT,
                        capitalize(CampaignUpdateItemMap.TIME_TARGETING)));
    }
}
