package ru.yandex.autotests.direct.api.campaigns.update;

import java.math.BigInteger;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.CampOptionsRecord;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by hmepas on 13.10.16.
 * https://st.yandex-team.ru/TESTIRT-10423
 */

@Aqua.Test
@Features(CampaignsFeatures.UPDATE)
@Description("Проверка что при обновлении стратегии мы не валидируем OptimizeGoalId, если он явно не задан update")
@Issue("https://st.yandex-team.ru/DIRECT-58334")
public class UpdateCampaignStrategyWhileBrokenGoalIdInDBTest {
    private static final String CLIENT = CampaignsLogins.UPDATE_CLIENT;
    private static final BigInteger MISSING_GOAL_ID = BigInteger.valueOf(13100774);

    private Long brokenGoalIdCampaignId;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Before
    public void createBrokenGoalIdCampaign() {
        brokenGoalIdCampaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        int shard = api.userSteps.clientFakeSteps().getUserShard(CLIENT);

        api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps().updateCampOptions(
                new CampOptionsRecord().setBroadMatchGoalId(MISSING_GOAL_ID).setCid(brokenGoalIdCampaignId)
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("887")
    public void updatingCampaignStrategyWithBrokenGoalIdInDBAndNoGoalIdInRequestTest() {
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(new CampaignUpdateItemMap().withId(brokenGoalIdCampaignId).withTextCampaign(
                                new TextCampaignUpdateItemMap().withBiddingStrategy(
                                        new TextCampaignStrategyMap().defaultTextCampaignStrategy()
                                ))
                        ),
                ExpectedResult.success(brokenGoalIdCampaignId));
    }
}
