package ru.yandex.autotests.direct.api.campaigns.update;

import java.util.Arrays;
import java.util.List;

import com.yandex.direct.api.v5.bidmodifiers.BidModifierFieldEnum;
import com.yandex.direct.api.v5.bidmodifiers.BidModifierGetItem;
import com.yandex.direct.api.v5.bidmodifiers.BidModifierLevelEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.BidModifierGetItemMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.BidModifiersSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;
import static ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher.beanDiffer;

/**
 * Created by pavryabov on 15.12.15.
 * https://st.yandex-team.ru/TESTIRT-8028
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-49524")
@Features(CampaignsFeatures.UPDATE)
@Description("Проверка того, что Campaigns.update не удаляет корректировки на кампании")
public class UpdateCampaignWithBidModifierTest {

    private static String client = CampaignsLogins.UPDATE_CLIENT;

    private static Long id;
    private static Long bidModifierId;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(5).as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @BeforeClass
    public static void initTest() {
        id = api.userSteps.campaignSteps().addDefaultTextCampaign();
        bidModifierId = api.userSteps.bidModifiersSteps().addBidModifierMobileToCampaign(id);
        List<BidModifierGetItem> bidModifiers = api.userSteps.bidModifiersSteps().bidModifiersGet(new GetRequestMap()
                .withSelectionCriteria(new BidModifiersSelectionCriteriaMap()
                        .withLevels(BidModifierLevelEnum.CAMPAIGN)
                        .withCampaignIds(id))
                .withFieldNames(BidModifierFieldEnum.ID));
        assumeThat("в кампании есть одна корректировка", bidModifiers,
                beanDiffer(Arrays.asList(new BidModifierGetItemMap().withId(bidModifierId).getBean())));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("889")
    public void updateCampaignsWithSameIds() {
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(
                                new CampaignUpdateItemMap().withId(id)
                        ),
                ExpectedResult.success());
        List<BidModifierGetItem> bidModifiers = api.userSteps.bidModifiersSteps().bidModifiersGet(new GetRequestMap()
                .withSelectionCriteria(new BidModifiersSelectionCriteriaMap()
                        .withLevels(BidModifierLevelEnum.CAMPAIGN)
                        .withCampaignIds(id))
                .withFieldNames(BidModifierFieldEnum.ID));
        assertThat("в кампании есть одна корректировка", bidModifiers,
                beanDiffer(Arrays.asList(new BidModifierGetItemMap().withId(bidModifierId).getBean())));
    }
}
