package ru.yandex.autotests.direct.api.campaigns.update;

import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampOptionsOfflinestatnotice;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.RetargetingConditionsRetargetingConditionsType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.CampOptions;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.Campaigns;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.CampOptionsRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.CampaignsRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.RetargetingConditionsRecord;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CpmBannerCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CpmBannerCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CpmBannerCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CpmBannerCampaignStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.beandiffer2.beanfield.BeanFieldPath;
import ru.yandex.autotests.irt.testutils.beandiffer2.comparestrategy.defaultcomparestrategy.DefaultCompareStrategies;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher.beanDiffer;

/**
 * Created by pavryabov on 14.09.16.
 */
@Aqua.Test
@Features(CampaignsFeatures.UPDATE)
@Description("Обновление кампаний и проверка их состояния в базе")
@Issue("https://st.yandex-team.ru/DIRECT-58442")
public class UpdateCampaignsAndCheckDBTest {
    //DIRECT-58767

    private static final String CLIENT = CampaignsLogins.UPDATE_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(5).as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static DirectJooqDbSteps directJooqDbSteps = api.userSteps.getDirectJooqDbSteps().useShardForLogin(CLIENT);

    private static final String NAME_BEFORE_UPDATE = "NameBefore";
    private static final String NAME_AFTER_UPDATE = "NameAfter";

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("890")
    public void updateTextCampaignAndCheckPpcCampaigns() {
        Long cid = api.userSteps.campaignSteps().addCampaign(new CampaignAddItemMap()
                .defaultCampaignAddItem()
                .withName(NAME_BEFORE_UPDATE)
                .withTextCampaign(new TextCampaignAddItemMap()
                        .defaultTextCampaign()
                        .withBiddingStrategy(new TextCampaignStrategyAddMap()
                                .withSearch(new TextCampaignSearchStrategyAddMap().defaultHighestPosition())
                                .withNetwork(new TextCampaignNetworkStrategyAddMap().defaultServingOff()))));
        CampaignsRecord campaignsBeforeUpdate = directJooqDbSteps.campaignsSteps().getCampaignById(cid);
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(new CampaignUpdateItemMap().withId(cid).withName(NAME_AFTER_UPDATE)),
                ExpectedResult.success(cid));
        CampaignsRecord campaignsAfterUpdate = directJooqDbSteps.campaignsSteps().getCampaignById(cid);
        assertThat("в кампании не изменилось ничего лишнего",
                campaignsAfterUpdate.intoMap(), beanDiffer(campaignsBeforeUpdate.intoMap())
                        .useCompareStrategy(DefaultCompareStrategies.allFieldsExcept(
                                BeanFieldPath.newPath(Campaigns.CAMPAIGNS.START_TIME.getName()),
                                BeanFieldPath.newPath(Campaigns.CAMPAIGNS.LASTCHANGE.getName()),
                                BeanFieldPath.newPath(Campaigns.CAMPAIGNS.TIMETARGET.getName()),
                                BeanFieldPath.newPath(Campaigns.CAMPAIGNS.NAME.getName()),
                                // campaigns.rf https://st.yandex-team.ru/DIRECT-150563#610ba914d4042d180cfe93dd
                                // можно удалить следующую строчку после того как и add и update будут на java
                                BeanFieldPath.newPath(Campaigns.CAMPAIGNS.RF.getName())
                        )));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("891")
    public void updateTextCampaignAndCheckPpcCampOptions() {
        Long cid = api.userSteps.campaignSteps().addCampaign(new CampaignAddItemMap()
                .defaultCampaignAddItem()
                .withName(NAME_BEFORE_UPDATE)
                .withTextCampaign(new TextCampaignAddItemMap()
                        .defaultTextCampaign()
                        .withBiddingStrategy(new TextCampaignStrategyAddMap()
                                .withSearch(new TextCampaignSearchStrategyAddMap().defaultHighestPosition())
                                .withNetwork(new TextCampaignNetworkStrategyAddMap().defaultServingOff()))));
        CampOptionsRecord campOptionsBeforeUpdate = directJooqDbSteps.campaignsSteps().getCampOptionsById(cid);
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(new CampaignUpdateItemMap().withId(cid).withName(NAME_AFTER_UPDATE)),
                ExpectedResult.success(cid));
        CampOptionsRecord campOptionsAfterUpdate = directJooqDbSteps.campaignsSteps().getCampOptionsById(cid);
        assertThat("в кампании не изменилось ничего лишнего",
                campOptionsAfterUpdate.intoMap(), beanDiffer(campOptionsBeforeUpdate.intoMap())
                        .useCompareStrategy(DefaultCompareStrategies.allFieldsExcept(
                                BeanFieldPath.newPath(CampOptions.CAMP_OPTIONS.STATUSCONTEXTSTOP.getName())
                        )));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("892")
    public void updateMobileAppCampaignAndCheckPpcCampaigns() {
        //DIRECT-58768
        Long cid = api.userSteps.campaignSteps().addCampaign(new CampaignAddItemMap()
                .defaultCampaignAddItem()
                .withName(NAME_BEFORE_UPDATE)
                .withMobileAppCampaign(new MobileAppCampaignAddItemMap()
                        .defaultMobileAppCampaign()
                        .withBiddingStrategy(new MobileAppCampaignStrategyAddMap()
                                .withSearch(new MobileAppCampaignSearchStrategyAddMap().defaultHighestPosition())
                                .withNetwork(new MobileAppCampaignNetworkStrategyAddMap().defaultServingOff()))));
        CampaignsRecord campaignsBeforeUpdate = directJooqDbSteps.campaignsSteps().getCampaignById(cid);
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(new CampaignUpdateItemMap().withId(cid).withName(NAME_AFTER_UPDATE)),
                ExpectedResult.success(cid));
        CampaignsRecord campaignsAfterUpdate = directJooqDbSteps.campaignsSteps().getCampaignById(cid);
        assertThat("в кампании не изменилось ничего лишнего",
                campaignsAfterUpdate.intoMap(), beanDiffer(campaignsBeforeUpdate.intoMap())
                        .useCompareStrategy(DefaultCompareStrategies.allFieldsExcept(
                                BeanFieldPath.newPath(Campaigns.CAMPAIGNS.START_TIME.getName()),
                                BeanFieldPath.newPath(Campaigns.CAMPAIGNS.LASTCHANGE.getName()),
                                BeanFieldPath.newPath(Campaigns.CAMPAIGNS.TIMETARGET.getName()),
                                BeanFieldPath.newPath(Campaigns.CAMPAIGNS.OPTS.getName()),
                                BeanFieldPath.newPath(Campaigns.CAMPAIGNS.NAME.getName()),
                                // campaigns.rf https://st.yandex-team.ru/DIRECT-150563#610ba914d4042d180cfe93dd
                                // можно удалить следующую строчку после того как и add и update будут на java
                                BeanFieldPath.newPath(Campaigns.CAMPAIGNS.RF.getName())
                        )));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("893")
    public void updateMobileAppCampaignAndCheckPpcCampOptions() {
        Long cid = api.userSteps.campaignSteps().addCampaign(new CampaignAddItemMap()
                .defaultCampaignAddItem()
                .withName(NAME_BEFORE_UPDATE)
                .withMobileAppCampaign(new MobileAppCampaignAddItemMap()
                        .defaultMobileAppCampaign()
                        .withBiddingStrategy(new MobileAppCampaignStrategyAddMap()
                                .withSearch(new MobileAppCampaignSearchStrategyAddMap().defaultHighestPosition())
                                .withNetwork(new MobileAppCampaignNetworkStrategyAddMap().defaultServingOff()))));
        CampOptionsRecord campOptionsBeforeUpdate = directJooqDbSteps.campaignsSteps().getCampOptionsById(cid);
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(new CampaignUpdateItemMap().withId(cid).withName(NAME_AFTER_UPDATE)),
                ExpectedResult.success(cid));
        CampOptionsRecord campOptionsAfterUpdate = directJooqDbSteps.campaignsSteps().getCampOptionsById(cid);
        assertThat("в кампании не изменилось ничего лишнего",
                campOptionsAfterUpdate.intoMap(), beanDiffer(campOptionsBeforeUpdate.intoMap())
                        .useCompareStrategy(DefaultCompareStrategies.allFieldsExcept(
                                BeanFieldPath.newPath(CampOptions.CAMP_OPTIONS.STATUSCONTEXTSTOP.getName())
                        )));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("894")
    public void updateDynamicTextCampaignAndCheckPpcCampaigns() {
        Long cid = api.userSteps.campaignSteps().addCampaign(new CampaignAddItemMap()
                .defaultCampaignAddItem()
                .withName(NAME_BEFORE_UPDATE)
                .withDynamicTextCampaign(new DynamicTextCampaignAddItemMap()
                        .defaultDynamicTextCampaign()
                        .withBiddingStrategy(new DynamicTextCampaignStrategyAddMap()
                                .withSearch(new DynamicTextCampaignSearchStrategyAddMap().defaultHighestPosition())
                                .withNetwork(new DynamicTextCampaignNetworkStrategyAddMap().defaultServingOff()))));
        CampaignsRecord campaignsBeforeUpdate = directJooqDbSteps.campaignsSteps().getCampaignById(cid);
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(new CampaignUpdateItemMap().withId(cid).withName(NAME_AFTER_UPDATE)),
                ExpectedResult.success(cid));
        CampaignsRecord campaignsAfterUpdate = directJooqDbSteps.campaignsSteps().getCampaignById(cid);
        assertThat("в кампании не изменилось ничего лишнего",
                campaignsAfterUpdate.intoMap(), beanDiffer(campaignsBeforeUpdate.intoMap())
                        .useCompareStrategy(DefaultCompareStrategies.allFieldsExcept(
                                BeanFieldPath.newPath(Campaigns.CAMPAIGNS.START_TIME.getName()),
                                BeanFieldPath.newPath(Campaigns.CAMPAIGNS.LASTCHANGE.getName()),
                                BeanFieldPath.newPath(Campaigns.CAMPAIGNS.TIMETARGET.getName()),
                                BeanFieldPath.newPath(Campaigns.CAMPAIGNS.NAME.getName()),
                                // campaigns.rf https://st.yandex-team.ru/DIRECT-150563#610ba914d4042d180cfe93dd
                                // можно удалить следующую строчку после того как и add и update будут на java
                                BeanFieldPath.newPath(Campaigns.CAMPAIGNS.RF.getName())
                        )));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("895")
    public void updateDynamicTextCampaignAndCheckPpcCampOptions() {
        Long cid = api.userSteps.campaignSteps().addCampaign(new CampaignAddItemMap()
                .defaultCampaignAddItem()
                .withName(NAME_BEFORE_UPDATE)
                .withDynamicTextCampaign(new DynamicTextCampaignAddItemMap()
                        .defaultDynamicTextCampaign()
                        .withBiddingStrategy(new DynamicTextCampaignStrategyAddMap()
                                .withSearch(new DynamicTextCampaignSearchStrategyAddMap().defaultHighestPosition())
                                .withNetwork(new DynamicTextCampaignNetworkStrategyAddMap().defaultServingOff()))));
        CampOptionsRecord campOptionsBeforeUpdate = directJooqDbSteps.campaignsSteps().getCampOptionsById(cid);
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(new CampaignUpdateItemMap().withId(cid).withName(NAME_AFTER_UPDATE)),
                ExpectedResult.success(cid));
        CampOptionsRecord campOptionsAfterUpdate = directJooqDbSteps.campaignsSteps().getCampOptionsById(cid);
        assertThat("в кампании не изменилось ничего лишнего",
                campOptionsAfterUpdate.intoMap(), beanDiffer(campOptionsBeforeUpdate.intoMap())
                        .useCompareStrategy(DefaultCompareStrategies.allFieldsExcept(
                                BeanFieldPath.newPath(CampOptions.CAMP_OPTIONS.STATUSCONTEXTSTOP.getName())
                        )));
    }


    @Test
    public void updateCpmBannerCampaignAndCheckPpcCampaigns() {
        Long cid = api.userSteps.campaignSteps().addCampaign(new CampaignAddItemMap()
                .defaultCampaignAddItem()
                .withName(NAME_BEFORE_UPDATE)
                .withCpmBannerCampaign(new CpmBannerCampaignAddItemMap()
                        .defaultCpmBannerCampaign()
                        .withBiddingStrategy(new CpmBannerCampaignStrategyAddMap()
                                .withSearch(new CpmBannerCampaignSearchStrategyAddMap().defaultServingOff())
                                .withNetwork(new CpmBannerCampaignNetworkStrategyAddMap().defaultStrategyWbMaximumImpressions(
                                        Currency.RUB)))));
        CampaignsRecord campaignsBeforeUpdate = directJooqDbSteps.campaignsSteps().getCampaignById(cid);
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(new CampaignUpdateItemMap().withId(cid).withName(NAME_AFTER_UPDATE)),
                ExpectedResult.success(cid));
        CampaignsRecord campaignsAfterUpdate = directJooqDbSteps.campaignsSteps().getCampaignById(cid);
        assertThat("в кампании не изменилось ничего лишнего",
                campaignsAfterUpdate.intoMap(), beanDiffer(campaignsBeforeUpdate.intoMap())
                        .useCompareStrategy(DefaultCompareStrategies.allFieldsExcept(
                                BeanFieldPath.newPath(Campaigns.CAMPAIGNS.START_TIME.getName()),
                                BeanFieldPath.newPath(Campaigns.CAMPAIGNS.LASTCHANGE.getName()),
                                BeanFieldPath.newPath(Campaigns.CAMPAIGNS.TIMETARGET.getName()),
                                BeanFieldPath.newPath(Campaigns.CAMPAIGNS.NAME.getName()),
                                // campaigns.rf https://st.yandex-team.ru/DIRECT-150563#610ba914d4042d180cfe93dd
                                // можно удалить следующую строчку после того как и add и update будут на java
                                BeanFieldPath.newPath(Campaigns.CAMPAIGNS.RF.getName())
                        )));
    }

    @Test
    public void updateCpmBannerCampaignAndCheckPpcCampOptions() {
        Long cid = api.userSteps.campaignSteps().addCampaign(new CampaignAddItemMap()
                .defaultCampaignAddItem()
                .withName(NAME_BEFORE_UPDATE)
                .withCpmBannerCampaign(new CpmBannerCampaignAddItemMap()
                        .withBiddingStrategy(new CpmBannerCampaignStrategyAddMap()
                                .withSearch(new CpmBannerCampaignSearchStrategyAddMap().defaultServingOff())
                                .withNetwork(new CpmBannerCampaignNetworkStrategyAddMap().defaultStrategyWbMaximumImpressions(
                                        Currency.RUB)))));
        CampOptionsRecord campOptionsBeforeUpdate = directJooqDbSteps.campaignsSteps().getCampOptionsById(cid);
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(new CampaignUpdateItemMap().withId(cid).withName(NAME_AFTER_UPDATE)),
                ExpectedResult.success(cid));
        CampOptionsRecord campOptionsAfterUpdate = directJooqDbSteps.campaignsSteps().getCampOptionsById(cid);
        assertThat("в кампании не изменилось ничего лишнего",
                campOptionsAfterUpdate.intoMap(), beanDiffer(campOptionsBeforeUpdate.intoMap())
                        .useCompareStrategy(DefaultCompareStrategies.allFieldsExcept(
                                BeanFieldPath.newPath(CampOptions.CAMP_OPTIONS.STATUSCONTEXTSTOP.getName())
                        )));
    }

    private Long addRetargetingCondition() {
        Long clientId = directJooqDbSteps.shardingSteps().getClientIdByLogin(CLIENT);

        RetargetingConditionsRecord record = new RetargetingConditionsRecord()
                .setClientid(clientId)
                .setRetargetingConditionsType(RetargetingConditionsRetargetingConditionsType.ab_segments)
                .setConditionName("API test condition")
                .setConditionJson("[]")
                .setIsDeleted(0);
        return directJooqDbSteps.retargetingConditionSteps().addRetargetingCondition(record, clientId);
    }

    @Test
    public void updateCampWithAbSegmentsCampaignAndCheckPpcCampaign() {
        Long cid = api.userSteps.campaignSteps().addCampaign(new CampaignAddItemMap()
                .defaultCampaignAddItem()
                .withName(NAME_BEFORE_UPDATE)
                .withTextCampaign(new TextCampaignAddItemMap().defaultTextCampaign()));
        CampaignsRecord camp = directJooqDbSteps.campaignsSteps().getCampaignById(cid);
        camp.setAbSegmentRetCondId(addRetargetingCondition());
        camp.setAbSegmentStatRetCondId(addRetargetingCondition());
        directJooqDbSteps.campaignsSteps().updateCampaigns(camp);

        CampaignsRecord campaignsBeforeUpdate = directJooqDbSteps.campaignsSteps().getCampaignById(cid);
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(new CampaignUpdateItemMap().withId(cid).withName(NAME_AFTER_UPDATE)),
                ExpectedResult.success(cid));
        CampaignsRecord campaignsAfterUpdate = directJooqDbSteps.campaignsSteps().getCampaignById(cid);
        assertThat("в кампании не изменилось ничего лишнего",
                campaignsAfterUpdate.intoMap(), beanDiffer(campaignsBeforeUpdate.intoMap())
                        .useCompareStrategy(DefaultCompareStrategies.allFieldsExcept(
                                BeanFieldPath.newPath(Campaigns.CAMPAIGNS.START_TIME.getName()),
                                BeanFieldPath.newPath(Campaigns.CAMPAIGNS.LASTCHANGE.getName()),
                                BeanFieldPath.newPath(Campaigns.CAMPAIGNS.TIMETARGET.getName()),
                                BeanFieldPath.newPath(Campaigns.CAMPAIGNS.NAME.getName()),
                                // campaigns.rf https://st.yandex-team.ru/DIRECT-150563#610ba914d4042d180cfe93dd
                                // можно удалить следующую строчку после того как и add и update будут на java
                                BeanFieldPath.newPath(Campaigns.CAMPAIGNS.RF.getName())
                        )));
    }

    @Test
    public void updateCampaignAndNotChangeOfflineStatNotice () {
        Long cid = api.userSteps.campaignSteps().addCampaign(new CampaignAddItemMap()
                .defaultCampaignAddItem()
                .withName(NAME_BEFORE_UPDATE)
                .withTextCampaign(new TextCampaignAddItemMap().defaultTextCampaign()));
        CampOptionsRecord camp = directJooqDbSteps.campaignsSteps().getCampOptionsById(cid);
        camp.setOfflinestatnotice(CampOptionsOfflinestatnotice.Yes);
        directJooqDbSteps.campaignsSteps().updateCampOptions(camp);

        CampOptionsRecord campaignsBeforeUpdate = directJooqDbSteps.campaignsSteps().getCampOptionsById(cid);
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(new CampaignUpdateItemMap().withId(cid).withName(NAME_AFTER_UPDATE)),
                ExpectedResult.success(cid));
        CampOptionsRecord campaignsAfterUpdate = directJooqDbSteps.campaignsSteps().getCampOptionsById(cid);
        assertThat("в кампании не изменилось ничего лишнего",
                campaignsAfterUpdate.intoMap(), beanDiffer(campaignsBeforeUpdate.intoMap())
                        .useCompareStrategy(DefaultCompareStrategies.allFieldsExcept(
                                BeanFieldPath.newPath(CampOptions.CAMP_OPTIONS.STATUSCONTEXTSTOP.getName())
                        )));
    }
}
