package ru.yandex.autotests.direct.api.campaigns.update;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.campaigns.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.GetResponse;
import org.joda.time.DateTime;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.enums.CampaignType;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignGetItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher.beanDiffer;

/**
 * Created by pavryabov on 23.11.15.
 * https://st.yandex-team.ru/TESTIRT-7756
 */
@Aqua.Test
@Features(CampaignsFeatures.UPDATE)
@Description("Обновление динамических текстовых кампаний")
@Issue("https://st.yandex-team.ru/DIRECT-44876")
@RunWith(Parameterized.class)
public class UpdateCampaignsTest {

    private static final String CLIENT = CampaignsLogins.UPDATE_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(5).as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static final String NAME_FIRST_CID = "NameFirstCid";
    private static final String NAME_SECOND_CID = "NameSecondCid";

    private static final String START_DATE_FIRST = DateTime.now().toString(CampaignAddItemMap.DATE_PATTERN);
    private static final String START_DATE_SECOND =
            DateTime.now().plusDays(1).toString(CampaignAddItemMap.DATE_PATTERN);

    private Long id1;
    private Long id2;

    @Parameterized.Parameter(0)
    public CampaignType type;

    @Parameterized.Parameters(name = "campaignType = {0}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {CampaignType.TEXT},
                {CampaignType.MOBILE_CONTENT},
                {CampaignType.DYNAMIC},
                {CampaignType.CPM_BANNER}
        };
        return Arrays.asList(data);
    }

    @Step("Подготовка данных для теста")
    @Before
    public void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
        id1 = api.userSteps.campaignSteps().addCampaign(new CampaignAddItemMap()
                .defaultCampaignAddItem()
                .withStartDate(START_DATE_FIRST)
                .withDefaultCampaign(type));
        id2 = api.userSteps.campaignSteps().addCampaign(new CampaignAddItemMap()
                .defaultCampaignAddItem()
                .withStartDate(START_DATE_SECOND)
                .withDefaultCampaign(type));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("898")
    public void updateOneCampaign() {
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(new CampaignUpdateItemMap().withId(id1).withName(NAME_FIRST_CID)),
                ExpectedResult.success(id1));
        GetResponse response = api.userSteps.campaignSteps().campaignsGet(new GetRequestMap()
                .withSelectionCriteria(new CampaignsSelectionCriteriaMap().withIds(id1))
                .withFieldNames(CampaignFieldEnum.ID, CampaignFieldEnum.NAME, CampaignFieldEnum.START_DATE));
        assertThat("кампании обновились правильно", response.getCampaigns(), beanDiffer(Arrays.asList(
                new CampaignGetItemMap()
                        .withId(id1)
                        .withName(NAME_FIRST_CID)
                        .withStartDate(START_DATE_FIRST).getBean())));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("899")
    public void updateTwoCampaigns() {
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(new CampaignUpdateItemMap().withId(id1).withName(NAME_FIRST_CID),
                                new CampaignUpdateItemMap().withId(id2).withName(NAME_SECOND_CID)
                        ),
                ExpectedResult.success(id1), ExpectedResult.success(id2));
        GetResponse response = api.userSteps.campaignSteps().campaignsGet(new GetRequestMap()
                .withSelectionCriteria(new CampaignsSelectionCriteriaMap().withIds(id1, id2))
                .withFieldNames(CampaignFieldEnum.ID, CampaignFieldEnum.NAME, CampaignFieldEnum.START_DATE));
        assertThat("кампании обновились правильно", response.getCampaigns(), beanDiffer(Arrays.asList(
                new CampaignGetItemMap()
                        .withId(id1)
                        .withName(NAME_FIRST_CID)
                        .withStartDate(START_DATE_FIRST).getBean(),
                new CampaignGetItemMap()
                        .withId(id2)
                        .withName(NAME_SECOND_CID)
                        .withStartDate(START_DATE_SECOND).getBean())));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("900")
    public void updateTwoCampaignsReverseOrder() {
        //DIRECT-48365
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(new CampaignUpdateItemMap().withId(id2).withName(NAME_SECOND_CID),
                                new CampaignUpdateItemMap().withId(id1).withName(NAME_FIRST_CID)
                        ),
                ExpectedResult.success(id2), ExpectedResult.success(id1));
        GetResponse response = api.userSteps.campaignSteps().campaignsGet(new GetRequestMap()
                .withSelectionCriteria(new CampaignsSelectionCriteriaMap().withIds(id1, id2))
                .withFieldNames(CampaignFieldEnum.ID, CampaignFieldEnum.NAME, CampaignFieldEnum.START_DATE));
        assertThat("кампании обновились правильно", response.getCampaigns(), beanDiffer(Arrays.asList(
                new CampaignGetItemMap()
                        .withId(id1)
                        .withName(NAME_FIRST_CID)
                        .withStartDate(START_DATE_FIRST).getBean(),
                new CampaignGetItemMap()
                        .withId(id2)
                        .withName(NAME_SECOND_CID)
                        .withStartDate(START_DATE_SECOND).getBean())));
    }
}
