package ru.yandex.autotests.direct.api.campaigns.update;

import com.yandex.direct.api.v5.campaigns.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.CampaignGetItem;
import com.yandex.direct.api.v5.campaigns.CampaignStateGetEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.ApiFeatures;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.common.api45mng.APIPort_PortType;
import ru.yandex.autotests.directapi.common.api45mng.CreateNewSubclientResponse;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignGetItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.clients.ConvertType;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by pavryabov on 10.09.15.
 * https://st.yandex-team.ru/TESTIRT-6809
 */
@Aqua.Test
@Features(ApiFeatures.NOT_REGRESSION_YET)
@Description("Работа Campaigns.update со сконвертированной кампанией")
@Issue("https://st.yandex-team.ru/DIRECT-34570")
@Tag(TagDictionary.NEVER_RUN)
public class UpdateConvertedCampaignTest {

    private static String manager = CampaignsLogins.MANAGER_GEO;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(5);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long id;
    private static String login;

    @BeforeClass
    public static void initTest() {
        api.as(manager).wsdl(APIPort_PortType.class);
        CreateNewSubclientResponse createNewSubclientResponse =
                api.userSteps.clientSteps().createServicedClient("subClient", manager);
        login = createNewSubclientResponse.getLogin();
        id = api.userSteps.campaignSteps().addDefaultTextCampaign(login);
        api.userSteps.clientFakeSteps()
                .convertCurrency(login, Currency.RUB.toString(), ConvertType.COPY);
        CampaignGetItem campaignGetItem =
                api.userSteps.campaignSteps().campaignsGet(login, id, CampaignFieldEnum.STATE);
        assumeThat("кампания стала сконвертированной",
                campaignGetItem,
                beanDifferV5(new CampaignGetItemMap()
                        .withState(CampaignStateGetEnum.CONVERTED).getBean()));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("901")
    public void tryToUpdateConvertedCampaign() {
        api.as(Logins.MANAGER_GEO).userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(new CampaignUpdateItemMap().withId(id)), login,
                ExpectedResult.errors(new Notification(8300, Api5ErrorDetails.UNABLE_UPDATE_ARCHIVED_CAMPAGN)));
    }
}
