package ru.yandex.autotests.direct.api.campaigns.update;

import com.yandex.direct.api.v5.campaigns.CampaignTypeEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.CampaignsRecord;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.darkside.model.CampaignsType;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CpmBannerCampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang.WordUtils.capitalize;
import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by pavryabov on 01.10.15.
 * https://st.yandex-team.ru/TESTIRT-7291
 */
@Aqua.Test
@Features(CampaignsFeatures.UPDATE)
@Description("Использование в запросе Campaigns.update разных типов кампаний")
@Issue("https://st.yandex-team.ru/DIRECT-43063")
@Tag(TagDictionary.TRUNK)
public class UpdateDifferentTypesOfCampaignsInOneRequestTest {

    private static final String CLIENT = CampaignsLogins.UPDATE_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(5).as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long textId;
    private static Long mobileAppId;
    private static Long dynamicTextId;
    private static Long cpmBannerId;
    private static int shard;

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
        shard = api.userSteps.clientFakeSteps().getUserShard(CLIENT);
        textId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        mobileAppId = api.userSteps.campaignSteps().addDefaultMobileAppCampaign();
        dynamicTextId = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        cpmBannerId = api.userSteps.campaignSteps().addDefaultCpmBannerCampaign();
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("903")
    public void updateTextAndMobileAppCampaigns() {
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(
                                new CampaignUpdateItemMap().withId(textId),
                                new CampaignUpdateItemMap().withId(mobileAppId)
                        ),
                ExpectedResult.success(textId), ExpectedResult.success(mobileAppId));
        CampaignsRecord campaigns =
                api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps().getCampaignById(textId);
        assertThat("у текстовой кампании остался правильный тип", campaigns.getType().toString(),
                equalTo(CampaignsType.TEXT.value()));
        campaigns = api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps().getCampaignById(mobileAppId);
        assertThat("у кампании РМП остался правильный тип", campaigns.getType().toString(),
                equalTo(CampaignsType.MOBILE_CONTENT.value()));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("904")
    public void updateMobileAppAndTextCampaigns() {
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(
                                new CampaignUpdateItemMap().withId(mobileAppId),
                                new CampaignUpdateItemMap().withId(textId)
                        ),
                ExpectedResult.success(mobileAppId), ExpectedResult.success(textId));
        CampaignsRecord campaigns =
                api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps().getCampaignById(mobileAppId);
        assertThat("у кампании РМП остался правильный тип", campaigns.getType().toString(),
                equalTo(CampaignsType.MOBILE_CONTENT.value()));
        campaigns = api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps().getCampaignById(textId);
        assertThat("у текстовой кампании остался правильный тип", campaigns.getType().toString(),
                equalTo(CampaignsType.TEXT.value()));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("902")
    public void updateTextAndDynamicTextCampaigns() {
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(
                                new CampaignUpdateItemMap().withId(textId),
                                new CampaignUpdateItemMap().withId(dynamicTextId)
                        ),
                ExpectedResult.success(textId), ExpectedResult.success(dynamicTextId));
        CampaignsRecord campaigns =
                api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps().getCampaignById(textId);
        assertThat("у текстовой кампании остался правильный тип", campaigns.getType().toString(),
                equalTo(CampaignsType.TEXT.value()));
        campaigns =
                api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps().getCampaignById(dynamicTextId);
        assertThat("у динамической текстовой кампании остался правильный тип", campaigns.getType().toString(),
                equalTo(CampaignsType.DYNAMIC.value()));
    }

    @Test
    public void updateTextAndCpmBannerCampaigns() {
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(
                                new CampaignUpdateItemMap().withId(textId),
                                new CampaignUpdateItemMap().withId(cpmBannerId)
                        ),
                ExpectedResult.success(textId), ExpectedResult.success(cpmBannerId));
        CampaignsRecord campaigns =
                api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps().getCampaignById(textId);
        assertThat("у текстовой кампании остался правильный тип", campaigns.getType().toString(),
                equalTo(CampaignsType.TEXT.value()));
        campaigns =
                api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps().getCampaignById(cpmBannerId);
        assertThat("у медийной кампании остался правильный тип", campaigns.getType().toString(),
                equalTo(CampaignsType.CPM_BANNER.value()));
    }

    @Test
    public void updateCpmBannerAndTextCampaigns() {
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(
                                new CampaignUpdateItemMap().withId(cpmBannerId),
                                new CampaignUpdateItemMap().withId(textId)
                        ),
                ExpectedResult.success(cpmBannerId), ExpectedResult.success(textId));

        CampaignsRecord campaigns =
                api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps().getCampaignById(cpmBannerId);
        assertThat("у медийной кампании остался правильный тип", campaigns.getType().toString(),
                equalTo(CampaignsType.CPM_BANNER.value()));
        campaigns =
                api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps().getCampaignById(textId);
        assertThat("у текстовой кампании остался правильный тип", campaigns.getType().toString(),
                equalTo(CampaignsType.TEXT.value()));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("911")
    public void updateDynamicTextAndMobileAppCampaigns() {
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(
                                new CampaignUpdateItemMap().withId(dynamicTextId),
                                new CampaignUpdateItemMap().withId(mobileAppId)
                        ),
                ExpectedResult.success(dynamicTextId), ExpectedResult.success(mobileAppId));
        CampaignsRecord campaigns =
                api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps().getCampaignById(dynamicTextId);
        assertThat("у динамической текстовой кампании остался правильный тип", campaigns.getType().toString(),
                equalTo(CampaignsType.DYNAMIC.value()));
        campaigns = api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps().getCampaignById(mobileAppId);
        assertThat("у кампании РМП остался правильный тип", campaigns.getType().toString(),
                equalTo(CampaignsType.MOBILE_CONTENT.value()));
    }

    @Test
    public void updateMobileAppAndCpmBannerCampaigns() {
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(
                                new CampaignUpdateItemMap().withId(mobileAppId),
                                new CampaignUpdateItemMap().withId(cpmBannerId)
                        ),
                ExpectedResult.success(mobileAppId), ExpectedResult.success(cpmBannerId));
        CampaignsRecord campaigns =
                api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps().getCampaignById(mobileAppId);
        assertThat("у кампании РМП остался правильный тип", campaigns.getType().toString(),
                equalTo(CampaignsType.MOBILE_CONTENT.value()));
        campaigns = api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps().getCampaignById(cpmBannerId);
        assertThat("у медийной кампании остался правильный тип", campaigns.getType().toString(),
                equalTo(CampaignsType.CPM_BANNER.value()));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("905")
    public void tryUpdateOneCampaignWithTwoTypes() {
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(new CampaignUpdateItemMap()
                                .withId(textId)
                                .withTextCampaign(new TextCampaignUpdateItemMap())
                                .withMobileAppCampaign(new MobileAppCampaignUpdateItemMap())),
                JavaOrPerlExpectedResult
                        .java(ExpectedResult.errors(
                                new Notification(5009, Api5ErrorDetailsJava.ONLY_ONE_OF_FIELDS_SHOULD_BE_SPECIFIED,
                                        "CPM_BANNER, DYNAMIC, MOBILE_CONTENT, PERFORMANCE, TEXT")))
                        .perl(ExpectedResult.errors(
                                new Notification(5009,
                                        Api5ErrorDetails.CAMPAIGN_CAN_CONTAIN_ONLY_ONE_OF_OBJECTS,
                                        capitalize(CampaignUpdateItemMap.CPM_BANNER_CAMPAIGN) + ", " +
                                                capitalize(CampaignUpdateItemMap.DYNAMIC_TEXT_CAMPAIGN) + ", " +
                                                capitalize(CampaignUpdateItemMap.MOBILE_APP_CAMPAIGN) + ", " +
                                                capitalize(CampaignUpdateItemMap.SMART_CAMPAIGN) + ", " +
                                                capitalize(CampaignUpdateItemMap.TEXT_CAMPAIGN)))));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("906")
    public void tryUpdateOneCampaignWithThreeTypes() {
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(new CampaignUpdateItemMap()
                                .withId(textId)
                                .withTextCampaign(new TextCampaignUpdateItemMap())
                                .withMobileAppCampaign(new MobileAppCampaignUpdateItemMap())
                                .withDynamicTextCampaign(new DynamicTextCampaignUpdateItemMap())),
                JavaOrPerlExpectedResult
                        .java(ExpectedResult.errors(
                                new Notification(5009, Api5ErrorDetailsJava.ONLY_ONE_OF_FIELDS_SHOULD_BE_SPECIFIED,
                                        "CPM_BANNER, DYNAMIC, MOBILE_CONTENT, PERFORMANCE, TEXT")))
                        .perl(ExpectedResult.errors(
                                new Notification(5009,
                                        Api5ErrorDetails.CAMPAIGN_CAN_CONTAIN_ONLY_ONE_OF_OBJECTS,
                                        capitalize(CampaignUpdateItemMap.CPM_BANNER_CAMPAIGN) + ", " +
                                                capitalize(CampaignUpdateItemMap.DYNAMIC_TEXT_CAMPAIGN) + ", " +
                                                capitalize(CampaignUpdateItemMap.MOBILE_APP_CAMPAIGN) + ", " +
                                                capitalize(CampaignUpdateItemMap.SMART_CAMPAIGN) + ", " +
                                                capitalize(CampaignUpdateItemMap.TEXT_CAMPAIGN)))));
    }

    @Test
    public void tryUpdateOneCampaignWithFourTypes() {
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(
                new UpdateRequestMap()
                        .withCampaigns(new CampaignUpdateItemMap()
                                .withId(textId)
                                .withTextCampaign(new TextCampaignUpdateItemMap())
                                .withMobileAppCampaign(new MobileAppCampaignUpdateItemMap())
                                .withDynamicTextCampaign(new DynamicTextCampaignUpdateItemMap())
                                .withCpmBannerCampaign(new CpmBannerCampaignUpdateItemMap())),
                JavaOrPerlExpectedResult
                        .java(ExpectedResult.errors(
                                new Notification(5009, Api5ErrorDetailsJava.ONLY_ONE_OF_FIELDS_SHOULD_BE_SPECIFIED,
                                        "CPM_BANNER, DYNAMIC, MOBILE_CONTENT, PERFORMANCE, TEXT")))
                        .perl(ExpectedResult.errors(
                                new Notification(5009,
                                        Api5ErrorDetails.CAMPAIGN_CAN_CONTAIN_ONLY_ONE_OF_OBJECTS,
                                        capitalize(CampaignUpdateItemMap.CPM_BANNER_CAMPAIGN) + ", " +
                                                capitalize(CampaignUpdateItemMap.DYNAMIC_TEXT_CAMPAIGN) + ", " +
                                                capitalize(CampaignUpdateItemMap.MOBILE_APP_CAMPAIGN) + ", " +
                                                capitalize(CampaignUpdateItemMap.SMART_CAMPAIGN) + ", " +
                                                capitalize(CampaignUpdateItemMap.TEXT_CAMPAIGN))))
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("907")
    public void tryUpdateTypeForTextCampaign() {
        //DIRECT-46948
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(new CampaignUpdateItemMap()
                                .withId(textId)
                                .withMobileAppCampaign(new MobileAppCampaignUpdateItemMap())),
                ExpectedResult.errors(new Notification(4000,
                        Api5ErrorDetails.CAMPAIGN_TYPE_NOT_MATCHES_WITH_TYPE_IN_REQUEST,
                        CampaignTypeEnum.TEXT_CAMPAIGN, CampaignTypeEnum.MOBILE_APP_CAMPAIGN)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("908")
    public void tryUpdateTypeForMobileAppCampaign() {
        //DIRECT-46948
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(new CampaignUpdateItemMap()
                                .withId(mobileAppId)
                                .withTextCampaign(new TextCampaignUpdateItemMap())),
                ExpectedResult.errors(new Notification(4000,
                        Api5ErrorDetails.CAMPAIGN_TYPE_NOT_MATCHES_WITH_TYPE_IN_REQUEST,
                        CampaignTypeEnum.MOBILE_APP_CAMPAIGN, CampaignTypeEnum.TEXT_CAMPAIGN)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("909")
    public void tryUpdateTypeForDynamicTextCampaign() {
        //DIRECT-46948
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(new CampaignUpdateItemMap()
                                .withId(dynamicTextId)
                                .withTextCampaign(new TextCampaignUpdateItemMap())),
                ExpectedResult.errors(new Notification(4000,
                        Api5ErrorDetails.CAMPAIGN_TYPE_NOT_MATCHES_WITH_TYPE_IN_REQUEST,
                        CampaignTypeEnum.DYNAMIC_TEXT_CAMPAIGN, CampaignTypeEnum.TEXT_CAMPAIGN)));
    }

    @Test
    public void tryUpdateTypeForCpmBannerCampaign() {
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(new CampaignUpdateItemMap()
                                .withId(cpmBannerId)
                                .withTextCampaign(new TextCampaignUpdateItemMap())),
                ExpectedResult.errors(new Notification(4000,
                        Api5ErrorDetails.CAMPAIGN_TYPE_NOT_MATCHES_WITH_TYPE_IN_REQUEST,
                        CampaignTypeEnum.CPM_BANNER_CAMPAIGN, CampaignTypeEnum.TEXT_CAMPAIGN)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("910")
    public void tryUpdateTypeFromTextToDynamicText() {
        //DIRECT-46948
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(new CampaignUpdateItemMap()
                                .withId(textId)
                                .withDynamicTextCampaign(new DynamicTextCampaignUpdateItemMap())),
                ExpectedResult.errors(new Notification(4000,
                        Api5ErrorDetails.CAMPAIGN_TYPE_NOT_MATCHES_WITH_TYPE_IN_REQUEST,
                        CampaignTypeEnum.TEXT_CAMPAIGN, CampaignTypeEnum.DYNAMIC_TEXT_CAMPAIGN)));
    }

    @Test
    public void tryUpdateTypeFromMobileAppToCpmBanner() {
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(new CampaignUpdateItemMap()
                                .withId(mobileAppId)
                                .withCpmBannerCampaign(new CpmBannerCampaignUpdateItemMap())),
                ExpectedResult.errors(new Notification(4000,
                        Api5ErrorDetails.CAMPAIGN_TYPE_NOT_MATCHES_WITH_TYPE_IN_REQUEST,
                        CampaignTypeEnum.MOBILE_APP_CAMPAIGN, CampaignTypeEnum.CPM_BANNER_CAMPAIGN)));
    }
}
