package ru.yandex.autotests.direct.api.campaigns.update;

import com.yandex.direct.api.v5.general.YesNoEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CpmBannerCampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TimeTargetingMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TimeTargetingOnPublicHolidaysMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by ginger on 28.08.15.
 * https://st.yandex-team.ru/TESTIRT-6809
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-34570")
@Features(CampaignsFeatures.UPDATE)
@Description("Пообъектная обработка запроса")
@Tag(TagDictionary.TRUNK)
public class UpdateDiscreteValidationTest {

    private static String client = CampaignsLogins.UPDATE_CLIENT;
    private static final String INVALID_DATE = "date";

    private static Long textId1;
    private static Long textId2;
    private static Long mobileAppId1;
    private static Long mobileAppId2;
    private static Long dynamicTextId1;
    private static Long dynamicTextId2;
    private static Long cpmBannerId1;
    private static Long cpmBannerId2;

    private static final TimeTargetingMap TIME_TARGETING_MAP = new TimeTargetingMap()
            .withSchedule(TimeTargetingMap.CPM_BANNER_DEFAULT_SCHEDULE)
            .withConsiderWorkingWeekends(YesNoEnum.YES)
            .withHolidaysSchedule(new TimeTargetingOnPublicHolidaysMap()
                    .withSuspendOnHolidays(YesNoEnum.NO)
                    .withBidPercent(100)
                    .withStartHour(12)
                    .withEndHour(13));

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(5).as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        textId1 = api.userSteps.campaignSteps().addDefaultTextCampaign();
        textId2 = api.userSteps.campaignSteps().addDefaultTextCampaign();
        mobileAppId1 = api.userSteps.campaignSteps().addDefaultMobileAppCampaign();
        mobileAppId2 = api.userSteps.campaignSteps().addDefaultMobileAppCampaign();
        dynamicTextId1 = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        dynamicTextId2 = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        cpmBannerId1 = api.userSteps.campaignSteps().addDefaultCpmBannerCampaign();
        cpmBannerId2 = api.userSteps.campaignSteps().addDefaultCpmBannerCampaign();
    }


    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("912")
    public void updateValidAndInvalidTextCampaigns() {
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(
                                new CampaignUpdateItemMap()
                                        .withId(textId1),
                                new CampaignUpdateItemMap()
                                        .withId(textId2)
                                        .withStartDate(INVALID_DATE)
                        ),
                JavaOrPerlExpectedResult.both(ExpectedResult.success(textId1)),
                JavaOrPerlExpectedResult
                        .java(ExpectedResult.errors(new Notification(5004,
                                Api5ErrorDetailsJava.VALUE_INVALID_FORMAT_IN_FILED, "StartDate")))
                        .perl(ExpectedResult.errors(new Notification(5004,
                                Api5ErrorDetails.INVALID_CAMPAIGN_START_DATE))));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("913")
    public void updateInvalidAndValidTextCampaigns() {
        //DIRECT-46942
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(
                                new CampaignUpdateItemMap()
                                        .withId(textId1)
                                        .withStartDate(INVALID_DATE),
                                new CampaignUpdateItemMap()
                                        .withId(textId2)
                        ),
                JavaOrPerlExpectedResult
                        .java(ExpectedResult.errors(new Notification(5004,
                                Api5ErrorDetailsJava.VALUE_INVALID_FORMAT_IN_FILED, "StartDate")))
                        .perl(ExpectedResult.errors(new Notification(5004,
                                Api5ErrorDetails.INVALID_CAMPAIGN_START_DATE))),
                JavaOrPerlExpectedResult.both(ExpectedResult.success(textId2)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("914")
    public void updateTwoInvalidTextCampaigns() {
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(
                                new CampaignUpdateItemMap()
                                        .withId(textId1)
                                        .withStartDate(INVALID_DATE),
                                new CampaignUpdateItemMap()
                                        .withId(textId2)
                                        .withStartDate(INVALID_DATE)
                        ),
                JavaOrPerlExpectedResult
                        .java(ExpectedResult.errors(new Notification(5004,
                                Api5ErrorDetailsJava.VALUE_INVALID_FORMAT_IN_FILED, "StartDate")))
                        .perl(ExpectedResult.errors(new Notification(5004,
                                Api5ErrorDetails.INVALID_CAMPAIGN_START_DATE))),
                JavaOrPerlExpectedResult
                        .java(ExpectedResult.errors(new Notification(5004,
                                Api5ErrorDetailsJava.VALUE_INVALID_FORMAT_IN_FILED, "StartDate")))
                        .perl(ExpectedResult.errors(new Notification(5004,
                                Api5ErrorDetails.INVALID_CAMPAIGN_START_DATE))));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("915")
    public void updateValidAndInvalidMobileAppCampaigns() {
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(
                                new CampaignUpdateItemMap()
                                        .withId(mobileAppId1),
                                new CampaignUpdateItemMap()
                                        .withId(mobileAppId2)
                                        .withStartDate(INVALID_DATE)
                        ),
                JavaOrPerlExpectedResult.both(ExpectedResult.success(mobileAppId1)),
                JavaOrPerlExpectedResult
                        .java(ExpectedResult.errors(new Notification(5004,
                                Api5ErrorDetailsJava.VALUE_INVALID_FORMAT_IN_FILED, "StartDate")))
                        .perl(ExpectedResult.errors(new Notification(5004,
                                Api5ErrorDetails.INVALID_CAMPAIGN_START_DATE))));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("916")
    public void updateInvalidAndValidMobileAppCampaigns() {
        //DIRECT-46942
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(
                                new CampaignUpdateItemMap()
                                        .withId(mobileAppId1)
                                        .withStartDate(INVALID_DATE),
                                new CampaignUpdateItemMap()
                                        .withId(mobileAppId2)
                        ),
                JavaOrPerlExpectedResult
                        .java(ExpectedResult.errors(new Notification(5004,
                                Api5ErrorDetailsJava.VALUE_INVALID_FORMAT_IN_FILED, "StartDate")))
                        .perl(ExpectedResult.errors(new Notification(5004,
                                Api5ErrorDetails.INVALID_CAMPAIGN_START_DATE))),
                JavaOrPerlExpectedResult.both(ExpectedResult.success(mobileAppId2)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("917")
    public void updateTwoInvalidMobileAppCampaigns() {
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(
                                new CampaignUpdateItemMap()
                                        .withId(mobileAppId1)
                                        .withStartDate(INVALID_DATE),
                                new CampaignUpdateItemMap()
                                        .withId(mobileAppId2)
                                        .withStartDate(INVALID_DATE)
                        ),
                JavaOrPerlExpectedResult
                        .java(ExpectedResult.errors(new Notification(5004,
                                Api5ErrorDetailsJava.VALUE_INVALID_FORMAT_IN_FILED, "StartDate")))
                        .perl(ExpectedResult.errors(new Notification(5004,
                                Api5ErrorDetails.INVALID_CAMPAIGN_START_DATE))),
                JavaOrPerlExpectedResult
                        .java(ExpectedResult.errors(new Notification(5004,
                                Api5ErrorDetailsJava.VALUE_INVALID_FORMAT_IN_FILED, "StartDate")))
                        .perl(ExpectedResult.errors(new Notification(5004,
                                Api5ErrorDetails.INVALID_CAMPAIGN_START_DATE))));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("918")
    public void updateValidTextAndInvalidMobileAppCampaigns() {
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(
                                new CampaignUpdateItemMap()
                                        .withId(textId1),
                                new CampaignUpdateItemMap()
                                        .withId(mobileAppId2)
                                        .withStartDate(INVALID_DATE)
                        ),
                JavaOrPerlExpectedResult.both(ExpectedResult.success(textId1)),
                JavaOrPerlExpectedResult
                        .java(ExpectedResult.errors(new Notification(5004,
                                Api5ErrorDetailsJava.VALUE_INVALID_FORMAT_IN_FILED, "StartDate")))
                        .perl(ExpectedResult.errors(new Notification(5004,
                                Api5ErrorDetails.INVALID_CAMPAIGN_START_DATE))));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("919")
    public void updateValidMobileAppAndInvalidTextCampaigns() {
        //DIRECT-46942
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(
                                new CampaignUpdateItemMap()
                                        .withId(mobileAppId1),
                                new CampaignUpdateItemMap()
                                        .withId(textId1)
                                        .withStartDate(INVALID_DATE)
                        ),
                JavaOrPerlExpectedResult.both(ExpectedResult.success(mobileAppId1)),
                JavaOrPerlExpectedResult
                        .java(ExpectedResult.errors(new Notification(5004,
                                Api5ErrorDetailsJava.VALUE_INVALID_FORMAT_IN_FILED, "StartDate")))
                        .perl(ExpectedResult.errors(new Notification(5004,
                                Api5ErrorDetails.INVALID_CAMPAIGN_START_DATE))));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("920")
    public void updateValidAndInvalidDynamicTextCampaigns() {
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(
                                new CampaignUpdateItemMap()
                                        .withId(dynamicTextId1),
                                new CampaignUpdateItemMap()
                                        .withId(dynamicTextId2)
                                        .withStartDate(INVALID_DATE)
                        ),
                JavaOrPerlExpectedResult.both(ExpectedResult.success(dynamicTextId1)),
                JavaOrPerlExpectedResult
                        .java(ExpectedResult.errors(new Notification(5004,
                                Api5ErrorDetailsJava.VALUE_INVALID_FORMAT_IN_FILED, "StartDate")))
                        .perl(ExpectedResult.errors(new Notification(5004,
                                Api5ErrorDetails.INVALID_CAMPAIGN_START_DATE))));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("921")
    public void updateInvalidAndValidDynamicTextCampaigns() {
        //DIRECT-46942
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(
                                new CampaignUpdateItemMap()
                                        .withId(dynamicTextId1)
                                        .withStartDate(INVALID_DATE),
                                new CampaignUpdateItemMap()
                                        .withId(dynamicTextId2)
                        ),
                JavaOrPerlExpectedResult
                        .java(ExpectedResult.errors(new Notification(5004,
                                Api5ErrorDetailsJava.VALUE_INVALID_FORMAT_IN_FILED, "StartDate")))
                        .perl(ExpectedResult.errors(new Notification(5004,
                                Api5ErrorDetails.INVALID_CAMPAIGN_START_DATE))),
                JavaOrPerlExpectedResult.both(ExpectedResult.success(dynamicTextId2)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("922")
    public void updateTwoInvalidDynamicTextCampaigns() {
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(
                                new CampaignUpdateItemMap()
                                        .withId(dynamicTextId1)
                                        .withStartDate(INVALID_DATE),
                                new CampaignUpdateItemMap()
                                        .withId(dynamicTextId2)
                                        .withStartDate(INVALID_DATE)
                        ),
                JavaOrPerlExpectedResult
                        .java(ExpectedResult.errors(new Notification(5004,
                                Api5ErrorDetailsJava.VALUE_INVALID_FORMAT_IN_FILED, "StartDate")))
                        .perl(ExpectedResult.errors(new Notification(5004,
                                Api5ErrorDetails.INVALID_CAMPAIGN_START_DATE))),
                JavaOrPerlExpectedResult
                        .java(ExpectedResult.errors(new Notification(5004,
                                Api5ErrorDetailsJava.VALUE_INVALID_FORMAT_IN_FILED, "StartDate")))
                        .perl(ExpectedResult.errors(new Notification(5004,
                                Api5ErrorDetails.INVALID_CAMPAIGN_START_DATE))));
    }

    @Test
    public void updateValidAndInvalidCpmBannerCampaigns() {
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(
                                new CampaignUpdateItemMap()
                                        .withId(cpmBannerId1),
                                new CampaignUpdateItemMap()
                                        .withId(cpmBannerId2)
                                        .withStartDate(INVALID_DATE)
                        ),
                JavaOrPerlExpectedResult.both(ExpectedResult.success(cpmBannerId1)),
                JavaOrPerlExpectedResult
                        .java(ExpectedResult.errors(new Notification(5004,
                                Api5ErrorDetailsJava.VALUE_INVALID_FORMAT_IN_FILED, "StartDate")))
                        .perl(ExpectedResult.errors(new Notification(5004,
                                Api5ErrorDetails.INVALID_CAMPAIGN_START_DATE))));
    }

    @Test
    public void updateInvalidAndValidCpmBannerCampaigns() {
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(
                                new CampaignUpdateItemMap()
                                        .withId(cpmBannerId1)
                                        .withStartDate(INVALID_DATE),
                                new CampaignUpdateItemMap()
                                        .withId(cpmBannerId2)
                        ),
                JavaOrPerlExpectedResult
                        .java(ExpectedResult.errors(new Notification(5004,
                                Api5ErrorDetailsJava.VALUE_INVALID_FORMAT_IN_FILED, "StartDate")))
                        .perl(ExpectedResult.errors(new Notification(5004,
                                Api5ErrorDetails.INVALID_CAMPAIGN_START_DATE))),
                JavaOrPerlExpectedResult.both(ExpectedResult.success(cpmBannerId2)));
    }

    @Test
    public void updateTwoInvalidCpmBannerCampaigns() {
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(
                                new CampaignUpdateItemMap()
                                        .withId(cpmBannerId1)
                                        .withStartDate(INVALID_DATE),
                                new CampaignUpdateItemMap()
                                        .withId(cpmBannerId2)
                                        .withStartDate(INVALID_DATE)
                        ),
                JavaOrPerlExpectedResult
                        .java(ExpectedResult.errors(new Notification(5004,
                                Api5ErrorDetailsJava.VALUE_INVALID_FORMAT_IN_FILED, "StartDate")))
                        .perl(ExpectedResult.errors(new Notification(5004,
                                Api5ErrorDetails.INVALID_CAMPAIGN_START_DATE))),
                JavaOrPerlExpectedResult
                        .java(ExpectedResult.errors(new Notification(5004,
                                Api5ErrorDetailsJava.VALUE_INVALID_FORMAT_IN_FILED, "StartDate")))
                        .perl(ExpectedResult.errors(new Notification(5004,
                                Api5ErrorDetails.INVALID_CAMPAIGN_START_DATE))));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("923")
    public void updateValidTextAndInvalidDynamicTextCampaigns() {
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(
                                new CampaignUpdateItemMap()
                                        .withId(textId1),
                                new CampaignUpdateItemMap()
                                        .withId(dynamicTextId2)
                                        .withStartDate(INVALID_DATE)
                        ),
                JavaOrPerlExpectedResult.both(ExpectedResult.success(textId1)),
                JavaOrPerlExpectedResult
                        .java(ExpectedResult.errors(new Notification(5004,
                                Api5ErrorDetailsJava.VALUE_INVALID_FORMAT_IN_FILED, "StartDate")))
                        .perl(ExpectedResult.errors(new Notification(5004,
                                Api5ErrorDetails.INVALID_CAMPAIGN_START_DATE))));
    }

    @Test
    public void updateValidCpmAndInvalidText() {
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(
                                new CampaignUpdateItemMap()
                                        .withId(cpmBannerId1),
                                new CampaignUpdateItemMap()
                                        .withId(textId1)
                                        .withStartDate(INVALID_DATE)
                        ),
                JavaOrPerlExpectedResult.both(ExpectedResult.success(cpmBannerId1)),
                JavaOrPerlExpectedResult
                        .java(ExpectedResult.errors(new Notification(5004,
                                Api5ErrorDetailsJava.VALUE_INVALID_FORMAT_IN_FILED, "StartDate")))
                        .perl(ExpectedResult.errors(new Notification(5004,
                                Api5ErrorDetails.INVALID_CAMPAIGN_START_DATE))));
    }

    @Test
    public void updateValidDynamicTextAndInvalidCpmBannerCampaigns() {
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(
                                new CampaignUpdateItemMap()
                                        .withId(dynamicTextId1),
                                new CampaignUpdateItemMap()
                                        .withId(cpmBannerId1)
                                        .withStartDate(INVALID_DATE)
                        ),
                JavaOrPerlExpectedResult.both(ExpectedResult.success(dynamicTextId1)),
                JavaOrPerlExpectedResult
                        .java(ExpectedResult.errors(new Notification(5004,
                                Api5ErrorDetailsJava.VALUE_INVALID_FORMAT_IN_FILED, "StartDate")))
                        .perl(ExpectedResult.errors(new Notification(5004,
                                Api5ErrorDetails.INVALID_CAMPAIGN_START_DATE))));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("924")
    public void updateInvalidTextAndInvalidMobileAppAndInvalidDynamicTextCampaigns() {
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(
                                new CampaignUpdateItemMap()
                                        .withId(textId1)
                                        .withStartDate(INVALID_DATE),
                                new CampaignUpdateItemMap()
                                        .withId(mobileAppId1)
                                        .withStartDate(INVALID_DATE),
                                new CampaignUpdateItemMap()
                                        .withId(dynamicTextId1)
                                        .withStartDate(INVALID_DATE)
                        ),
                JavaOrPerlExpectedResult
                        .java(ExpectedResult.errors(new Notification(5004,
                                Api5ErrorDetailsJava.VALUE_INVALID_FORMAT_IN_FILED, "StartDate")))
                        .perl(ExpectedResult.errors(new Notification(5004,
                                Api5ErrorDetails.INVALID_CAMPAIGN_START_DATE))),
                JavaOrPerlExpectedResult
                        .java(ExpectedResult.errors(new Notification(5004,
                                Api5ErrorDetailsJava.VALUE_INVALID_FORMAT_IN_FILED, "StartDate")))
                        .perl(ExpectedResult.errors(new Notification(5004,
                                Api5ErrorDetails.INVALID_CAMPAIGN_START_DATE))),
                JavaOrPerlExpectedResult
                        .java(ExpectedResult.errors(new Notification(5004,
                                Api5ErrorDetailsJava.VALUE_INVALID_FORMAT_IN_FILED, "StartDate")))
                        .perl(ExpectedResult.errors(new Notification(5004,
                                Api5ErrorDetails.INVALID_CAMPAIGN_START_DATE)))
        );
    }

    @Test
    public void updateInvalidTextAndInvalidMobileAppAndInvalidDynamicTextAndInvalidCpmBannerCampaigns() {
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(
                                new CampaignUpdateItemMap()
                                        .withId(textId1)
                                        .withStartDate(INVALID_DATE),
                                new CampaignUpdateItemMap()
                                        .withId(mobileAppId1)
                                        .withStartDate(INVALID_DATE),
                                new CampaignUpdateItemMap()
                                        .withId(dynamicTextId1)
                                        .withStartDate(INVALID_DATE),
                                new CampaignUpdateItemMap()
                                        .withId(cpmBannerId1)
                                        .withStartDate(INVALID_DATE)
                        ),
                JavaOrPerlExpectedResult
                        .java(ExpectedResult.errors(new Notification(5004,
                                Api5ErrorDetailsJava.VALUE_INVALID_FORMAT_IN_FILED, "StartDate")))
                        .perl(ExpectedResult.errors(new Notification(5004,
                                Api5ErrorDetails.INVALID_CAMPAIGN_START_DATE))),
                JavaOrPerlExpectedResult
                        .java(ExpectedResult.errors(new Notification(5004,
                                Api5ErrorDetailsJava.VALUE_INVALID_FORMAT_IN_FILED, "StartDate")))
                        .perl(ExpectedResult.errors(new Notification(5004,
                                Api5ErrorDetails.INVALID_CAMPAIGN_START_DATE))),
                JavaOrPerlExpectedResult
                        .java(ExpectedResult.errors(new Notification(5004,
                                Api5ErrorDetailsJava.VALUE_INVALID_FORMAT_IN_FILED, "StartDate")))
                        .perl(ExpectedResult.errors(new Notification(5004,
                                Api5ErrorDetails.INVALID_CAMPAIGN_START_DATE))),
                JavaOrPerlExpectedResult
                        .java(ExpectedResult.errors(new Notification(5004,
                                Api5ErrorDetailsJava.VALUE_INVALID_FORMAT_IN_FILED, "StartDate")))
                        .perl(ExpectedResult.errors(new Notification(5004,
                                Api5ErrorDetails.INVALID_CAMPAIGN_START_DATE))));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("925")
    public void updateTwoValidTextCampaignsWithDifferentSetOfFields() {
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(
                                new CampaignUpdateItemMap()
                                        .withId(textId1)
                                        .withTextCampaign(new TextCampaignUpdateItemMap().withCounterIds(1))
                                        .withTimeTargeting(TIME_TARGETING_MAP),
                                new CampaignUpdateItemMap()
                                        .withId(textId2)
                                        .withName("testName")
                                        .withExcludedSites("qwerty.ru")
                        ),
                ExpectedResult.success(textId1), ExpectedResult.success(textId2));
    }

    @Test
    public void updateTwoValidCpmBannerCampaignsWithDifferentSetOfFields() {
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(
                                new CampaignUpdateItemMap()
                                        .withId(cpmBannerId1)
                                        .withCpmBannerCampaign(new CpmBannerCampaignUpdateItemMap().withCounterIds(1))
                                        .withTimeTargeting(TIME_TARGETING_MAP),
                                new CampaignUpdateItemMap()
                                        .withId(cpmBannerId2)
                                        .withName("testName")
                                        .withExcludedSites("qwerty.ru")
                        ),
                ExpectedResult.success(cpmBannerId1), ExpectedResult.success(cpmBannerId2));
    }
}
