package ru.yandex.autotests.direct.api.campaigns.update;

import java.util.Arrays;
import java.util.Collection;

import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExceptionNotificationMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;

/**
 * Created by ginger on 28.08.15.
 * https://st.yandex-team.ru/TESTIRT-6809
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-34570")
@Features(CampaignsFeatures.UPDATE)
@Description("Неверные идентификаторы в запросе")
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class UpdateInvalidCampaignIdTest {
    private static String client = CampaignsLogins.UPDATE_CLIENT;
    private static String anotherClient = CampaignsLogins.GET_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(5).as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public long invalidId;

    @Parameterized.Parameter(2)
    public ExceptionNotificationMap expectedError;

    @Parameterized.Parameters(name = "{0}")
    public static Collection<Object[]> data() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(anotherClient);

        api.as(anotherClient);
        Long anotherId = api.userSteps.campaignSteps().addDefaultTextCampaign();

        api.as(client);
        Long id = api.userSteps.campaignSteps().addDefaultTextCampaign();
        Long nonexistentId = id + 500000;
        Long deletedId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        api.userSteps.campaignSteps().campaignsDelete(deletedId);
        Long archivedId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        api.userSteps.campaignSteps().campaignsSuspend(archivedId);
        api.userSteps.campaignSteps().campaignsArchive(archivedId);

        return Arrays.asList(new Object[][]{
                {"идентификатор архивированной кампании", archivedId,
                        new Notification(8300, Api5ErrorDetails.UNABLE_UPDATE_ARCHIVED_CAMPAGN)},
                {"несуществующий идентификатор", nonexistentId,
                        new Notification(8800, Api5ErrorDetails.CAMPAIGN_NOT_FOUND)},
                {"удалённый идентификатор", deletedId,
                        new Notification(8800, Api5ErrorDetails.CAMPAIGN_NOT_FOUND)},
                {"чужой идентификатор", anotherId,
                        new Notification(8800, Api5ErrorDetails.CAMPAIGN_NOT_FOUND)},
                {"нулевой идентификатор", 0,
                        new Notification(5005, Api5ErrorDetails.FIELD_MUST_BE_POSITIVE_INTEGER,
                                capitalize(CampaignUpdateItemMap.ID))},
                {"отрицательный идентификатор", -1,
                        new Notification(5005, Api5ErrorDetails.FIELD_MUST_BE_POSITIVE_INTEGER,
                                capitalize(CampaignUpdateItemMap.ID))},
        });
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("931")
    public void tryUpdateCampaignInvalidId() {
        //DIRECT-45660
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(
                                new CampaignUpdateItemMap()
                                        .withId(invalidId)
                        ),
                ExpectedResult.errors(expectedError));
    }
}
