package ru.yandex.autotests.direct.api.campaigns.update;

import java.util.Arrays;
import java.util.Collection;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.darkside.model.CampaignsType;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult.bothJavaAndPerl;

/**
 * Created by ginger on 28.08.15.
 * https://st.yandex-team.ru/TESTIRT-6809
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-34570")
@Features(CampaignsFeatures.UPDATE)
@Description("Проверка работы метода с типами кампаний, которые не поддерживаются")
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class UpdateNotSupportedCampaignTypeTest {
    private static String client = CampaignsLogins.UPDATE_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(5).as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);
    private static Long campaignID;

    @Parameterized.Parameter(0)
    public CampaignsType type;

    @Parameterized.Parameter(value = 1)
    public JavaOrPerlExpectedResult expectedResult;

    @Parameterized.Parameters(name = "campaignType = {0}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {CampaignsType.GEO, bothJavaAndPerl(8800, Api5ErrorDetails.CAMPAIGN_NOT_FOUND)},
                {CampaignsType.WALLET, bothJavaAndPerl(8800, Api5ErrorDetails.CAMPAIGN_NOT_FOUND)},
                {CampaignsType.MCB, bothJavaAndPerl(8800, Api5ErrorDetails.CAMPAIGN_NOT_FOUND)},
                {CampaignsType.MCBANNER, JavaOrPerlExpectedResult
                        .java(ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.CAMPAIGN_NOT_FOUND)))
                        .perl(ExpectedResult.errors(new Notification(3500, Api5ErrorDetails.CAMPAIGN_TYPE_NOT_SUPPORTED)))},
                {CampaignsType.CPM_DEALS, bothJavaAndPerl(3500, Api5ErrorDetails.CAMPAIGN_TYPE_NOT_SUPPORTED)},
//DIRECT-47721
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void createCampaign() {
        campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign();
    }

    @Before
    public void prepareData() {
        api.userSteps.campaignFakeSteps().setType(campaignID, type);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("935")
    public void tryUpdateCampaignInvalidType() {
        //DIRECT-45661
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(
                                new CampaignUpdateItemMap()
                                        .withId(campaignID)
                        ),
                expectedResult);
    }
}
