package ru.yandex.autotests.direct.api.campaigns.update;

import org.joda.time.DateTime;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by pavryabov on 20.09.15.
 * https://st.yandex-team.ru/TESTIRT-6809
 */
@Aqua.Test
@Features(CampaignsFeatures.UPDATE)
@Description("Обновление только с одной датой, неправильной хронологически, относительно другой")
@Issue("https://st.yandex-team.ru/DIRECT-34570")
@Tag(TagDictionary.TRUNK)
public class UpdateOnlyOneDateChronologicalTest {

    private static final String CLIENT = CampaignsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(5).as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long id;

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
        id = api.userSteps.campaignSteps().addCampaign(new CampaignAddItemMap()
                .defaultCampaignAddItem()
                .withStartDate(DateTime.now().plusDays(1).toString(CampaignAddItemMap.DATE_PATTERN))
                .withEndDate(DateTime.now().plusDays(1).toString(CampaignAddItemMap.DATE_PATTERN))
                .withDefaultTextCampaign());
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("937")
    public void updateStartDate() {
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(new CampaignUpdateItemMap()
                                .withId(id)
                                .withStartDate(DateTime.now().plusDays(2)
                                        .toString(CampaignAddItemMap.DATE_PATTERN))
                        ),
                ExpectedResult.errors(
                        new Notification(6000, Api5ErrorDetails.END_DATE_CANNOT_BE_BEFORE_START_DATE)
                ));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("936")
    public void updateEndDate() {
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(new CampaignUpdateItemMap()
                                .withId(id)
                                .withEndDate(DateTime.now()
                                        .toString(CampaignAddItemMap.DATE_PATTERN))
                        ),
                ExpectedResult.errors(
                        new Notification(6000, Api5ErrorDetails.END_DATE_CANNOT_BE_BEFORE_START_DATE)
                ));
    }
}
