package ru.yandex.autotests.direct.api.campaigns.update.contentpromotion;

import java.util.Arrays;
import java.util.Collection;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.campaignsext.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaignsext.UpdateRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by pavryabov on 23.11.15.
 * https://st.yandex-team.ru/TESTIRT-7756
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-44876")
@Features(CampaignsFeatures.UPDATE)
@Description("Проверка прав внешних ролей на обновление динамической текстовой кампании")
@RunWith(Parameterized.class)
public class UpdateContentPromotionCampaignExternalRolesNegativeTest {

    private Long id;

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public String operatorForUpdate;

    @Parameterized.Parameter(2)
    public String client;

    @Parameterized.Parameter(3)
    public String operatorForCreate;

    @Parameterized.Parameter(4)
    public Api5Error expectedResult;

    @Parameterized.Parameters(name = "{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {"Обновление от имени субклиента без прав на редактирование",
                        CampaignsLogins.SUB_CLIENT_WITHOUT_EDIT_RIGHTS, CampaignsLogins.SUB_CLIENT_WITHOUT_EDIT_RIGHTS,
                        Logins.AGENCY_CAMPAIGNS,
                        new Api5Error(54, Api5ErrorDetails.NULL_STRING)}
        });
    }

    @Before
    public void createCampaign() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(operatorForCreate);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(operatorForUpdate);
        api.as(Logins.SUPER_LOGIN, operatorForCreate);
        id = api.userSteps.campExtSteps().addDefaultContentPromotionCampaign(client);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("927")
    public void checkUpdateRights() {
        api.as(Logins.SUPER_LOGIN, operatorForUpdate);
        api.userSteps.campExtSteps().expectErrorOnCampaignsUpdate(
                new UpdateRequestMap()
                        .withCampaigns(
                                new CampaignUpdateItemMap()
                                        .withId(id)
                        ),
                client,
                expectedResult
        );
    }
}
