package ru.yandex.autotests.direct.api.campaigns.update.contentpromotion.fieldvalidation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.campaignsext.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaignsext.ContentPromotionCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaignsext.ContentPromotionCampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaignsext.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.RandomUtils;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;

/**
 * Created by pavryabov on 23.11.15.
 * https://st.yandex-team.ru/TESTIRT-7756
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-44876")
@Features(CampaignsFeatures.UPDATE)
@Description("Проверка обновления поля CounterIds в динамической текстовой кампании. Негативные сценарии")
@RunWith(Parameterized.class)
public class UpdateCounterIdsNegativeTest {

    private static String client = CampaignsLogins.UPDATE_CLIENT;

    private static Long id;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(5).as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public Integer[] counterIds;

    @Parameterized.Parameter(2)
    public JavaOrPerlExpectedResult expectedResult;

    @Parameterized.Parameters(name = "{0}")
    public static Collection testData() {
        List<Integer> overLengthCounterIds = new ArrayList<Integer>();
        for (int i = 0; i <= ContentPromotionCampaignAddItemMap.MAX_AMOUNT_OF_COUNTER_IDS; i++) {
            overLengthCounterIds.add(RandomUtils.getRandomInteger(1, 1000000));
        }
        Object[][] data = new Object[][]{
                {"negative id", new Integer[]{-1},
                        JavaOrPerlExpectedResult
                                .java(ExpectedResult.errors(
                                        new Notification(5005,
                                                Api5ErrorDetailsJava.FIELD_MUST_BE_POSITIVE_INTEGER,
                                                "CounterIds[0]")))
                                .perl(ExpectedResult.errors(
                                new Notification(5005,
                                        Api5ErrorDetails.ADDITIONAL_METRICA_COUNTERS_INCORRECTLY_SPECIFIED, "-1")))
                },
                {"zero id", new Integer[]{0},
                        JavaOrPerlExpectedResult
                                .java(ExpectedResult.errors(
                                        new Notification(5005, Api5ErrorDetailsJava.FIELD_MUST_BE_POSITIVE_INTEGER,
                                                "CounterIds[0]")))
                                .perl(ExpectedResult.errors(
                                new Notification(5005,
                                        Api5ErrorDetails.ADDITIONAL_METRICA_COUNTERS_INCORRECTLY_SPECIFIED, "0")))
                },
                {"повторяющееся значение", new Integer[]{1, 1},
                        JavaOrPerlExpectedResult
                                .java(ExpectedResult.errors(
                                        new Notification(9802,
                                                Api5ErrorDetails.ELEMENT_PRESENT_IN_LIST_MORE_THAN_ONE_TIME,
                                                "CounterIds[0]", "CounterIds"),
                                        new Notification(9802,
                                                Api5ErrorDetails.ELEMENT_PRESENT_IN_LIST_MORE_THAN_ONE_TIME,
                                                "CounterIds[1]", "CounterIds")))
                                .perl(ExpectedResult.errors(
                                new Notification(9802,
                                        Api5ErrorDetails.ELEMENT_PRESENT_IN_LIST_MORE_THAN_ONE_TIME, 1,
                                        capitalize(ContentPromotionCampaignAddItemMap.COUNTER_IDS))))
                },
                {"Количество элементов, превышающее максимальную длину", overLengthCounterIds.toArray(new Integer[]{}),
                        JavaOrPerlExpectedResult
                                .java(ExpectedResult.errors(
                                        new Notification(7001,
                                                Api5ErrorDetailsJava.MAX_ELEMENTS_EXCEEDED_DETAILED,
                                                ContentPromotionCampaignAddItemMap.MAX_AMOUNT_OF_COUNTER_IDS)))
                                .perl(ExpectedResult.errors(
                                new Notification(7001, Api5ErrorDetails.NO_MORE_MERTRICA_COUNTERS_CAN_BE_SPECIFIED,
                                        ContentPromotionCampaignAddItemMap.MAX_AMOUNT_OF_COUNTER_IDS)))
                },
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void createCampaign() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        id = api.userSteps.campExtSteps().addDefaultContentPromotionCampaign();
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("947")
    public void tryUpdateCounterIds() {
        api.userSteps.campExtSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(new CampaignUpdateItemMap()
                                .withId(id)
                                .withContentPromotionCampaign(new ContentPromotionCampaignUpdateItemMap().withCounterIds(counterIds))
                        ),
                expectedResult);
    }
}
