package ru.yandex.autotests.direct.api.campaigns.update.contentpromotion.settings;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.util.streamex.StreamEx;

import com.yandex.direct.api.v5.campaignsext.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaignsext.ContentPromotionCampaignFieldEnum;
import com.yandex.direct.api.v5.campaignsext.ContentPromotionCampaignSettingGet;
import com.yandex.direct.api.v5.campaignsext.ContentPromotionCampaignSettingsEnum;
import com.yandex.direct.api.v5.campaignsext.ContentPromotionCampaignSettingsGetEnum;
import com.yandex.direct.api.v5.campaignsext.GetResponse;
import com.yandex.direct.api.v5.general.YesNoEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.campaignsext.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaignsext.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaignsext.CampaignsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.campaignsext.ContentPromotionCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaignsext.ContentPromotionCampaignSettingMap;
import ru.yandex.autotests.directapi.model.api5.campaignsext.ContentPromotionCampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaignsext.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaignsext.UpdateRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.direct.api.campext.CampaignsExtDeprecatedSettings.CONTENT_PROMOTION_CAMPAIGN_DEPRECATED_SETTINGS;
import static ru.yandex.autotests.direct.api.campext.CampaignsExtDeprecatedSettings.CONTENT_PROMOTION_CAMPAIGN_DEPRECATED_SETTINGS_GET;
import static ru.yandex.autotests.directapi.matchers.beandiffer2.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by buhter on 04.02.16.
 * https://st.yandex-team.ru/TESTIRT-8435
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-50402")
@Features(CampaignsFeatures.UPDATE)
@Description("Проверка поля Settings. Независимость изменений с NO на YES")
@RunWith(Parameterized.class)
public class UpdateAndGetSettingsAllNoTest {
    private static final String client = CampaignsLogins.GET_SERV_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private Long campaignID;
    private Map<ContentPromotionCampaignSettingsGetEnum, YesNoEnum> expectedSettings;
    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public ContentPromotionCampaignSettingsEnum option;

    @Parameterized.Parameters(name = "option = {0}")
    public static Collection<Object[]> testData() {
        List<Object[]> data = new ArrayList<>();
        for (ContentPromotionCampaignSettingsEnum settingsEnum : ContentPromotionCampaignSettingsEnum.values()) {
            if (CONTENT_PROMOTION_CAMPAIGN_DEPRECATED_SETTINGS.contains(settingsEnum)) {
                continue;
            }
            data.add(new Object[]{settingsEnum});
        }
        return data;
    }

    @Before
    @Step("Подготовка данных для теста")
    public void prepareCampaign() {
        expectedSettings = new HashMap<>();
        for (ContentPromotionCampaignSettingsGetEnum settingsEnum : ContentPromotionCampaignSettingsGetEnum.values()) {
            if (CONTENT_PROMOTION_CAMPAIGN_DEPRECATED_SETTINGS_GET.contains(settingsEnum)) {
                continue;
            }
            YesNoEnum value = (settingsEnum.value().equals(option.value()) ||
                    settingsEnum.equals(ContentPromotionCampaignSettingsGetEnum.DAILY_BUDGET_ALLOWED))
                    ? YesNoEnum.YES : YesNoEnum.NO;
            expectedSettings.put(settingsEnum, value);
        }

        ArrayList<ContentPromotionCampaignSettingMap> settings = new ArrayList<>();
        for (ContentPromotionCampaignSettingsEnum settingsEnum : ContentPromotionCampaignSettingsEnum.values()) {
            if (CONTENT_PROMOTION_CAMPAIGN_DEPRECATED_SETTINGS.contains(settingsEnum)) {
                continue;
            }
            settings.add(new ContentPromotionCampaignSettingMap().withOption(settingsEnum).withValue(YesNoEnum.NO));
        }
        campaignID = api.userSteps.campExtSteps().addCampaign(
                new CampaignAddItemMap()
                        .defaultCampaignAddItem()
                        .withContentPromotionCampaign(new ContentPromotionCampaignAddItemMap()
                                .defaultContentPromotionCampaign()
                                .withSettings(settings.toArray(new ContentPromotionCampaignSettingMap[settings.size()]))
                        ));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("949")
    public void checkUpdateSettingsTest() {
        api.userSteps.campExtSteps().campaignsUpdate(new UpdateRequestMap().withCampaigns(new CampaignUpdateItemMap()
                .withId(campaignID)
                .withContentPromotionCampaign(new ContentPromotionCampaignUpdateItemMap()
                        .withSettings(new ContentPromotionCampaignSettingMap()
                                .withOption(option)
                                .withValue(YesNoEnum.YES)))
        ));
        GetResponse getResponse = api.as(client).userSteps.campExtSteps().campaignsGet(
                new GetRequestMap()
                        .withSelectionCriteria(new CampaignsSelectionCriteriaMap()
                                .withIds(campaignID))
                        .withFieldNames(CampaignFieldEnum.ID)
                        .withContentPromotionCampaignFieldNames(ContentPromotionCampaignFieldEnum.SETTINGS));
        assumeThat("получили созданную кампанию", getResponse.getCampaigns(), hasSize(1));
        List<ContentPromotionCampaignSettingGet> settings =
                getResponse.getCampaigns().get(0).getContentPromotionCampaign().getSettings();
        assumeThat("получили настройки кампании", settings, notNullValue());
        Map<ContentPromotionCampaignSettingsGetEnum, YesNoEnum> settingsActual = StreamEx.of(settings)
                .filter(s -> !CONTENT_PROMOTION_CAMPAIGN_DEPRECATED_SETTINGS_GET.contains(s.getOption()))
                .toMap(ContentPromotionCampaignSettingGet::getOption, ContentPromotionCampaignSettingGet::getValue);

        assertThat("вернулся ожидаемый набор настроек", settingsActual, beanDifferV5(expectedSettings));
    }
}
