package ru.yandex.autotests.direct.api.campaigns.update.contentpromotion.strategy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.fake.CampaignFakeInfo;
import ru.yandex.autotests.directapi.darkside.model.Status;
import ru.yandex.autotests.directapi.model.api5.campaignsext.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaignsext.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaignsext.ContentPromotionCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaignsext.ContentPromotionCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaignsext.ContentPromotionCampaignNetworkStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaignsext.ContentPromotionCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaignsext.ContentPromotionCampaignSearchStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaignsext.ContentPromotionCampaignStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaignsext.ContentPromotionCampaignStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaignsext.ContentPromotionCampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaignsext.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.common.Value;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by pavryabov on 23.11.15.
 * https://st.yandex-team.ru/TESTIRT-7756
 */
@Aqua.Test
@Features(CampaignsFeatures.UPDATE)
@Issue("https://st.yandex-team.ru/DIRECT-44876")
@Description("Поверка StatusBsSynced динамической текстовой кампании после обновления стратегии")
@RunWith(Parameterized.class)
public class CheckStatusBsSyncedAfterUpdateStrategyTest {

    private static String client = CampaignsLogins.UPDATE_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private Long id;

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public ContentPromotionCampaignSearchStrategyAddMap searchStrategyForCreate;

    @Parameterized.Parameter(2)
    public ContentPromotionCampaignNetworkStrategyAddMap networkStrategyForCreate;

    @Parameterized.Parameter(3)
    public ContentPromotionCampaignSearchStrategyMap searchStrategyForUpdate;

    @Parameterized.Parameter(4)
    public ContentPromotionCampaignNetworkStrategyMap networkStrategyForUpdate;

    @Parameterized.Parameters(name = "{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {"Ручная + ServingOff -> Авто + ServingOff",
                        new ContentPromotionCampaignSearchStrategyAddMap().defaultHighestPosition(),
                        new ContentPromotionCampaignNetworkStrategyAddMap().defaultServingOff(),
                        new ContentPromotionCampaignSearchStrategyMap().defaultWbMaximumClicks(Currency.RUB),
                        new ContentPromotionCampaignNetworkStrategyMap().defaultServingOff()},
        });
    }

    @BeforeClass
    public static void prepareClient() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
    }

    @Before
    public void createCampaign() {
        id = api.userSteps.campExtSteps().addCampaign(new CampaignAddItemMap()
                .defaultCampaignAddItem()
                .withContentPromotionCampaign(new ContentPromotionCampaignAddItemMap()
                        .withBiddingStrategy(new ContentPromotionCampaignStrategyAddMap()
                                .withSearch(searchStrategyForCreate)
                                .withNetwork(networkStrategyForCreate))));

        api.userSteps.campaignFakeSteps().setBSSynced(id, true);
        api.userSteps.campaignFakeSteps().setStatusModerate(id, Status.YES);
        CampaignFakeInfo campaignFakeInfo = api.userSteps.campaignFakeSteps().fakeGetCampaignParams(id);
        assumeThat("у кампании StatusBsSynced = Yes", campaignFakeInfo.getStatusBsSynced(), equalTo(Value.YES));
        assumeThat("у кампании StatusModerate = Yes", campaignFakeInfo.getStatusModerate(), equalTo(Status.YES));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("957")
    public void updateStrategy() {
        //DIRECT-46406
        api.userSteps.campExtSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(new CampaignUpdateItemMap()
                                .withId(id)
                                .withContentPromotionCampaign(new ContentPromotionCampaignUpdateItemMap()
                                        .withBiddingStrategy(new ContentPromotionCampaignStrategyMap()
                                                .withSearch(searchStrategyForUpdate)
                                                .withNetwork(networkStrategyForUpdate)))),
                ExpectedResult.success(id));
        checkStatuses(Value.NO, Value.YES, Value.YES, Value.YES);
        //ToDO после починки бага заменить последнее значение на NO (и разделить тесты, аналогично TextCampaign)
    }

    public void checkStatuses(String campaignStatus, String adGroupStatus, String adStatus, String keywordStatus) {
        List<String> statuses = new ArrayList<String>();
        CampaignFakeInfo campaignFakeInfo = api.userSteps.campaignFakeSteps().fakeGetCampaignParams(id);
        statuses.add(campaignFakeInfo.getStatusBsSynced());
        assertThat("объекты имеют правильные статусы (campaign, adGroup, ad, keyword)",
                statuses, equalTo(Arrays.asList(campaignStatus)));
    }
}
