package ru.yandex.autotests.direct.api.campaigns.update.contentpromotion.strategy;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import com.yandex.direct.api.v5.campaignsext.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaignsext.CampaignGetItem;
import com.yandex.direct.api.v5.campaignsext.ContentPromotionCampaignFieldEnum;
import com.yandex.direct.api.v5.campaignsext.ContentPromotionCampaignNetworkStrategyTypeEnum;
import com.yandex.direct.api.v5.campaignsext.ContentPromotionCampaignSearchStrategyTypeEnum;
import com.yandex.direct.api.v5.campaignsext.ContentPromotionCampaignStrategy;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.campaignsext.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaignsext.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaignsext.CampaignsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.campaignsext.ContentPromotionCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaignsext.ContentPromotionCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaignsext.ContentPromotionCampaignNetworkStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaignsext.ContentPromotionCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaignsext.ContentPromotionCampaignSearchStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaignsext.ContentPromotionCampaignStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaignsext.ContentPromotionCampaignStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaignsext.ContentPromotionCampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaignsext.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaignsext.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by chicos on 28.08.2015.
 */
@Aqua.Test
@Features(CampaignsFeatures.UPDATE)
@RunWith(Parameterized.class)
@Description("Обновление динамической текстовой кампании с ручными стратегиями для Search")
public class StrategyCombinationsManualSearchTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());
    private static final String client = CampaignsLogins.CLIENT;
    private static final Currency currency = Currency.RUB;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public String description;

    @Parameterized.Parameter(value = 1)
    public ContentPromotionCampaignSearchStrategyMap searchStrategy;

    @Parameterized.Parameter(value = 2)
    public ContentPromotionCampaignNetworkStrategyMap networkStrategy;

    @Parameterized.Parameter(value = 3)
    public ContentPromotionCampaignSearchStrategyAddMap searchStrategyAdd;

    @Parameterized.Parameter(value = 4)
    public ContentPromotionCampaignNetworkStrategyAddMap networkStrategyAdd;

    @Parameterized.Parameters(name = "Strategy = {0}")
    public static Collection roles() {
        Object[][] data = new Object[][]{
                //DIRECT-45770
                {"HighestPosition + ServingOff",
                        new ContentPromotionCampaignSearchStrategyMap()
                                .withBiddingStrategyType(ContentPromotionCampaignSearchStrategyTypeEnum.HIGHEST_POSITION),
                        new ContentPromotionCampaignNetworkStrategyMap()
                                .withBiddingStrategyType(ContentPromotionCampaignNetworkStrategyTypeEnum.SERVING_OFF),
                        new ContentPromotionCampaignSearchStrategyAddMap()
                                .withBiddingStrategyType(ContentPromotionCampaignSearchStrategyTypeEnum.HIGHEST_POSITION),
                        new ContentPromotionCampaignNetworkStrategyAddMap()
                                .withBiddingStrategyType(ContentPromotionCampaignNetworkStrategyTypeEnum.SERVING_OFF)}
        };
        return Arrays.asList(data);
    }

    @Before
    @Step("Подготовим данные для теста")
    public void clearUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("959")
    public void updateCampaignStrategyTest() {
        Long campaignId = api.userSteps.campExtSteps().addDefaultContentPromotionCampaign();
        api.userSteps.campExtSteps().shouldGetResultOnUpdate(
                new UpdateRequestMap().withCampaigns(new CampaignUpdateItemMap()
                        .defaultCampaignUpdateItem()
                        .withId(campaignId)
                        .withContentPromotionCampaign(new ContentPromotionCampaignUpdateItemMap()
                                .withBiddingStrategy(new ContentPromotionCampaignStrategyMap()
                                        .withSearch(searchStrategy)
                                        .withNetwork(networkStrategy)))),
                ExpectedResult.success(campaignId));

        List<CampaignGetItem> campaigns = api.userSteps.campExtSteps().getCampaigns(
                new GetRequestMap().withSelectionCriteria(new CampaignsSelectionCriteriaMap()
                        .withIds(campaignId))
                        .withFieldNames(CampaignFieldEnum.ID)
                        .withContentPromotionCampaignFieldNames(ContentPromotionCampaignFieldEnum.BIDDING_STRATEGY));
        assumeThat("получили кампанию", campaigns, hasSize(1));
        ContentPromotionCampaignStrategy actualStrategy = campaigns.get(0).getContentPromotionCampaign().getBiddingStrategy();
        assumeThat("получили стратегии кампании", actualStrategy, notNullValue());

        ContentPromotionCampaignStrategyMap expectedStrategy = new ContentPromotionCampaignStrategyMap()
                .withSearch(searchStrategy)
                .withNetwork(networkStrategy);

        assertThat("получили корректные стратегии", actualStrategy,
                beanDifferV5((ContentPromotionCampaignStrategy) expectedStrategy.getBean()));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("960")
    public void updateToAutoStrategyTest() {
        //DIRECT-46187
        List<Long> ids = api.userSteps.campExtSteps().campaignsAddWithCheck(new CampaignAddItemMap()
                .defaultCampaignAddItem()
                .withContentPromotionCampaign(new ContentPromotionCampaignAddItemMap()
                        .withBiddingStrategy(new ContentPromotionCampaignStrategyAddMap()
                                .withSearch(searchStrategyAdd)
                                .withNetwork(networkStrategyAdd))));
        assumeThat("создана кампания", ids, hasSize(1));

        log.info("Изменим стратегию кампании на автобюджетную");
        api.userSteps.campExtSteps().shouldGetResultOnUpdate(
                new UpdateRequestMap().withCampaigns(new CampaignUpdateItemMap()
                        .defaultCampaignUpdateItem()
                        .withId(ids.get(0))
                        .withContentPromotionCampaign(new ContentPromotionCampaignUpdateItemMap()
                                .withBiddingStrategy(new ContentPromotionCampaignStrategyMap()
                                        .withSearch(
                                                new ContentPromotionCampaignSearchStrategyMap().defaultAverageCpc(currency))
                                        .withNetwork(
                                                new ContentPromotionCampaignNetworkStrategyMap().defaultServingOff())))),
                ExpectedResult.success(ids.get(0)));

        List<CampaignGetItem> campaigns = api.userSteps.campExtSteps().getCampaigns(
                new GetRequestMap().withSelectionCriteria(new CampaignsSelectionCriteriaMap()
                        .withIds(ids.get(0)))
                        .withFieldNames(CampaignFieldEnum.ID)
                        .withContentPromotionCampaignFieldNames(ContentPromotionCampaignFieldEnum.BIDDING_STRATEGY));
        assumeThat("получили кампанию", campaigns, hasSize(1));
        ContentPromotionCampaignStrategy actualStrategy = campaigns.get(0).getContentPromotionCampaign().getBiddingStrategy();
        assumeThat("получили стратегии кампании", actualStrategy, notNullValue());

        ContentPromotionCampaignStrategyMap expectedStrategy = new ContentPromotionCampaignStrategyMap()
                .withSearch(new ContentPromotionCampaignSearchStrategyMap().defaultAverageCpc(currency))
                .withNetwork(new ContentPromotionCampaignNetworkStrategyMap().defaultServingOff());

        assertThat("стратегия изменена на автобюджетную", actualStrategy,
                beanDifferV5((ContentPromotionCampaignStrategy) expectedStrategy.getBean()));
    }
}
