package ru.yandex.autotests.direct.api.campaigns.update.contentpromotion.strategy;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.campaignsext.ContentPromotionCampaignSearchStrategyTypeEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.campaignsext.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaignsext.ContentPromotionCampaignNetworkStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaignsext.ContentPromotionCampaignSearchStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaignsext.ContentPromotionCampaignStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaignsext.ContentPromotionCampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaignsext.StrategyAverageCpcMap;
import ru.yandex.autotests.directapi.model.api5.campaignsext.StrategyMaximumClicksMap;
import ru.yandex.autotests.directapi.model.api5.campaignsext.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by chicos on 25.09.2015.
 */
@Aqua.Test
@Features(CampaignsFeatures.UPDATE)
@RunWith(Parameterized.class)
@Description("Обновление динамической текстовой кампании при несоответствии имени стратегии и набора переданных " +
        "параметров стратегии")
public class StrategyNameMismatchParamsTest {
    private static final String client = CampaignsLogins.CLIENT;
    private static final Currency currency = Currency.RUB;
    private static MoneyCurrency moneyCurrency = MoneyCurrency.get(currency);
    private Long campaignId;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public String description;

    @Parameterized.Parameter(value = 1)
    public ContentPromotionCampaignSearchStrategyMap searchStrategy;

    @Parameterized.Parameter(value = 2)
    public ContentPromotionCampaignNetworkStrategyMap networkStrategy;

    @Parameterized.Parameter(value = 3)
    public ExpectedResult expectedResult;

    @Parameterized.Parameters(name = "strategy = {0}")
    public static Collection strategies() {
        Object[][] data = new Object[][]{
                //DIRECT-46091
                {"Search: несоответствие имени и параметров",
                        new ContentPromotionCampaignSearchStrategyMap()
                                .withBiddingStrategyType(
                                        ContentPromotionCampaignSearchStrategyTypeEnum.WB_MAXIMUM_CLICKS)
                                .withAverageCpc(
                                new StrategyAverageCpcMap()
                                        .withAverageCpc(moneyCurrency.getMinAveragePrice().bidLong().longValue())
                                        .withWeeklySpendLimit(
                                                moneyCurrency.getMinWeeklyBudgetAmount().bidLong().longValue())),
                        new ContentPromotionCampaignNetworkStrategyMap().defaultServingOff(),
                        ExpectedResult.errors(new Notification(4000,
                                Api5ErrorDetails.SEARCH_STRATEGY_NAME_MISMATCH_WITH_PARAMETERS))},
                {"Search: стратегия не требующая параметров",
                        new ContentPromotionCampaignSearchStrategyMap()
                                .withBiddingStrategyType(ContentPromotionCampaignSearchStrategyTypeEnum.HIGHEST_POSITION)
                                .withAverageCpc(
                                new StrategyAverageCpcMap()
                                        .withAverageCpc(moneyCurrency.getMinAveragePrice().bidLong().longValue())
                                        .withWeeklySpendLimit(
                                                moneyCurrency.getMinWeeklyBudgetAmount().bidLong().longValue())),
                        new ContentPromotionCampaignNetworkStrategyMap().defaultServingOff(),
                        ExpectedResult.errors(new Notification(4000,
                                Api5ErrorDetails.SEARCH_STRATEGY_NAME_MISMATCH_WITH_PARAMETERS))},
                //DIRECT-46816
                {"Search: стратегия без необходимых парметров",
                        new ContentPromotionCampaignSearchStrategyMap()
                                .withBiddingStrategyType(ContentPromotionCampaignSearchStrategyTypeEnum.AVERAGE_CPC),
                        new ContentPromotionCampaignNetworkStrategyMap().defaultServingOff(),
                        ExpectedResult.errors(
                                new Notification(4000, Api5ErrorDetails.STRATEGY_ON_SEARCH_MUST_CONTAINS_SETTINGS,
                                        ContentPromotionCampaignSearchStrategyTypeEnum.AVERAGE_CPC))},
                {"Search: лишние параметры стратегий",
                        new ContentPromotionCampaignSearchStrategyMap()
                                .withBiddingStrategyType(ContentPromotionCampaignSearchStrategyTypeEnum.WB_MAXIMUM_CLICKS)
                                .withAverageCpc(new StrategyAverageCpcMap()
                                        .withAverageCpc(moneyCurrency.getMinAveragePrice().bidLong().longValue())
                                        .withWeeklySpendLimit(
                                                moneyCurrency.getMinWeeklyBudgetAmount().bidLong().longValue()))
                                .withWbMaximumClicks(new StrategyMaximumClicksMap()
                                .defaultStrategyMaximumClicks(Currency.RUB)),
                        new ContentPromotionCampaignNetworkStrategyMap().defaultServingOff(),
                        ExpectedResult.errors(
                                new Notification(4000, Api5ErrorDetails.MULTIPLE_SEARCH_STRATEGY_PARAMS))},
        };
        return Arrays.asList(data);
    }

    @Before
    @Step("Подготовим данные для теста")
    public void clearUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        campaignId = api.userSteps.campExtSteps().addDefaultContentPromotionCampaign();
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("962")
    public void nameMismatchParamsTest() {
        api.userSteps.campExtSteps().shouldGetResultOnUpdate(
                new UpdateRequestMap().withCampaigns(new CampaignUpdateItemMap()
                        .withId(campaignId)
                        .withContentPromotionCampaign(new ContentPromotionCampaignUpdateItemMap()
                                .withBiddingStrategy(new ContentPromotionCampaignStrategyMap()
                                        .withSearch(searchStrategy)
                                        .withNetwork(networkStrategy)))),
                expectedResult);
    }
}
