package ru.yandex.autotests.direct.api.campaigns.update.contentpromotion.strategy;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.campaignsext.ContentPromotionCampaignSearchStrategyTypeEnum;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.campaignsext.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaignsext.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaignsext.ContentPromotionCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaignsext.ContentPromotionCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaignsext.ContentPromotionCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaignsext.ContentPromotionCampaignSearchStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaignsext.ContentPromotionCampaignStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaignsext.ContentPromotionCampaignStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaignsext.ContentPromotionCampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaignsext.StrategyAverageCpcMap;
import ru.yandex.autotests.directapi.model.api5.campaignsext.StrategyMaximumClicksMap;
import ru.yandex.autotests.directapi.model.api5.campaignsext.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.campaigns.MetrikaGoals;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by pavryabov on 23.10.15.
 */
@Aqua.Test
@Features(CampaignsFeatures.UPDATE)
@RunWith(Parameterized.class)
@Description("Обновление динамической текстовой кампании со сменой стратегии на поиске без указания всех обязательных полей новой стратегии")
@Issue("https://st.yandex-team.ru/DIRECT-46885")
public class UpdateSearchToStrategyWithoutRequiredFieldsTest {

    private static final String client = CampaignsLogins.CLIENT;
    private static final Long goalId = MetrikaGoals.getGoalsForLogin(client, 1).get(0);
    private static final Currency currency = Currency.RUB;
    private static MoneyCurrency moneyCurrency = MoneyCurrency.get(currency);
    private static Long campaignId;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public String description;

    @Parameterized.Parameter(value = 1)
    public ContentPromotionCampaignSearchStrategyMap searchStrategyUpdate;

    @Parameterized.Parameter(value = 2)
    public ExpectedResult expectedResult;

    @Parameterized.Parameters(name = "strategy = {0}")
    public static Collection strategies() {
        Object[][] data = new Object[][]{
                //DIRECT-46091
                {"WbMaximumClicks without WeeklySpendLimit",
                        new ContentPromotionCampaignSearchStrategyMap()
                                .withBiddingStrategyType(ContentPromotionCampaignSearchStrategyTypeEnum.WB_MAXIMUM_CLICKS)
                                .withWbMaximumClicks(new StrategyMaximumClicksMap()
                                .withBidCeiling(null)),
                        ExpectedResult.errors(
                                new Notification(4000, Api5ErrorDetails.WEEKLY_BUDGET_MUST_NOT_SPECIFIED))},
                {"AverageCpc without AverageCpc",
                        new ContentPromotionCampaignSearchStrategyMap()
                                .withBiddingStrategyType(ContentPromotionCampaignSearchStrategyTypeEnum.AVERAGE_CPC)
                                .withAverageCpc(new StrategyAverageCpcMap()
                                .withWeeklySpendLimit(moneyCurrency.getMinWeeklyBudgetAmount().bidLong().longValue())),
                        ExpectedResult.errors(
                                new Notification(4000, Api5ErrorDetails.AVERAGE_CPC_VALUE_NOT_SPECIFIED))},
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    @Step("Подготовим данные для теста")
    public static void addCampaign() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        campaignId = api.userSteps.campExtSteps().addCampaign(new CampaignAddItemMap()
                .defaultCampaignAddItem()
                .withContentPromotionCampaign(new ContentPromotionCampaignAddItemMap()
                        .withBiddingStrategy(new ContentPromotionCampaignStrategyAddMap()
                                .withSearch(new ContentPromotionCampaignSearchStrategyAddMap()
                                        .withBiddingStrategyType(
                                                ContentPromotionCampaignSearchStrategyTypeEnum.HIGHEST_POSITION))
                                .withNetwork(new ContentPromotionCampaignNetworkStrategyAddMap().defaultServingOff()))));
        int shard = api.userSteps.clientFakeSteps().getUserShard(client);
        api.userSteps.getDirectJooqDbSteps().useShard(shard).campMetrikaGoalsSteps()
                .addOrUpdateMetrikaGoals(campaignId, goalId, 100L, 100L);
    }

    @Before
    @Step("Подготовим данные для теста")
    public void clearUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("963")
    public void nameMismatchParamsTest() {
        //DIRECT-47698
        api.userSteps.campExtSteps().shouldGetResultOnUpdate(
                new UpdateRequestMap().withCampaigns(new CampaignUpdateItemMap()
                        .withId(campaignId)
                        .withContentPromotionCampaign(new ContentPromotionCampaignUpdateItemMap()
                                .withBiddingStrategy(new ContentPromotionCampaignStrategyMap()
                                        .withSearch(searchStrategyUpdate)))),
                expectedResult);
    }
}
