package ru.yandex.autotests.direct.api.campaigns.update.cpmbannercampaign;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.campaigns.CpmBannerCampaignNetworkStrategyTypeEnum;
import com.yandex.direct.api.v5.campaigns.DailyBudgetModeEnum;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CpmBannerCampaignNetworkStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CpmBannerCampaignSearchStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CpmBannerCampaignStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CpmBannerCampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DailyBudgetMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyWbMaximumImpressionsMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by hmepas on 20.09.18.
 */
@Aqua.Test
@Features(CampaignsFeatures.UPDATE)
@Description("Проверка установки дневного бюджета в зависимости от стратегии в медийной кампании")
@Issue("https://st.yandex-team.ru/DIRECT-84939")
@RunWith(Parameterized.class)
public class DailyBudgetStrategiesTest {

    private static final String CLIENT = CampaignsLogins.CLIENT;
    private long campaignId;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(5).as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter()
    public String description;

    @Parameterized.Parameter(1)
    public CpmBannerCampaignNetworkStrategyMap networkStrategyForCreate;

    @Parameterized.Parameter(2)
    public ExpectedResult expectedResult;

    @Parameterized.Parameters(name = "{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {"ShowsDisabled + Ручная",
                        new CpmBannerCampaignNetworkStrategyMap()
                                .withBiddingStrategyType(CpmBannerCampaignNetworkStrategyTypeEnum.MANUAL_CPM),
                        ExpectedResult.success()},
                {"ShowsDisabled + Авто",
                        new CpmBannerCampaignNetworkStrategyMap()
                                .withBiddingStrategyType(CpmBannerCampaignNetworkStrategyTypeEnum.WB_MAXIMUM_IMPRESSIONS)
                                .withWbMaximumImpressions(
                                    new StrategyWbMaximumImpressionsMap()
                                            .withAverageCpm(5000000L)
                                            .withSpendLimit(2100_000_000L)
                        ),
                        ExpectedResult.errors(
                                new Notification(6000,
                                        Api5ErrorDetails.DAILY_BUDGET_CAN_ONLY_USED_WITH_MANUAL_STRATEGIES))}
        });
    }

    private static Long minRubAmount = MoneyCurrency.get(Currency.RUB).getMinDayBudgetAmount().bidLong().longValue();

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
    }


    @Before
    public void createCampaign() {
        campaignId = api.userSteps.campaignSteps().addDefaultCpmBannerCampaign();
    }

    @Test
    public void checkAmount() {
        DailyBudgetMap dailyBudgetMap = new DailyBudgetMap()
                .withAmount(minRubAmount)
                .withMode(DailyBudgetModeEnum.STANDARD);
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(new CampaignUpdateItemMap()
                                .withId(campaignId)
                                .defaultCampaignUpdateItem().withDailyBudget(dailyBudgetMap)
                                .withCpmBannerCampaign(new CpmBannerCampaignUpdateItemMap()
                                        .withBiddingStrategy(new CpmBannerCampaignStrategyMap()
                                                .withSearch(new CpmBannerCampaignSearchStrategyMap().defaultServingOff())
                                                .withNetwork(networkStrategyForCreate)))
                        ),
                expectedResult);
    }
}
