package ru.yandex.autotests.direct.api.campaigns.update.cpmbannercampaign;

import com.yandex.direct.api.v5.campaigns.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.CampaignGetItem;
import com.yandex.direct.api.v5.campaigns.CpmBannerCampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.FrequencyCapSetting;
import com.yandex.direct.api.v5.campaigns.GetResponse;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.beans.JsonObject;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CpmBannerCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CpmBannerCampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.FrequencyCapSettingAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.FrequencyCapSettingMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;
import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.Matchers.is;
import static org.hamcrest.Matchers.nullValue;
import static org.junit.Assert.assertThat;
import static ru.yandex.autotests.direct.api.campaigns.add.cpmbannercampaign.AddFrequencyCapTest.IMPRESSIONS;
import static ru.yandex.autotests.direct.api.campaigns.add.cpmbannercampaign.AddFrequencyCapTest.MAX_IMPRESSIONS;
import static ru.yandex.autotests.direct.api.campaigns.add.cpmbannercampaign.AddFrequencyCapTest.MAX_PERIOD_DAYS;
import static ru.yandex.autotests.direct.api.campaigns.add.cpmbannercampaign.AddFrequencyCapTest.MIN_IMPRESSIONS;
import static ru.yandex.autotests.direct.api.campaigns.add.cpmbannercampaign.AddFrequencyCapTest.MIN_PERIOD_DAYS;
import static ru.yandex.autotests.direct.api.campaigns.add.cpmbannercampaign.AddFrequencyCapTest.PERIOD_DAYS;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-83722")
@Features(CampaignsFeatures.UPDATE)
@Tag(TagDictionary.TRUNK)
@Description("Проверка возможности обновить ограничение частоты показов (FrequencyCap) в медийной кампании")
public class UpdateFrequencyCapTest {

    private static String client = CampaignsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(5).as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private Long campaignId;

    @Before
    public void createCampaign() {
        campaignId = api.userSteps.campaignSteps().addDefaultCpmBannerCampaign();
    }

    @Test
    public void updateTest() {
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(
                new UpdateRequestMap().withCampaigns(new CampaignUpdateItemMap()
                        .withId(campaignId)
                        .withCpmBannerCampaign(new CpmBannerCampaignUpdateItemMap()
                                .withFrequencyCap(new FrequencyCapSettingMap()
                                        .withImpressions(IMPRESSIONS)
                                        .withPeriodDays(PERIOD_DAYS)))),
                ExpectedResult.success());

        CampaignGetItem campaign = getCampaignItem();

        assertThat("Поле Impression обновлено",
                campaign.getCpmBannerCampaign().getFrequencyCap().getValue().getImpressions(), is(IMPRESSIONS));
        assertThat("Поле PeriodDays обновлено",
                campaign.getCpmBannerCampaign().getFrequencyCap().getValue().getPeriodDays(), is(PERIOD_DAYS));
    }

    @Test
    public void updateWithNullPeriodDaysTest() {
        campaignId = api.userSteps.campaignSteps().addCampaign(
                new CampaignAddItemMap()
                        .defaultCampaignAddItem()
                        .withDefaultCpmBannerCampaign()
                        .withCpmBannerCampaign(
                                new CpmBannerCampaignAddItemMap()
                                        .defaultCpmBannerCampaign()
                                        .withFrequencyCap(
                                                new FrequencyCapSettingAddMap()
                                                        .withImpressions(IMPRESSIONS)
                                                        .withPeriodDays(PERIOD_DAYS))));

        FrequencyCapSetting frequencyCap = getCampaignItem().getCpmBannerCampaign().getFrequencyCap().getValue();

        assumeThat("Поле Impression установлено", frequencyCap.getImpressions(), is(IMPRESSIONS));
        assumeThat("Поле PeriodDays установлено", frequencyCap.getPeriodDays(), is(PERIOD_DAYS));

        JsonObject campaignRequest = new JsonObject()
                .with("Id", campaignId)
                .with(capitalize(CampaignUpdateItemMap.CPM_BANNER_CAMPAIGN),
                        new JsonObject()
                                .with(capitalize(CpmBannerCampaignUpdateItemMap.FREQUENCY_CAP),
                                        new JsonObject()
                                                .with(capitalize(FrequencyCapSettingAddMap.IMPRESSIONS), IMPRESSIONS)
                                                .with(capitalize(FrequencyCapSettingAddMap.PERIOD_DAYS), "null")));

        JsonObject updateRequest = new JsonObject().with("Campaigns", new JsonObject[]{campaignRequest});

        api.userSteps.campaignSteps().shouldGetResultOnUpdate(updateRequest, ExpectedResult.success());

        frequencyCap = getCampaignItem().getCpmBannerCampaign().getFrequencyCap().getValue();

        assertThat("Поле Impression обновлено", frequencyCap.getImpressions(), is(IMPRESSIONS));
        assertThat("Поле PeriodDays обновлено", frequencyCap.getPeriodDays(), nullValue());
    }

    @Test
    @Ignore("включить тест в DIRECT-160854")
    public void updateWithOnlyImpressionsFieldTest() {
        api.userSteps.campaignSteps().expectErrorOnCampaignsUpdate(
                new UpdateRequestMap().withCampaigns(new CampaignUpdateItemMap()
                        .withId(campaignId)
                        .withCpmBannerCampaign(new CpmBannerCampaignUpdateItemMap()
                                .withFrequencyCap(new FrequencyCapSettingMap()
                                        .withImpressions(IMPRESSIONS)))),
                new Api5Error(8000, Api5ErrorDetails.MISSING_REQUIRED_FIELD,
                        capitalize(CpmBannerCampaignAddItemMap.FREQUENCY_CAP),
                        capitalize(FrequencyCapSettingAddMap.PERIOD_DAYS)));
    }

    @Test
    public void updateWithMinImpressions() {
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(
                new UpdateRequestMap().withCampaigns(new CampaignUpdateItemMap()
                        .withId(campaignId)
                        .withCpmBannerCampaign(new CpmBannerCampaignUpdateItemMap()
                                .withFrequencyCap(new FrequencyCapSettingMap()
                                        .withImpressions(MIN_IMPRESSIONS)
                                        .withPeriodDays(PERIOD_DAYS)))),
                ExpectedResult.success());
    }

    @Test
    public void updateWithMaxImpressions() {
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(
                new UpdateRequestMap().withCampaigns(new CampaignUpdateItemMap()
                        .withId(campaignId)
                        .withCpmBannerCampaign(new CpmBannerCampaignUpdateItemMap()
                                .withFrequencyCap(new FrequencyCapSettingMap()
                                        .withImpressions(MAX_IMPRESSIONS)
                                        .withPeriodDays(PERIOD_DAYS)))),
                ExpectedResult.success());
    }

    @Test
    public void updateWithMinPeriodDays() {
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(
                new UpdateRequestMap().withCampaigns(new CampaignUpdateItemMap()
                        .withId(campaignId)
                        .withCpmBannerCampaign(new CpmBannerCampaignUpdateItemMap()
                                .withFrequencyCap(new FrequencyCapSettingMap()
                                        .withImpressions(IMPRESSIONS)
                                        .withPeriodDays(MIN_PERIOD_DAYS)))),
                ExpectedResult.success());
    }

    @Test
    public void updateWithMaxPeriodDays() {
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(
                new UpdateRequestMap().withCampaigns(new CampaignUpdateItemMap()
                        .withId(campaignId)
                        .withCpmBannerCampaign(new CpmBannerCampaignUpdateItemMap()
                                .withFrequencyCap(new FrequencyCapSettingMap()
                                        .withImpressions(IMPRESSIONS)
                                        .withPeriodDays(MAX_PERIOD_DAYS)))),
                ExpectedResult.success());
    }

    @Test
    public void updateWithMaxImpressionPlusOne() {
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(
                new UpdateRequestMap().withCampaigns(new CampaignUpdateItemMap()
                        .withId(campaignId)
                        .withCpmBannerCampaign(new CpmBannerCampaignUpdateItemMap()
                                .withFrequencyCap(new FrequencyCapSettingMap()
                                        .withImpressions(MAX_IMPRESSIONS + 1)
                                        .withPeriodDays(PERIOD_DAYS)))),
                JavaOrPerlExpectedResult
                        .java(ExpectedResult.errors(new Notification(5005,
                                Api5ErrorDetailsJava.FIELD_MUST_BE_IN_RANGE_FROM_TO,
                                capitalize(FrequencyCapSettingAddMap.IMPRESSIONS), MIN_IMPRESSIONS, MAX_IMPRESSIONS)))
                        .perl(ExpectedResult.errors(new Notification(5005,
                                Api5ErrorDetails.FIELD_MUST_BE_IN_RANGE_FROM_TO,
                                capitalize(FrequencyCapSettingAddMap.IMPRESSIONS), MIN_IMPRESSIONS, MAX_IMPRESSIONS))));
    }

    @Test
    public void updateWithMinPeriodDaysMinusOne() {
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(
                new UpdateRequestMap().withCampaigns(new CampaignUpdateItemMap()
                        .withId(campaignId)
                        .withCpmBannerCampaign(new CpmBannerCampaignUpdateItemMap()
                                .withFrequencyCap(new FrequencyCapSettingMap()
                                        .withImpressions(IMPRESSIONS)
                                        .withPeriodDays(MIN_PERIOD_DAYS - 1)))),
                JavaOrPerlExpectedResult
                        .java(ExpectedResult.errors(new Notification(5005,
                                Api5ErrorDetailsJava.FIELD_MUST_BE_IN_RANGE_FROM_TO,
                                capitalize(FrequencyCapSettingAddMap.PERIOD_DAYS), MIN_PERIOD_DAYS, MAX_PERIOD_DAYS)))
                        .perl(ExpectedResult.errors(new Notification(5005,
                                Api5ErrorDetails.FIELD_MUST_BE_IN_RANGE_FROM_TO,
                                capitalize(FrequencyCapSettingAddMap.PERIOD_DAYS), MIN_PERIOD_DAYS, MAX_PERIOD_DAYS))));
    }

    @Test
    public void updateWithMaxPeriodDaysPlusOne() {
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(
                new UpdateRequestMap().withCampaigns(new CampaignUpdateItemMap()
                        .withId(campaignId)
                        .withCpmBannerCampaign(new CpmBannerCampaignUpdateItemMap()
                                .withFrequencyCap(new FrequencyCapSettingMap()
                                        .withImpressions(IMPRESSIONS)
                                        .withPeriodDays(MAX_PERIOD_DAYS + 1)))),
                JavaOrPerlExpectedResult
                        .java(ExpectedResult.errors(new Notification(5005,
                                Api5ErrorDetailsJava.FIELD_MUST_BE_IN_RANGE_FROM_TO,
                                capitalize(FrequencyCapSettingAddMap.PERIOD_DAYS), MIN_PERIOD_DAYS, MAX_PERIOD_DAYS)))
                        .perl(ExpectedResult.errors(new Notification(5005,
                                Api5ErrorDetails.FIELD_MUST_BE_IN_RANGE_FROM_TO,
                                capitalize(FrequencyCapSettingAddMap.PERIOD_DAYS), MIN_PERIOD_DAYS, MAX_PERIOD_DAYS))));
    }

    @Test
    public void updateWithMinImpressionsMinusOne() {
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(
                new UpdateRequestMap().withCampaigns(new CampaignUpdateItemMap()
                        .withId(campaignId)
                        .withCpmBannerCampaign(new CpmBannerCampaignUpdateItemMap()
                                .withFrequencyCap(new FrequencyCapSettingMap()
                                        .withImpressions(MIN_IMPRESSIONS - 1)
                                        .withPeriodDays(PERIOD_DAYS)))),
                JavaOrPerlExpectedResult
                        .java(ExpectedResult.errors(new Notification(5005,
                                Api5ErrorDetailsJava.FIELD_MUST_BE_IN_RANGE_FROM_TO,
                                capitalize(FrequencyCapSettingAddMap.IMPRESSIONS), MIN_IMPRESSIONS, MAX_IMPRESSIONS)))
                        .perl(ExpectedResult.errors(new Notification(5005,
                                Api5ErrorDetails.FIELD_MUST_BE_IN_RANGE_FROM_TO,
                                capitalize(FrequencyCapSettingAddMap.IMPRESSIONS), MIN_IMPRESSIONS, MAX_IMPRESSIONS))));
    }

    private CampaignGetItem getCampaignItem() {
        GetResponse response = api.as(client).userSteps.campaignSteps().campaignsGet(
                new GetRequestMap().withSelectionCriteria(
                        new CampaignsSelectionCriteriaMap()
                                .withIds(campaignId))
                        .withFieldNames(CampaignFieldEnum.ID)
                        .withCpmBannerCampaignFieldNames(CpmBannerCampaignFieldEnum.FREQUENCY_CAP));

        assumeThat("Вернулась 1 кампания", response.getCampaigns(), hasSize(1));

        return response.getCampaigns().get(0);
    }
}
