package ru.yandex.autotests.direct.api.campaigns.update.cpmbannercampaign;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.campaigns.CpmBannerCampaignNetworkStrategyTypeEnum;
import com.yandex.direct.api.v5.campaigns.DailyBudgetModeEnum;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CpmBannerCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CpmBannerCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CpmBannerCampaignNetworkStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CpmBannerCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CpmBannerCampaignStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CpmBannerCampaignStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CpmBannerCampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DailyBudgetMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyCpDecreasedPriceForRepeatedImpressionsMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyCpMaximumImpressionsMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyWbDecreasedPriceForRepeatedImpressionsMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyWbMaximumImpressionsMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by gerdler on 23.09.18.
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-84939")
@Features(CampaignsFeatures.UPDATE)
@Description("Одновременное обновление в медийной кампании стратегии с ручной на авто и установка дневного бюджета")
@RunWith(Parameterized.class)
public class UpdateStrategyFromManualToAutoAndSetDailyBudgetTest {

    private static String client = CampaignsLogins.UPDATE_CLIENT;
    private static final long averageCpm = MoneyCurrency.get(Currency.RUB).getMinCpmPrice().bidLong().longValue();
    private static final long spendLimit = 2100_000_000L;
    @ClassRule
    public static ApiSteps api = new ApiSteps().version(5).as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private Long id;
    private static Long minRubAmount = MoneyCurrency.get(Currency.RUB).getMinDayBudgetAmount().bidLong().longValue();

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public CpmBannerCampaignNetworkStrategyMap networkStrategy;

    @Parameterized.Parameters(name = "{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {
                    "Ручная -> WbMaximumImpressions",
                    new CpmBannerCampaignNetworkStrategyMap()
                            .withBiddingStrategyType(
                                    CpmBannerCampaignNetworkStrategyTypeEnum.WB_MAXIMUM_IMPRESSIONS
                            )
                            .withWbMaximumImpressions(
                                new StrategyWbMaximumImpressionsMap().withDefaultWbMaximumImpressions(averageCpm, spendLimit)
                            )
                },
                {
                    "Ручная -> CpMaximumImpressions",
                    new CpmBannerCampaignNetworkStrategyMap()
                            .withBiddingStrategyType(
                                    CpmBannerCampaignNetworkStrategyTypeEnum.CP_MAXIMUM_IMPRESSIONS
                            )
                            .withCpMaximumImpressions(
                                new StrategyCpMaximumImpressionsMap().withDefaultCpMaximumImpressions(averageCpm, spendLimit)
                            )
                },
                {
                        "Ручная -> WbDecreasedPriceForRepeatedImpressions",
                        new CpmBannerCampaignNetworkStrategyMap()
                                .withBiddingStrategyType(
                                        CpmBannerCampaignNetworkStrategyTypeEnum.WB_DECREASED_PRICE_FOR_REPEATED_IMPRESSIONS
                                )
                                .withWbDecreasedPriceForRepeatedImpressions(
                                    new StrategyWbDecreasedPriceForRepeatedImpressionsMap().withDefaultWbDecreasedPriceForRepeatedImpressions(averageCpm, spendLimit)
                        )
                },
                {
                        "Ручная -> CpDecreasedPriceForRepeatedImpressions",
                        new CpmBannerCampaignNetworkStrategyMap()
                                .withBiddingStrategyType(
                                        CpmBannerCampaignNetworkStrategyTypeEnum.CP_DECREASED_PRICE_FOR_REPEATED_IMPRESSIONS
                                )
                                .withCpDecreasedPriceForRepeatedImpressions(
                                    new StrategyCpDecreasedPriceForRepeatedImpressionsMap().withDefaultCpDecreasedPriceForRepeatedImpressions(averageCpm, spendLimit)
                        )
                },
        });
    }

    @BeforeClass
    public static void prepareClient() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
    }

    @Before
    public void createCampaign() {
        id = api.userSteps.campaignSteps().addCampaign(new CampaignAddItemMap()
                .defaultCampaignAddItem()
                .withCpmBannerCampaign(new CpmBannerCampaignAddItemMap()
                        .withBiddingStrategy(new CpmBannerCampaignStrategyAddMap()
                                .withSearch(new CpmBannerCampaignSearchStrategyAddMap().defaultServingOff())
                                .withNetwork(new CpmBannerCampaignNetworkStrategyAddMap()
                                        .withBiddingStrategyType(CpmBannerCampaignNetworkStrategyTypeEnum.MANUAL_CPM)))));
    }

    @Test
    public void updateDailyBudget() {
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(new CampaignUpdateItemMap()
                                .withId(id)
                                .withDailyBudget(new DailyBudgetMap()
                                        .withAmount(minRubAmount)
                                        .withMode(DailyBudgetModeEnum.STANDARD))
                                .withCpmBannerCampaign(new CpmBannerCampaignUpdateItemMap()
                                        .withBiddingStrategy(new CpmBannerCampaignStrategyMap()
                                                .withNetwork(networkStrategy)))
                        ),
                ExpectedResult.errors(new Notification(6000,
                        Api5ErrorDetails.DAILY_BUDGET_CAN_ONLY_USED_WITH_MANUAL_STRATEGIES)));
    }
}
