package ru.yandex.autotests.direct.api.campaigns.update.cpmbannercampaign.strategy;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.campaigns.CpmBannerCampaignNetworkStrategyTypeEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CpmBannerCampaignNetworkStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CpmBannerCampaignSearchStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CpmBannerCampaignStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CpmBannerCampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyWbDecreasedPriceForRepeatedImpressionsMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyWbMaximumImpressionsMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

@Aqua.Test
@Features(CampaignsFeatures.UPDATE)
@RunWith(Parameterized.class)
@Description("Обновление кампании при несоответствии имени стратегии и набора переданных параметров стратегии")
public class StrategyNameMismatchParamsTest {
    private static final String client = CampaignsLogins.CLIENT;
    private static final Currency currency = Currency.RUB;
    private static MoneyCurrency moneyCurrency = MoneyCurrency.get(currency);

    private Long campaignId;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public String description;

    @Parameterized.Parameter(value = 1)
    public CpmBannerCampaignSearchStrategyMap searchStrategy;

    @Parameterized.Parameter(value = 2)
    public CpmBannerCampaignNetworkStrategyMap networkStrategy;

    @Parameterized.Parameter(value = 3)
    public ExpectedResult expectedResult;

    @Parameterized.Parameters(name = "strategy = {0}")
    public static Collection strategies() {
        Object[][] data = new Object[][]{
                {"Network: несоответствие имени и параметров",
                        new CpmBannerCampaignSearchStrategyMap().defaultServingOff(),
                        new CpmBannerCampaignNetworkStrategyMap()
                                .withBiddingStrategyType(CpmBannerCampaignNetworkStrategyTypeEnum.CP_MAXIMUM_IMPRESSIONS)
                                .withWbMaximumImpressions(new StrategyWbMaximumImpressionsMap()
                                .withAverageCpm(moneyCurrency.getMinAveragePrice().bidLong().longValue())
                                .withSpendLimit(moneyCurrency.getMinWeeklyBudgetAmount().bidLong().longValue())),
                        ExpectedResult.errors(new Notification(4000,
                                Api5ErrorDetails.NETWORK_STRATEGY_NAME_MISMATCH_WITH_PARAMETERS))},
                {"Network: стратегия не требующая параметров",
                        new CpmBannerCampaignSearchStrategyMap().defaultServingOff(),
                        new CpmBannerCampaignNetworkStrategyMap()
                                .withBiddingStrategyType(CpmBannerCampaignNetworkStrategyTypeEnum.MANUAL_CPM)
                                .withWbMaximumImpressions(new StrategyWbMaximumImpressionsMap()
                                .withAverageCpm(moneyCurrency.getMinAveragePrice().bidLong().longValue())
                                .withSpendLimit(moneyCurrency.getMinWeeklyBudgetAmount().bidLong().longValue())),
                        ExpectedResult.errors(new Notification(4000,
                                Api5ErrorDetails.NETWORK_STRATEGY_NAME_MISMATCH_WITH_PARAMETERS))},
                {"Network: стратегия без необходимых парметров",
                        new CpmBannerCampaignSearchStrategyMap().defaultServingOff(),
                        new CpmBannerCampaignNetworkStrategyMap()
                                .withBiddingStrategyType(CpmBannerCampaignNetworkStrategyTypeEnum.WB_MAXIMUM_IMPRESSIONS),
                        ExpectedResult.errors(
                                new Notification(4000, Api5ErrorDetails.STRATEGY_ON_NETWORK_MUST_CONTAINS_SETTINGS,
                                        CpmBannerCampaignNetworkStrategyTypeEnum.WB_MAXIMUM_IMPRESSIONS))},
                {"Network: лишние параметры стратегий",
                        new CpmBannerCampaignSearchStrategyMap().defaultServingOff(),
                        new CpmBannerCampaignNetworkStrategyMap()
                                .withBiddingStrategyType(CpmBannerCampaignNetworkStrategyTypeEnum.WB_MAXIMUM_IMPRESSIONS)
                                .withWbMaximumImpressions(new StrategyWbMaximumImpressionsMap()
                                        .withAverageCpm(moneyCurrency.getMinAveragePrice().bidLong().longValue())
                                        .withSpendLimit(moneyCurrency.getMinWeeklyBudgetAmount().bidLong().longValue()))
                                .withWbDecreasedPriceForRepeatedImpressions(new StrategyWbDecreasedPriceForRepeatedImpressionsMap()
                                .withAverageCpm(moneyCurrency.getMinAveragePrice().bidLong().longValue())
                                .withSpendLimit(moneyCurrency.getMinWeeklyBudgetAmount().bidLong().longValue())),
                        ExpectedResult.errors(
                                new Notification(4000, Api5ErrorDetails.MULTIPLE_NETWORK_STRATEGY_PARAMS))}
        };
        return Arrays.asList(data);
    }

    @Before
    @Step("Подготовим данные для теста")
    public void clearUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        campaignId = api.userSteps.campaignSteps().addDefaultCpmBannerCampaign();
    }

    @Test
    public void nameMismatchParamsTest() {
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(
                new UpdateRequestMap().withCampaigns(new CampaignUpdateItemMap()
                        .withId(campaignId)
                        .withCpmBannerCampaign(new CpmBannerCampaignUpdateItemMap()
                                .withBiddingStrategy(new CpmBannerCampaignStrategyMap()
                                        .withSearch(searchStrategy)
                                        .withNetwork(networkStrategy)))),
                expectedResult);
    }
}
