package ru.yandex.autotests.direct.api.campaigns.update.cpmbannercampaign.strategy.base;

import java.sql.Date;
import java.util.List;

import com.yandex.direct.api.v5.campaigns.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.CampaignGetItem;
import com.yandex.direct.api.v5.campaigns.CpmBannerCampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.CpmBannerCampaignNetworkStrategyTypeEnum;
import com.yandex.direct.api.v5.campaigns.CpmBannerCampaignStrategy;
import com.yandex.direct.api.v5.campaigns.UpdateResponse;
import com.yandex.direct.api.v5.general.YesNoEnum;
import org.joda.time.DateTime;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.campaigns.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CpmBannerCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CpmBannerCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CpmBannerCampaignNetworkStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CpmBannerCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CpmBannerCampaignSearchStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CpmBannerCampaignStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CpmBannerCampaignStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CpmBannerCampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyCpMaximumImpressionsAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyCpMaximumImpressionsMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap.DATE_PATTERN;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

@Aqua.Test
@Features(CampaignsFeatures.UPDATE)
@Description("Сценарии проверки параметра AverageCpm при обновлении кампаний")
public class StrategiesAverageCpmUpdateInProgressTest {

    private static final String CLIENT = CampaignsLogins.CLIENT;
    private static final Currency CURRENCY = Currency.RUB;
    private static final MoneyCurrency MONEY_CURRENCY = MoneyCurrency.get(CURRENCY);

    private static final Money MIN_PRICE = MONEY_CURRENCY.getMinCpmPrice();
    private static final Money MAX_PRICE = MONEY_CURRENCY.getMaxCpmPrice();

    private static final String START_DATE = DateTime.now().minusDays(2).toString(DATE_PATTERN);
    private static final String END_DATE = DateTime.now().plusDays(2).toString(DATE_PATTERN);
    private static final String NEW_END_DATE = DateTime.now().plusDays(4).toString(DATE_PATTERN);

    private static final Long SPEND_LIMIT = MONEY_CURRENCY.getMaxDailyBudgetForPeriod().bidLong().longValue();
    private static final Long NEW_SPEND_LIMIT = MONEY_CURRENCY.getMaxDailyBudgetForPeriod().multiply(2).bidLong().longValue();

    private static final Long AVG_PRICE = MAX_PRICE.bidLong().longValue();

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private long campaignId;

    @BeforeClass
    @Step("Подготовим данные для теста")
    public static void clearUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
    }

    @Before
    public void createCampaign() {
        // Создать стратегию с датой старта в прошлом нельзя
        // Поэтому для симуляции активного периода создаем стратегию с датой начала "сегодня", а затем меняем дату старта на более раннюю.
        String temporaryStartDate = DateTime.now().plusDays(1).toString(DATE_PATTERN);

        List<Long> ids = api.userSteps.campaignSteps().campaignsAddWithCheck(
                new AddRequestMap().withCampaigns(new CampaignAddItemMap()
                        .defaultCampaignAddItem()
                        .withCpmBannerCampaign(new CpmBannerCampaignAddItemMap()
                                .withBiddingStrategy(new CpmBannerCampaignStrategyAddMap()
                                        .withSearch(new CpmBannerCampaignSearchStrategyAddMap().defaultServingOff())
                                        .withNetwork(
                                                new CpmBannerCampaignNetworkStrategyAddMap()
                                                        .withBiddingStrategyType(
                                                                CpmBannerCampaignNetworkStrategyTypeEnum.CP_MAXIMUM_IMPRESSIONS
                                                        )
                                                        .withCpMaximumImpressions(
                                                                new StrategyCpMaximumImpressionsAddMap()
                                                                        .withStartDate(temporaryStartDate)
                                                                        .withEndDate(END_DATE)
                                                                        .withAverageCpm(AVG_PRICE)
                                                                        .withSpendLimit(SPEND_LIMIT)
                                                                        .withAutoContinue(YesNoEnum.YES))

                                        )))));

        assumeThat("создана кампания", ids, hasSize(1));
        campaignId = ids.get(0);

        //передвигаем дату старта на несколько дней раньше, т.о делаем период стратегии активным.
        api.userSteps.getDirectJooqDbSteps().useShardForLogin(CLIENT).campaignsSteps().setStartDate(campaignId, Date.valueOf(START_DATE));
        api.userSteps.getDirectJooqDbSteps().useShardForLogin(CLIENT).campaignsSteps().setStrategyDataStartIfExists(campaignId, START_DATE);
    }

    private static void getCampaignStrategyAndCheck(Long campaignId, CpmBannerCampaignStrategy expectedStrategyBean) {
        List<CampaignGetItem> campaigns = api.userSteps.campaignSteps().getCampaigns(
                new GetRequestMap().withSelectionCriteria(new CampaignsSelectionCriteriaMap()
                        .withIds(campaignId))
                        .withFieldNames(CampaignFieldEnum.ID)
                        .withCpmBannerCampaignFieldNames(CpmBannerCampaignFieldEnum.BIDDING_STRATEGY));

        assumeThat("получили кампанию", campaigns, hasSize(1));
        CpmBannerCampaignStrategy actualStrategy = campaigns.get(0).getCpmBannerCampaign().getBiddingStrategy();

        assumeThat("получили стратегии кампании", actualStrategy, notNullValue());

        assertThat("получили корректные стратегии", actualStrategy,
                beanDifferV5(expectedStrategyBean));
    }

    @Test
    public void updateAvgBidDuringActivePeriod() {
        CpmBannerCampaignStrategyMap strategyMap = new CpmBannerCampaignStrategyMap()
                        .withSearch(new CpmBannerCampaignSearchStrategyMap().defaultServingOff())
                        .withNetwork(new CpmBannerCampaignNetworkStrategyMap()
                                .withBiddingStrategyType(
                                        CpmBannerCampaignNetworkStrategyTypeEnum.CP_MAXIMUM_IMPRESSIONS
                                )
                                .withCpMaximumImpressions(
                                        new StrategyCpMaximumImpressionsMap()
                                                .withStartDate(START_DATE)
                                                .withEndDate(END_DATE)
                                                .withAutoContinue(YesNoEnum.YES)
                                                .withAverageCpm(MIN_PRICE.bidLong().longValue())
                                                .withSpendLimit(SPEND_LIMIT)));

        UpdateResponse response = api.userSteps.campaignSteps().shouldGetResultOnUpdate(
                new UpdateRequestMap().withCampaigns(new CampaignUpdateItemMap()
                                .withId(campaignId)
                                .withCpmBannerCampaign(new CpmBannerCampaignUpdateItemMap()
                                                .withBiddingStrategy(strategyMap))),
                ExpectedResult.success());

        getCampaignStrategyAndCheck(response.getUpdateResults().get(0).getId(),
                (CpmBannerCampaignStrategy) strategyMap.getBean());
    }

    @Test
    public void updateBudgetDuringActivePeriod() {
        CpmBannerCampaignStrategyMap strategyMap = new CpmBannerCampaignStrategyMap()
                .withSearch(new CpmBannerCampaignSearchStrategyMap().defaultServingOff())
                .withNetwork(new CpmBannerCampaignNetworkStrategyMap()
                        .withBiddingStrategyType(
                                CpmBannerCampaignNetworkStrategyTypeEnum.CP_MAXIMUM_IMPRESSIONS
                        )
                        .withCpMaximumImpressions(
                                new StrategyCpMaximumImpressionsMap()
                                        .withStartDate(START_DATE)
                                        .withEndDate(END_DATE)
                                        .withAutoContinue(YesNoEnum.YES)
                                        .withAverageCpm(AVG_PRICE)
                                        .withSpendLimit(NEW_SPEND_LIMIT)));


        UpdateResponse response = api.userSteps.campaignSteps().shouldGetResultOnUpdate(
                new UpdateRequestMap().withCampaigns(
                        new CampaignUpdateItemMap()
                                .withId(campaignId)
                                .withCpmBannerCampaign(
                                        new CpmBannerCampaignUpdateItemMap()
                                                .withBiddingStrategy(strategyMap))),
                ExpectedResult.success());

        getCampaignStrategyAndCheck(response.getUpdateResults().get(0).getId(),
                (CpmBannerCampaignStrategy) strategyMap.getBean());
    }

    @Test
    public void updateEndDateDuringActivePeriod() {
        CpmBannerCampaignStrategyMap strategyMap = new CpmBannerCampaignStrategyMap()
                .withSearch(new CpmBannerCampaignSearchStrategyMap().defaultServingOff())
                .withNetwork(new CpmBannerCampaignNetworkStrategyMap()
                        .withBiddingStrategyType(
                                CpmBannerCampaignNetworkStrategyTypeEnum.CP_MAXIMUM_IMPRESSIONS
                        )
                        .withCpMaximumImpressions(
                                new StrategyCpMaximumImpressionsMap()
                                        .withStartDate(START_DATE)
                                        .withEndDate(NEW_END_DATE)
                                        .withAutoContinue(YesNoEnum.YES)
                                        .withAverageCpm(AVG_PRICE)
                                        .withSpendLimit(SPEND_LIMIT)));

        UpdateResponse response = api.userSteps.campaignSteps().shouldGetResultOnUpdate(
                new UpdateRequestMap().withCampaigns(
                        new CampaignUpdateItemMap()
                                .withId(campaignId)
                                .withCpmBannerCampaign(
                                        new CpmBannerCampaignUpdateItemMap()
                                                .withBiddingStrategy(strategyMap))),
                ExpectedResult.success());

        getCampaignStrategyAndCheck(response.getUpdateResults().get(0).getId(),
                (CpmBannerCampaignStrategy) strategyMap.getBean());
    }
}
