package ru.yandex.autotests.direct.api.campaigns.update.cpmbannercampaign.strategy.cp;

import com.yandex.direct.api.v5.campaigns.CpmBannerCampaignNetworkStrategyTypeEnum;
import com.yandex.direct.api.v5.general.YesNoEnum;
import org.joda.time.DateTime;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CpmBannerCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CpmBannerCampaignNetworkStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CpmBannerCampaignSearchStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CpmBannerCampaignStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CpmBannerCampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyCpDecreasedPriceForRepeatedImpressionsMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyCpMaximumImpressionsAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyCpMaximumImpressionsMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;
import static ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap.DATE_PATTERN;

@Aqua.Test
@Features(CampaignsFeatures.UPDATE)
@Description("Негативные сценарии проверки параметра AutoContinue при обновлении кампании со стратегиями с произвольным периодом")
public class StrategiesCustomPeriodRequiredFieldTest {

    private static final String CLIENT = CampaignsLogins.CLIENT;
    private static final Currency CURRENCY = Currency.RUB;
    private static final MoneyCurrency MONEY_CURRENCY = MoneyCurrency.get(CURRENCY);

    private static final long AVERAGE_CPM = MONEY_CURRENCY.getMinCpmPrice().bidLong().longValue();
    private static final long SPEND_LIMIT = MONEY_CURRENCY.getMinDailyBudgetForPeriod().bidLong().longValue();

    private static final String START_DATE = DateTime.now().plusDays(1).toString(DATE_PATTERN);
    private static final String END_DATE = START_DATE;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private Long campaignId;

    @Before
    public void createCampaign() {
        campaignId = api.userSteps.campaignSteps().addDefaultCpmBannerCampaign();
    }

    @Test
    public void cpMaximumImpressionsAutoContinueMissingTest() {
        api.userSteps.campaignSteps().expectErrorOnCampaignsUpdate(
                new UpdateRequestMap().withCampaigns(new CampaignUpdateItemMap()
                        .withId(campaignId)
                        .withEndDate(END_DATE)
                        .withCpmBannerCampaign(new CpmBannerCampaignUpdateItemMap()
                                .withBiddingStrategy(new CpmBannerCampaignStrategyMap()
                                        .withSearch(new CpmBannerCampaignSearchStrategyMap().defaultServingOff())
                                        .withNetwork(
                                                new CpmBannerCampaignNetworkStrategyMap()
                                                        .withBiddingStrategyType(
                                                                CpmBannerCampaignNetworkStrategyTypeEnum.CP_MAXIMUM_IMPRESSIONS
                                                        )
                                                        .withCpMaximumImpressions(
                                                                new StrategyCpMaximumImpressionsMap()
                                                                        .withStartDate(START_DATE)
                                                                        .withEndDate(END_DATE)
                                                                        .withAverageCpm(AVERAGE_CPM)
                                                                        .withSpendLimit(SPEND_LIMIT)))))),
                new Api5Error(8000, Api5ErrorDetails.MISSING_REQUIRED_FIELD,
                        capitalize(CpmBannerCampaignNetworkStrategyAddMap.CP_MAXIMUM_IMPRESSIONS),
                        capitalize(StrategyCpMaximumImpressionsAddMap.AUTO_CONTINUE)));
    }

    @Test
    public void cpDecreasedPriceForRepeatedImpressionsAutoContinueMissingTest() {
        api.userSteps.campaignSteps().expectErrorOnCampaignsUpdate(
                new UpdateRequestMap().withCampaigns(new CampaignUpdateItemMap()
                        .withId(campaignId)
                        .withEndDate(END_DATE)
                        .withCpmBannerCampaign(new CpmBannerCampaignUpdateItemMap()
                                .withBiddingStrategy(new CpmBannerCampaignStrategyMap()
                                        .withSearch(new CpmBannerCampaignSearchStrategyMap().defaultServingOff())
                                        .withNetwork(
                                                new CpmBannerCampaignNetworkStrategyMap()
                                                        .withBiddingStrategyType(
                                                                CpmBannerCampaignNetworkStrategyTypeEnum.CP_DECREASED_PRICE_FOR_REPEATED_IMPRESSIONS
                                                        )
                                                        .withCpDecreasedPriceForRepeatedImpressions(
                                                                new StrategyCpDecreasedPriceForRepeatedImpressionsMap()
                                                                        .withStartDate(START_DATE)
                                                                        .withEndDate(END_DATE)
                                                                        .withAverageCpm(AVERAGE_CPM)
                                                                        .withSpendLimit(SPEND_LIMIT)))))),
                new Api5Error(8000, Api5ErrorDetails.MISSING_REQUIRED_FIELD,
                        capitalize(CpmBannerCampaignNetworkStrategyAddMap.CP_DECREASED_PRICE_FOR_REPEATED_IMPRESSIONS),
                        capitalize(StrategyCpMaximumImpressionsAddMap.AUTO_CONTINUE)));
    }

    @Test
    public void cpMaximumImpressionsStartDateMissingTest() {
        api.userSteps.campaignSteps().expectErrorOnCampaignsUpdate(
                new UpdateRequestMap().withCampaigns(new CampaignUpdateItemMap()
                        .withId(campaignId)
                        .withEndDate(END_DATE)
                        .withCpmBannerCampaign(new CpmBannerCampaignUpdateItemMap()
                                .withBiddingStrategy(new CpmBannerCampaignStrategyMap()
                                        .withSearch(new CpmBannerCampaignSearchStrategyMap().defaultServingOff())
                                        .withNetwork(
                                                new CpmBannerCampaignNetworkStrategyMap()
                                                        .withBiddingStrategyType(
                                                                CpmBannerCampaignNetworkStrategyTypeEnum.CP_MAXIMUM_IMPRESSIONS
                                                        )
                                                        .withCpMaximumImpressions(
                                                                new StrategyCpMaximumImpressionsMap()
                                                                        .withEndDate(END_DATE)
                                                                        .withAverageCpm(AVERAGE_CPM)
                                                                        .withSpendLimit(SPEND_LIMIT)
                                                                        .withAutoContinue(YesNoEnum.YES)))))),
                new Api5Error(8000, Api5ErrorDetails.MISSING_REQUIRED_FIELD,
                        capitalize(CpmBannerCampaignNetworkStrategyAddMap.CP_MAXIMUM_IMPRESSIONS),
                        capitalize(StrategyCpMaximumImpressionsAddMap.START_DATE)));
    }

    @Test
    public void cpDecreasedPriceForRepeatedImpressionsStartDateMissingTest() {
        api.userSteps.campaignSteps().expectErrorOnCampaignsUpdate(
                new UpdateRequestMap().withCampaigns(new CampaignUpdateItemMap()
                        .withId(campaignId)
                        .withEndDate(END_DATE)
                        .withCpmBannerCampaign(new CpmBannerCampaignUpdateItemMap()
                                .withBiddingStrategy(new CpmBannerCampaignStrategyMap()
                                        .withSearch(new CpmBannerCampaignSearchStrategyMap().defaultServingOff())
                                        .withNetwork(
                                                new CpmBannerCampaignNetworkStrategyMap()
                                                        .withBiddingStrategyType(
                                                                CpmBannerCampaignNetworkStrategyTypeEnum.CP_DECREASED_PRICE_FOR_REPEATED_IMPRESSIONS
                                                        )
                                                        .withCpDecreasedPriceForRepeatedImpressions(
                                                                new StrategyCpDecreasedPriceForRepeatedImpressionsMap()
                                                                        .withEndDate(END_DATE)
                                                                        .withAverageCpm(AVERAGE_CPM)
                                                                        .withSpendLimit(SPEND_LIMIT)
                                                                        .withAutoContinue(YesNoEnum.YES)))))),
                new Api5Error(8000, Api5ErrorDetails.MISSING_REQUIRED_FIELD,
                        capitalize(CpmBannerCampaignNetworkStrategyAddMap.CP_DECREASED_PRICE_FOR_REPEATED_IMPRESSIONS),
                        capitalize(StrategyCpMaximumImpressionsAddMap.START_DATE)));
    }

    @Test
    public void cpMaximumImpressionsEndDateMissingTest() {
        api.userSteps.campaignSteps().expectErrorOnCampaignsUpdate(
                new UpdateRequestMap().withCampaigns(new CampaignUpdateItemMap()
                        .withId(campaignId)
                        .withEndDate(END_DATE)
                        .withCpmBannerCampaign(new CpmBannerCampaignUpdateItemMap()
                                .withBiddingStrategy(new CpmBannerCampaignStrategyMap()
                                        .withSearch(new CpmBannerCampaignSearchStrategyMap().defaultServingOff())
                                        .withNetwork(
                                                new CpmBannerCampaignNetworkStrategyMap()
                                                        .withBiddingStrategyType(
                                                                CpmBannerCampaignNetworkStrategyTypeEnum.CP_MAXIMUM_IMPRESSIONS
                                                        )
                                                        .withCpMaximumImpressions(
                                                                new StrategyCpMaximumImpressionsMap()
                                                                        .withStartDate(START_DATE)
                                                                        .withAverageCpm(AVERAGE_CPM)
                                                                        .withSpendLimit(SPEND_LIMIT)
                                                                        .withAutoContinue(YesNoEnum.YES)))))),
                new Api5Error(8000, Api5ErrorDetails.MISSING_REQUIRED_FIELD,
                        capitalize(CpmBannerCampaignNetworkStrategyAddMap.CP_MAXIMUM_IMPRESSIONS),
                        capitalize(StrategyCpMaximumImpressionsAddMap.END_DATE)));
    }

    @Test
    public void cpDecreasedPriceForRepeatedImpressionsEndDateMissingTest() {
        api.userSteps.campaignSteps().expectErrorOnCampaignsUpdate(
                new UpdateRequestMap().withCampaigns(new CampaignUpdateItemMap()
                        .withId(campaignId)
                        .withEndDate(END_DATE)
                        .withCpmBannerCampaign(new CpmBannerCampaignUpdateItemMap()
                                .withBiddingStrategy(new CpmBannerCampaignStrategyMap()
                                        .withSearch(new CpmBannerCampaignSearchStrategyMap().defaultServingOff())
                                        .withNetwork(
                                                new CpmBannerCampaignNetworkStrategyMap()
                                                        .withBiddingStrategyType(
                                                                CpmBannerCampaignNetworkStrategyTypeEnum.CP_DECREASED_PRICE_FOR_REPEATED_IMPRESSIONS
                                                        )
                                                        .withCpDecreasedPriceForRepeatedImpressions(
                                                                new StrategyCpDecreasedPriceForRepeatedImpressionsMap()
                                                                        .withStartDate(START_DATE)
                                                                        .withAverageCpm(AVERAGE_CPM)
                                                                        .withSpendLimit(SPEND_LIMIT)
                                                                        .withAutoContinue(YesNoEnum.YES)
                                                        )

                                        )))),
                new Api5Error(8000, Api5ErrorDetails.MISSING_REQUIRED_FIELD,
                        capitalize(CpmBannerCampaignNetworkStrategyAddMap.CP_DECREASED_PRICE_FOR_REPEATED_IMPRESSIONS),
                        capitalize(StrategyCpMaximumImpressionsAddMap.END_DATE)));
    }
}
