package ru.yandex.autotests.direct.api.campaigns.update.cpmbannercampaign.strategy.cpv;

import com.yandex.direct.api.v5.campaigns.CpmBannerCampaignNetworkStrategyTypeEnum;
import com.yandex.direct.api.v5.general.VideoTargetEnum;
import org.joda.time.DateTime;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CpmBannerCampaignNetworkStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CpmBannerCampaignSearchStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CpmBannerCampaignStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CpmBannerCampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyWbAverageCpvMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;
import static ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap.DATE_PATTERN;

@Aqua.Test
@Features(CampaignsFeatures.UPDATE)
@Description("Негативные сценарии изменения стратегии на wbAverageCpv")
public class StrategiesAverageCpvNegativeTest {

    private static final String CLIENT = CampaignsLogins.CLIENT;
    private static final Currency CURRENCY = Currency.RUB;
    private static final MoneyCurrency MONEY_CURRENCY = MoneyCurrency.get(CURRENCY);

    private static final long AVERAGE_CPV = MONEY_CURRENCY.getMinAvgCpv().bidLong().longValue();
    private static final long SPEND_LIMIT = MONEY_CURRENCY.getMinDailyBudgetForPeriod().bidLong().longValue() * 7;

    private static final String START_DATE = DateTime.now().plusDays(1).toString(DATE_PATTERN);
    private static final String END_DATE = START_DATE;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private Long campaignId;

    @Before
    public void createCampaign() {
        campaignId = api.userSteps.campaignSteps().addDefaultCpmBannerCampaign();
    }

    @Test
    public void wbAverageCpvUnsupportedGroupTypesInCampaignTest() {
        api.userSteps.adGroupsSteps().addDefaultCpmBannerUserProfileAdGroup(campaignId);
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(
                getParameters(),
                ExpectedResult.errors(new Notification(4000,
                        Api5ErrorDetails.AVERAGE_CPV_STRATEGY_IS_ONLY_APPLICABLE_TO_CAMPAIGNS_WITH_VIDEO_GROUPS)));
    }

    @Test
    public void wbAverageCpvMixedGroupTypesInCampaignTest() {
        api.userSteps.adGroupsSteps().addDefaultCpmBannerUserProfileAdGroup(campaignId);
        api.userSteps.adGroupsSteps().addDefaultCpmVideoGroup(campaignId);
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(
                getParameters(),
                ExpectedResult.errors(new Notification(4000,
                        Api5ErrorDetails.AVERAGE_CPV_STRATEGY_IS_ONLY_APPLICABLE_TO_CAMPAIGNS_WITH_VIDEO_GROUPS)));
    }

    @Test
    public void wbAverageCpvWithVideoTargetTest() {
        api.userSteps.adGroupsSteps().addDefaultCpmVideoGroup(campaignId);
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(
                getParameters(VideoTargetEnum.CLICKS),
                ExpectedResult.warnings(
                        new Notification(10165,
                                Api5ErrorDetails.PARAM_WILL_NOT_BE_CHANGED,
                                capitalize(CpmBannerCampaignUpdateItemMap.VIDEO_TARGET)))
        );
    }

    private UpdateRequestMap getParameters() {
        return getParameters(null);
    }

    private UpdateRequestMap getParameters(VideoTargetEnum videoTarget) {
        return new UpdateRequestMap().withCampaigns(new CampaignUpdateItemMap()
                .withId(campaignId)
                .withEndDate(END_DATE)
                .withCpmBannerCampaign(new CpmBannerCampaignUpdateItemMap()
                        .withVideoTarget(videoTarget)
                        .withBiddingStrategy(new CpmBannerCampaignStrategyMap()
                                .withSearch(new CpmBannerCampaignSearchStrategyMap().defaultServingOff())
                                .withNetwork(
                                        new CpmBannerCampaignNetworkStrategyMap()
                                                .withBiddingStrategyType(
                                                        CpmBannerCampaignNetworkStrategyTypeEnum.WB_AVERAGE_CPV
                                                )
                                                .withWbAverageCpv(
                                                        new StrategyWbAverageCpvMap()
                                                                .withAverageCpv(AVERAGE_CPV)
                                                                .withSpendLimit(SPEND_LIMIT))))));
    }
}
