package ru.yandex.autotests.direct.api.campaigns.update.dailybudget;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.campaigns.DailyBudgetModeEnum;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DailyBudgetMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by pavryabov on 17.09.15.
 * https://st.yandex-team.ru/TESTIRT-6809
 */
@Aqua.Test
@Features(CampaignsFeatures.ADD)
@Description("Проверка обновления дневного бюджета в зависимости от стратегии")
@Issue("https://st.yandex-team.ru/DIRECT-34570")
@RunWith(Parameterized.class)
public class UpdateDailyBudgetWithDifferentStrategiesTest {

    private static final String CLIENT = CampaignsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(5).as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public TextCampaignSearchStrategyAddMap searchStrategyForCreate;

    @Parameterized.Parameter(2)
    public TextCampaignNetworkStrategyAddMap networkStrategyForCreate;

    @Parameterized.Parameter(3)
    public ExpectedResult expectedResult;

    @Parameterized.Parameters(name = "{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {"Ручная + Ручная",
                        new TextCampaignSearchStrategyAddMap().defaultHighestPosition(),
                        new TextCampaignNetworkStrategyAddMap().defaultMaximumCoverage(),
                        ExpectedResult.success()},
                {"Ручная + ShowsDisabled",
                        new TextCampaignSearchStrategyAddMap().defaultHighestPosition(),
                        new TextCampaignNetworkStrategyAddMap().defaultServingOff(),
                        ExpectedResult.success()},
                {"ShowsDisabled + Ручная",
                        new TextCampaignSearchStrategyAddMap().defaultServingOff(),
                        new TextCampaignNetworkStrategyAddMap().defaultMaximumCoverage(),
                        ExpectedResult.success()},
                {"Авто + ShowsDisabled",
                        new TextCampaignSearchStrategyAddMap().defaultWbMaximumClicks(Currency.RUB),
                        new TextCampaignNetworkStrategyAddMap().defaultServingOff(),
                        ExpectedResult.errors(
                                new Notification(6000,
                                        Api5ErrorDetails.DAILY_BUDGET_CAN_ONLY_USED_WITH_MANUAL_STRATEGIES))},
                {"ShowsDisabled + Авто",
                        new TextCampaignSearchStrategyAddMap().defaultServingOff(),
                        new TextCampaignNetworkStrategyAddMap().defaultWbMaximumClicks(Currency.RUB),
                        ExpectedResult.errors(
                                new Notification(6000,
                                        Api5ErrorDetails.DAILY_BUDGET_CAN_ONLY_USED_WITH_MANUAL_STRATEGIES))}
        });
    }

    private static Long minRubAmount = MoneyCurrency.get(Currency.RUB).getMinDayBudgetAmount().bidLong().longValue();
    private static Long id;

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
    }

    @Before
    public void createCampaign() {
        id = api.userSteps.campaignSteps().addCampaign(new CampaignAddItemMap()
                .defaultCampaignAddItem()
                .withDailyBudget(null)
                .withTextCampaign(new TextCampaignAddItemMap()
                        .withBiddingStrategy(new TextCampaignStrategyAddMap()
                                .withSearch(searchStrategyForCreate)
                                .withNetwork(networkStrategyForCreate))));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("943")
    public void checkAmount() {
        //DIRECT-46428
        //DIRECT-46433
        DailyBudgetMap dailyBudgetMap = new DailyBudgetMap()
                .withAmount(minRubAmount)
                .withMode(DailyBudgetModeEnum.STANDARD);
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(new CampaignUpdateItemMap()
                                .withId(id)
                                .withDailyBudget(dailyBudgetMap)),
                expectedResult);
    }
}
