package ru.yandex.autotests.direct.api.campaigns.update.dailybudget;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.campaigns.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.CampaignGetItem;
import com.yandex.direct.api.v5.campaigns.DailyBudgetModeEnum;
import com.yandex.direct.api.v5.campaigns.TextCampaignSettingsEnum;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignGetItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DailyBudgetMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyNetworkDefaultAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignNetworkStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;
import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by pavryabov on 12.09.15.
 * https://st.yandex-team.ru/TESTIRT-6809
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-34570")
@Features(CampaignsFeatures.UPDATE)
@Description("Проверка дневного бюджета после обновления стратегии")
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class UpdateStrategyAndCheckDailyBudgetTest {

    private static String client = CampaignsLogins.UPDATE_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(5).as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private Long id;
    private static Long minRubAmount = MoneyCurrency.get(Currency.RUB).getMinDayBudgetAmount().bidLong().longValue();
    private static DailyBudgetMap dailyBudgetMap = new DailyBudgetMap()
            .withAmount(minRubAmount)
            .withMode(DailyBudgetModeEnum.STANDARD);

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public TextCampaignSearchStrategyAddMap searchStrategyForCreate;

    @Parameterized.Parameter(2)
    public TextCampaignNetworkStrategyAddMap networkStrategyForCreate;

    @Parameterized.Parameter(3)
    public TextCampaignSearchStrategyMap searchStrategyForUpdate;

    @Parameterized.Parameter(4)
    public TextCampaignNetworkStrategyMap networkStrategyForUpdate;

    @Parameterized.Parameter(5)
    public JavaOrPerlExpectedResult expectedResult;

    @Parameterized.Parameter(6)
    public DailyBudgetMap expectedDailyBudget;

    @Parameterized.Parameters(name = "{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {"Ручная + Ручная -> ShowsDisabled + Ручная",
                        new TextCampaignSearchStrategyAddMap().defaultHighestPosition(),
                        new TextCampaignNetworkStrategyAddMap().defaultMaximumCoverage(),
                        new TextCampaignSearchStrategyMap().defaultServingOff(),
                        new TextCampaignNetworkStrategyMap().defaultMaximumCoverage(),
                        JavaOrPerlExpectedResult.both(ExpectedResult.success()),
                        dailyBudgetMap},
                {"ShowsDisabled + Ручная -> Ручная + Ручная",
                        new TextCampaignSearchStrategyAddMap().defaultServingOff(),
                        new TextCampaignNetworkStrategyAddMap().defaultMaximumCoverage(),
                        new TextCampaignSearchStrategyMap().defaultHighestPosition(),
                        new TextCampaignNetworkStrategyMap().defaultMaximumCoverage(),
                        JavaOrPerlExpectedResult.both(ExpectedResult.success()),
                        dailyBudgetMap},
                {"ShowsDisabled + Ручная -> Ручная + ShowsDisabled",
                        new TextCampaignSearchStrategyAddMap().defaultServingOff(),
                        new TextCampaignNetworkStrategyAddMap().defaultMaximumCoverage(),
                        new TextCampaignSearchStrategyMap().defaultHighestPosition(),
                        new TextCampaignNetworkStrategyMap().defaultServingOff(),
                        JavaOrPerlExpectedResult.both(ExpectedResult.success()),
                        dailyBudgetMap},
                {"Ручная + Ручная -> Авто + ShowsDisabled",
                        new TextCampaignSearchStrategyAddMap().defaultHighestPosition(),
                        new TextCampaignNetworkStrategyAddMap().defaultMaximumCoverage(),
                        new TextCampaignSearchStrategyMap().defaultWbMaximumClicks(Currency.RUB),
                        new TextCampaignNetworkStrategyMap().defaultServingOff(),
                        JavaOrPerlExpectedResult
                                .java(ExpectedResult.warningsIgnoringDetailsAndMessage(new Notification(10162,
                                        Api5ErrorDetails.DAILY_BUDGET_MAKES_SENSE_ONLY_FOR_MANUAL_STRATEGIES)))
                                .perl(ExpectedResult.warnings(new Notification(10162,
                                Api5ErrorDetails.DAILY_BUDGET_MAKES_SENSE_ONLY_FOR_MANUAL_STRATEGIES))),
                        null},
                {"Ручная + Ручная -> ShowsDisabled + Авто",
                        new TextCampaignSearchStrategyAddMap().defaultHighestPosition(),
                        new TextCampaignNetworkStrategyAddMap().defaultMaximumCoverage(),
                        new TextCampaignSearchStrategyMap().defaultServingOff(),
                        new TextCampaignNetworkStrategyMap().defaultWbMaximumClicks(Currency.RUB),
                        JavaOrPerlExpectedResult
                                .java(ExpectedResult.warningsIgnoringDetailsAndMessage(new Notification(10162,
                                        Api5ErrorDetails.DAILY_BUDGET_MAKES_SENSE_ONLY_FOR_MANUAL_STRATEGIES)))
                                .perl(ExpectedResult.warnings(new Notification(10162,
                                Api5ErrorDetails.DAILY_BUDGET_MAKES_SENSE_ONLY_FOR_MANUAL_STRATEGIES))),
                        null},
                {"ShowsDisabled + Ручная -> Авто + ShwosDisabled",
                        new TextCampaignSearchStrategyAddMap().defaultServingOff(),
                        new TextCampaignNetworkStrategyAddMap().defaultMaximumCoverage(),
                        new TextCampaignSearchStrategyMap().defaultWbMaximumClicks(Currency.RUB),
                        new TextCampaignNetworkStrategyMap().defaultServingOff(),
                        JavaOrPerlExpectedResult
                                .java(ExpectedResult.warningsIgnoringDetailsAndMessage(new Notification(10162,
                                        Api5ErrorDetails.DAILY_BUDGET_MAKES_SENSE_ONLY_FOR_MANUAL_STRATEGIES)))
                                .perl(ExpectedResult.warnings(new Notification(10162,
                                Api5ErrorDetails.DAILY_BUDGET_MAKES_SENSE_ONLY_FOR_MANUAL_STRATEGIES))),
                        null},
                {"ShowsDisabled + Ручная -> ShowsDisabled + Авто",
                        new TextCampaignSearchStrategyAddMap().defaultServingOff(),
                        new TextCampaignNetworkStrategyAddMap().defaultMaximumCoverage(),
                        new TextCampaignSearchStrategyMap().defaultServingOff(),
                        new TextCampaignNetworkStrategyMap().defaultWbMaximumClicks(Currency.RUB),
                        JavaOrPerlExpectedResult
                                .java(ExpectedResult.warningsIgnoringDetailsAndMessage(new Notification(10162,
                                        Api5ErrorDetails.DAILY_BUDGET_MAKES_SENSE_ONLY_FOR_MANUAL_STRATEGIES)))
                                .perl(ExpectedResult.warnings(new Notification(10162,
                                Api5ErrorDetails.DAILY_BUDGET_MAKES_SENSE_ONLY_FOR_MANUAL_STRATEGIES))),
                        null},
                {"Ручная + ShowsDisabled -> Авто + ShwosDisabled",
                        new TextCampaignSearchStrategyAddMap().defaultHighestPosition(),
                        new TextCampaignNetworkStrategyAddMap().defaultServingOff(),
                        new TextCampaignSearchStrategyMap().defaultWbMaximumClicks(Currency.RUB),
                        new TextCampaignNetworkStrategyMap().defaultServingOff(),
                        JavaOrPerlExpectedResult
                                .java(ExpectedResult.warningsIgnoringDetailsAndMessage(new Notification(10162,
                                        Api5ErrorDetails.DAILY_BUDGET_MAKES_SENSE_ONLY_FOR_MANUAL_STRATEGIES)))
                                .perl(ExpectedResult.warnings(new Notification(10162,
                                Api5ErrorDetails.DAILY_BUDGET_MAKES_SENSE_ONLY_FOR_MANUAL_STRATEGIES))),
                        null},
                {"Ручная + ShowsDisabled -> ShowsDisabled + Авто",
                        new TextCampaignSearchStrategyAddMap().defaultHighestPosition(),
                        new TextCampaignNetworkStrategyAddMap().defaultServingOff(),
                        new TextCampaignSearchStrategyMap().defaultServingOff(),
                        new TextCampaignNetworkStrategyMap().defaultWbMaximumClicks(Currency.RUB),
                        JavaOrPerlExpectedResult
                                .java(ExpectedResult.warningsIgnoringDetailsAndMessage(new Notification(10162,
                                Api5ErrorDetails.DAILY_BUDGET_MAKES_SENSE_ONLY_FOR_MANUAL_STRATEGIES)))
                                .perl(ExpectedResult.warnings(new Notification(10162,
                                Api5ErrorDetails.DAILY_BUDGET_MAKES_SENSE_ONLY_FOR_MANUAL_STRATEGIES))),
                        null},
        });
    }

    @BeforeClass
    public static void prepareClient() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
    }

    @Before
    public void createCampaign() {
        id = api.userSteps.campaignSteps().addCampaign(new CampaignAddItemMap()
                .defaultCampaignAddItem()
                .withDailyBudget(dailyBudgetMap)
                .withTextCampaign(new TextCampaignAddItemMap()
                        .withBiddingStrategy(new TextCampaignStrategyAddMap()
                                .withSearch(searchStrategyForCreate)
                                .withNetwork(networkStrategyForCreate))));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("944")
    public void updateDailyBudget() {
        //DIRECT-46262
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(new CampaignUpdateItemMap()
                                .withId(id)
                                .withTextCampaign(new TextCampaignUpdateItemMap()
                                        .withBiddingStrategy(new TextCampaignStrategyMap()
                                                .withSearch(searchStrategyForUpdate)
                                                .withNetwork(networkStrategyForUpdate)))
                        ),
                expectedResult);
        CampaignGetItem campaignGetItem =
                api.userSteps.campaignSteps().campaignsGet(id, CampaignFieldEnum.DAILY_BUDGET);
        assertThat("кампания правильно обновилась", campaignGetItem,
                beanDifferV5((CampaignGetItem)
                        new CampaignGetItemMap()
                                .withDailyBudget(expectedDailyBudget).getBean()));
    }
}
