package ru.yandex.autotests.direct.api.campaigns.update.dynamictextcampaign;

import com.yandex.direct.api.v5.campaigns.DynamicTextCampaignNetworkStrategyTypeEnum;
import com.yandex.direct.api.v5.campaigns.DynamicTextCampaignSearchStrategyTypeEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.PriorityGoalsArrayMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.PriorityGoalsItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.PriorityGoalsUpdateSettingMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyAverageRoiAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ArrayOfIntegerMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;


@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-99603")
@Features(CampaignsFeatures.UPDATE)
@Description("Проверка сброса поля PriorityGoals при использовании в стратегии roi оптимизации по КЦ")
public class UnsetPriorityGoalsUsingInStrategyNegativeTest {

    private static String client = CampaignsLogins.UPDATE_CLIENT;
    private static Long cid;

    private static final Integer COUNTER_ID = 34981090;
    private static final Long GOAL_ID = 17108070L;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(5).as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Before
    public void createCampaign() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);

        cid = api.userSteps.campaignSteps().addCampaign(new CampaignAddItemMap()
                .defaultCampaignAddItem()
                .withDynamicTextCampaign(new DynamicTextCampaignAddItemMap()
                        .withBiddingStrategy(new DynamicTextCampaignStrategyAddMap()
                                .defaultDynamicTextCampaignStrategy()
                                .withSearch(new DynamicTextCampaignSearchStrategyAddMap()
                                        .withBiddingStrategyType(DynamicTextCampaignSearchStrategyTypeEnum.AVERAGE_ROI)
                                        .withAverageRoi(new StrategyAverageRoiAddMap()
                                                .defaultStrategyAverageRoi()
                                                .withGoalId(13L)))
                                .withNetwork(new DynamicTextCampaignNetworkStrategyAddMap()
                                        .withBiddingStrategyType(DynamicTextCampaignNetworkStrategyTypeEnum.SERVING_OFF)))
                        .withCounterIds(COUNTER_ID)
                        .withPriorityGoals(new PriorityGoalsArrayMap()
                                .withItems(new PriorityGoalsItemMap()
                                        .withGoalId(GOAL_ID)
                                        .withValue(1_000_000L)))));
    }

    @Test
    public void unsetPriorityGoalsUsingInStrategy() {
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(new CampaignUpdateItemMap()
                                .withId(cid)
                                .withDynamicTextCampaign(new DynamicTextCampaignUpdateItemMap()
                                        .withPriorityGoals((PriorityGoalsUpdateSettingMap) null)
                                )
                        ),
                JavaOrPerlExpectedResult
                        .java(ExpectedResult.errors(new Notification(4000,
                                Api5ErrorDetails.NOT_SUITABLE_MEANINGFUL_GOALS)))
                        .perl(ExpectedResult.errors(new Notification(4000,
                                Api5ErrorDetails.MEANINGFUL_GOALS_CANNOT_BE_UNSET))));
    }

    @Test
    public void unsetPriorityGoalsAndConter() {
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(new CampaignUpdateItemMap()
                                .withId(cid)
                                .withDynamicTextCampaign(new DynamicTextCampaignUpdateItemMap()
                                        .withCounterIds((ArrayOfIntegerMap) null)
                                        .withPriorityGoals((PriorityGoalsUpdateSettingMap) null)
                                )
                        ),
                JavaOrPerlExpectedResult
                        .java(ExpectedResult.errors(new Notification(4000,
                                Api5ErrorDetails.NOT_SUITABLE_MEANINGFUL_GOALS)))
                        .perl(ExpectedResult.errors(new Notification(4000,
                                Api5ErrorDetails.MEANINGFUL_GOALS_CANNOT_BE_UNSET))));
    }
}
