package ru.yandex.autotests.direct.api.campaigns.update.dynamictextcampaign;

import java.util.Arrays;
import java.util.Collection;

import org.apache.commons.lang3.RandomStringUtils;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.fake.CampaignFakeInfo;
import ru.yandex.autotests.directapi.darkside.model.Status;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignNetworkStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignSearchStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by pavryabov on 23.11.15.
 * https://st.yandex-team.ru/TESTIRT-7756
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-44876")
@Features(CampaignsFeatures.UPDATE)
@Description("Проверка статуса модерации после обновления динамической текстовой кампании")
@RunWith(Parameterized.class)
public class UpdateDynamicTextCampaignAndCheckStatusModerateTest {

    private static String client = CampaignsLogins.UPDATE_CLIENT;
    private Long id;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(5).as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public String status;

    @Parameterized.Parameters(name = "campaignType = {0}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {Status.YES},
                {Status.NO},
                {Status.SENT},
                {Status.READY},
                {Status.NEW},
        };
        return Arrays.asList(data);
    }

    @Before
    public void createCampaign() {
        id = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        api.userSteps.campaignFakeSteps().setStatusModerate(id, status);
        CampaignFakeInfo campaignFakeInfo = api.userSteps.campaignFakeSteps().fakeGetCampaignParams(id);
        assumeThat(String.format("StatusModerate у кампании = ", status),
                campaignFakeInfo.getStatusModerate(), equalTo(status));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("926")
    public void updateCampaignAndCheckStatus() {
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(
                                new CampaignUpdateItemMap()
                                        .withId(id)
                                        .withName(RandomStringUtils.randomAlphabetic(10))
                                        .withNegativeKeywords("newNegativeKeywords")
                                        .withDynamicTextCampaign(new DynamicTextCampaignUpdateItemMap()
                                                .withBiddingStrategy(new DynamicTextCampaignStrategyMap()
                                                        .defaultDynamicTextCampaignStrategy()
                                                        .withSearch(new DynamicTextCampaignSearchStrategyMap()
                                                                .defaultWbMaximumClicks(Currency.RUB))
                                                        .withNetwork(new DynamicTextCampaignNetworkStrategyMap()
                                                                .defaultServingOff())))
                        ),
                ExpectedResult.success());
        CampaignFakeInfo campaignFakeInfo = api.userSteps.campaignFakeSteps().fakeGetCampaignParams(id);
        assertThat(String.format("StatusModerate у кампании = ", status),
                campaignFakeInfo.getStatusModerate(), equalTo(status));
    }
}
