package ru.yandex.autotests.direct.api.campaigns.update.dynamictextcampaign;

import java.util.Arrays;
import java.util.Collection;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.directapi.utils.AccessRightsErrorHelper.checkCatchingJavaAccessError;

/**
 * Created by pavryabov on 23.11.15.
 * https://st.yandex-team.ru/TESTIRT-7756
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-44876")
@Features(CampaignsFeatures.UPDATE)
@Description("Проверка прав внутренних ролей на обновление динамической текстовой кампании")
@RunWith(Parameterized.class)
public class UpdateDynamicTextCampaignInternalRolesTest {

    private static final String SERV_CLIENT = CampaignsLogins.SERV_CLIENT;

    private Long id;

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public String loginForAuthorization;

    @Parameterized.Parameter(1)
    public ExpectedResult expectedResult;

    @Parameterized.Parameter(2)
    public Api5Error expectedError;

    @Parameterized.Parameters(name = "loginForAuthorization = {0}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {Logins.MANAGER_DEFAULT, ExpectedResult.success(), null},
                {Logins.PLACER, ExpectedResult.success(), new Api5Error(54)},
                {Logins.SUPPORT, ExpectedResult.success(), null},
                {Logins.SUPER_LOGIN, ExpectedResult.success(), null},
                {Logins.MEDIA,
                        ExpectedResult.errors(new Notification(54, Api5ErrorDetails.NO_RIGHTS_TO_WRITE)),
                        new Api5Error(54)
                },
                {Logins.SUPER_READER,
                        ExpectedResult.errors(new Notification(54, Api5ErrorDetails.NO_RIGHTS_TO_WRITE)),
                        new Api5Error(54)}
        };
        return Arrays.asList(data);
    }

    @Before
    public void createCampaign() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(loginForAuthorization);
        id = api.as(Logins.MANAGER_DEFAULT).userSteps.campaignSteps().addDefaultDynamicTextCampaign(SERV_CLIENT);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("928")
    public void checkUpdateRights() {
        checkCatchingJavaAccessError(expectedError, () ->
                api.as(loginForAuthorization).userSteps.campaignSteps().shouldGetResultOnUpdate(
                        new UpdateRequestMap()
                                .withCampaigns(
                                        new CampaignUpdateItemMap()
                                                .withId(id)
                                ),
                        SERV_CLIENT,
                        expectedResult
                ));
    }
}
