package ru.yandex.autotests.direct.api.campaigns.update.dynamictextcampaign;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.campaigns.PlacementType;
import com.yandex.direct.api.v5.campaigns.PlacementTypesEnum;
import com.yandex.direct.api.v5.general.YesNoEnum;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignPlacementTypeMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;

@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-TODO")
@Features(CampaignsFeatures.UPDATE)
@Description("Проверка PlacementTypes (негативные сценарии)")
@RunWith(Parameterized.class)
public class UpdateDynamicTextCampaignPlacementTypesNegativeTest {

    private static String client = CampaignsLogins.UPDATE_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(5).as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public DynamicTextCampaignPlacementTypeMap[] initialPlacementTypes;

    @Parameterized.Parameter(2)
    public DynamicTextCampaignPlacementTypeMap[] requestedPlacementTypes;

    @Parameterized.Parameter(3)
    public ExpectedResult expectedResult;

    @Parameterized.Parameters(name = "{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList(new Object[][]{

                { "всё в No - 1",
                        new DynamicTextCampaignPlacementTypeMap[] {
                                productGalleryYes(),
                                searchResultsNo()},
                        new DynamicTextCampaignPlacementTypeMap[] {
                                productGalleryNo()},
                        ExpectedResult.errorWithCode(5005)
                },
                { "всё в No - 2",
                        new DynamicTextCampaignPlacementTypeMap[] {
                                productGalleryNo(),
                                searchResultsYes()},
                        new DynamicTextCampaignPlacementTypeMap[] {
                                searchResultsNo()},
                        ExpectedResult.errorWithCode(5005)
                },
                { "дублирование - 1",
                        new DynamicTextCampaignPlacementTypeMap[] {
                                searchResultsYes()},
                        new DynamicTextCampaignPlacementTypeMap[] {
                                searchResultsNo(),
                                searchResultsNo()},
                        ExpectedResult.errors(
                                new Notification(9802, Api5ErrorDetails.ELEMENT_PRESENT_IN_LIST_MORE_THAN_ONE_TIME,
                                        PlacementTypesEnum.SEARCH_RESULTS.name(),
                                        capitalize(CampaignUpdateItemMap.PLACEMENT_TYPES)))
                },
                { "дублирование - 2",
                        new DynamicTextCampaignPlacementTypeMap[] {
                                productGalleryYes(),
                                searchResultsNo()},
                        new DynamicTextCampaignPlacementTypeMap[] {
                                searchResultsYes(),
                                searchResultsYes()},
                        ExpectedResult.errors(
                                new Notification(9802, Api5ErrorDetails.ELEMENT_PRESENT_IN_LIST_MORE_THAN_ONE_TIME,
                                        PlacementTypesEnum.SEARCH_RESULTS.name(),
                                        capitalize(CampaignUpdateItemMap.PLACEMENT_TYPES)))
                },
                { "дублирование - 3",
                        new DynamicTextCampaignPlacementTypeMap[] {
                                productGalleryYes(),
                                searchResultsNo()},
                        new DynamicTextCampaignPlacementTypeMap[] {
                                productGalleryNo(),
                                productGalleryNo(),
                                searchResultsYes()},
                        ExpectedResult.errors(
                                new Notification(9802, Api5ErrorDetails.ELEMENT_PRESENT_IN_LIST_MORE_THAN_ONE_TIME,
                                        PlacementTypesEnum.PRODUCT_GALLERY.name(),
                                        capitalize(CampaignUpdateItemMap.PLACEMENT_TYPES)))
                },
        });
    }

    @Test
    public void updateCampaignWithPlacementTypes() {
        Long cid = api.userSteps.campaignSteps().addCampaign(
                        new CampaignAddItemMap().defaultCampaignAddItem()
                                .withDynamicTextCampaign(
                                        new DynamicTextCampaignAddItemMap()
                                                .withBiddingStrategy(new DynamicTextCampaignStrategyAddMap()
                                                        .defaultDynamicTextCampaignStrategy())
                                                .withPlacementTypes(initialPlacementTypes)
                                ),
                        null);

        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(new CampaignUpdateItemMap()
                                .withId(cid)
                                .withDynamicTextCampaign(new DynamicTextCampaignUpdateItemMap()
                                        .withPlacementTypes(requestedPlacementTypes)
                                )
                        ),
                expectedResult);
    }

    private static DynamicTextCampaignPlacementTypeMap productGalleryYes() {
        return new DynamicTextCampaignPlacementTypeMap()
                .withType(PlacementTypesEnum.PRODUCT_GALLERY)
                .withValue(YesNoEnum.YES);
    }

    private static DynamicTextCampaignPlacementTypeMap productGalleryNo() {
        return new DynamicTextCampaignPlacementTypeMap()
                .withType(PlacementTypesEnum.PRODUCT_GALLERY)
                .withValue(YesNoEnum.NO);
    }

    private static DynamicTextCampaignPlacementTypeMap searchResultsYes() {
        return new DynamicTextCampaignPlacementTypeMap()
                .withType(PlacementTypesEnum.SEARCH_RESULTS)
                .withValue(YesNoEnum.YES);
    }

    private static DynamicTextCampaignPlacementTypeMap searchResultsNo() {
        return new DynamicTextCampaignPlacementTypeMap()
                .withType(PlacementTypesEnum.SEARCH_RESULTS)
                .withValue(YesNoEnum.NO);
    }

    private static PlacementType wsdlProductGalleryYes() {
        PlacementType result = new PlacementType();
        result.setType(PlacementTypesEnum.PRODUCT_GALLERY);
        result.setValue(YesNoEnum.YES);
        return result;
    }

    private static PlacementType wsdlProductGalleryNo() {
      PlacementType result = new PlacementType();
        result.setType(PlacementTypesEnum.PRODUCT_GALLERY);
        result.setValue(YesNoEnum.NO);
        return result;
    }

    private static PlacementType wsdlSearchResultsYes() {
        PlacementType result = new PlacementType();
        result.setType(PlacementTypesEnum.SEARCH_RESULTS);
        result.setValue(YesNoEnum.YES);
        return result;
    }

    private static PlacementType wsdlSearchResultsNo() {
      PlacementType result = new PlacementType();
        result.setType(PlacementTypesEnum.SEARCH_RESULTS);
        result.setValue(YesNoEnum.NO);
        return result;
    }

}
