package ru.yandex.autotests.direct.api.campaigns.update.dynamictextcampaign;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.campaigns.GetResponse;
import com.yandex.direct.api.v5.campaigns.PlacementType;
import com.yandex.direct.api.v5.campaigns.PlacementTypesEnum;
import com.yandex.direct.api.v5.general.YesNoEnum;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignPlacementTypeMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.containsInAnyOrder;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-TODO")
@Features(CampaignsFeatures.UPDATE)
@Description("Проверка PlacementTypes (позитивные сценарии)")
@RunWith(Parameterized.class)
public class UpdateDynamicTextCampaignPlacementTypesPositiveTest {

    private static String client = CampaignsLogins.UPDATE_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(5).as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public DynamicTextCampaignPlacementTypeMap[] initialPlacementTypes;

    @Parameterized.Parameter(1)
    public DynamicTextCampaignPlacementTypeMap[] requestedPlacementTypes;

    @Parameterized.Parameter(2)
    public PlacementType[] expectedPlacementTypes;

    @Parameterized.Parameters()
    public static Collection<Object[]> data() {
        return Arrays.asList(new Object[][]{
                { null,
                        new DynamicTextCampaignPlacementTypeMap[] {
                                productGalleryYes(),
                                searchResultsNo()},
                        new PlacementType[] {
                                wsdlProductGalleryYes(),
                                wsdlSearchResultsNo()}
                },

                { null,
                        new DynamicTextCampaignPlacementTypeMap[] {
                                searchResultsNo()},
                        new PlacementType[] {
                                wsdlProductGalleryYes(),
                                wsdlSearchResultsNo()}
                },

                { null,
                        new DynamicTextCampaignPlacementTypeMap[] {
                                productGalleryYes()},
                        new PlacementType[] {
                                wsdlProductGalleryYes(),
                                wsdlSearchResultsYes()}
                },

                { null,
                        new DynamicTextCampaignPlacementTypeMap[] {
                                productGalleryNo(),
                                searchResultsYes()},
                        new PlacementType[] {
                                wsdlProductGalleryNo(),
                                wsdlSearchResultsYes()}
                },

                {null,
                        new DynamicTextCampaignPlacementTypeMap[] {
                                productGalleryYes(),
                                searchResultsYes()},
                        new PlacementType[] {
                                wsdlProductGalleryYes(),
                                wsdlSearchResultsYes()}
                },

                { new DynamicTextCampaignPlacementTypeMap[] {
                                productGalleryNo(),
                                searchResultsYes()},
                        new DynamicTextCampaignPlacementTypeMap[] {
                                productGalleryNo()},
                        new PlacementType[] {
                                wsdlProductGalleryNo(),
                                wsdlSearchResultsYes()}
                },

                { new DynamicTextCampaignPlacementTypeMap[]{
                        productGalleryYes(),
                        searchResultsYes()},
                        new DynamicTextCampaignPlacementTypeMap[]{
                                productGalleryYes()},
                        new PlacementType[]{
                                wsdlProductGalleryYes(),
                                wsdlSearchResultsYes()}
                },

                { new DynamicTextCampaignPlacementTypeMap[] {
                                productGalleryYes(),
                                searchResultsNo()},
                        new DynamicTextCampaignPlacementTypeMap[] {
                                productGalleryYes()},
                        new PlacementType[] {
                                wsdlProductGalleryYes(),
                                wsdlSearchResultsNo()}
                },

                { new DynamicTextCampaignPlacementTypeMap[] {
                                productGalleryNo(),
                                searchResultsYes()},
                        new DynamicTextCampaignPlacementTypeMap[] {
                                searchResultsYes()},
                        new PlacementType[] {
                                wsdlProductGalleryNo(),
                                wsdlSearchResultsYes()}
                },

                { new DynamicTextCampaignPlacementTypeMap[] {
                                productGalleryNo(),
                                searchResultsYes()},
                        new DynamicTextCampaignPlacementTypeMap[] {
                                productGalleryNo()},
                        new PlacementType[] {
                                wsdlProductGalleryNo(),
                                wsdlSearchResultsYes()}
                },

                { new DynamicTextCampaignPlacementTypeMap[] {
                                productGalleryYes()},
                        new DynamicTextCampaignPlacementTypeMap[] {
                                productGalleryYes()},
                        new PlacementType[] {
                                wsdlProductGalleryYes(),
                                wsdlSearchResultsYes()}
                },

                { new DynamicTextCampaignPlacementTypeMap[] {
                                productGalleryYes()},
                        new DynamicTextCampaignPlacementTypeMap[] {
                                productGalleryNo()},
                        new PlacementType[] {
                                wsdlProductGalleryNo(),
                                wsdlSearchResultsYes()}
                },

                { new DynamicTextCampaignPlacementTypeMap[] {
                        productGalleryYes(),
                        searchResultsNo()},
                        null,
                        new PlacementType[] {
                                wsdlProductGalleryYes(),
                                wsdlSearchResultsNo()}
                },
        });
    }

    @Test
    public void updateCampaignWithPlacementTypes() {
        Long cid = api.userSteps.campaignSteps().addCampaign(
                        new CampaignAddItemMap().defaultCampaignAddItem()
                                .withDynamicTextCampaign(
                                        new DynamicTextCampaignAddItemMap()
                                                .withBiddingStrategy(new DynamicTextCampaignStrategyAddMap()
                                                        .defaultDynamicTextCampaignStrategy())
                                                .withPlacementTypes(initialPlacementTypes)
                                ),
                        null);

        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(new CampaignUpdateItemMap()
                                .withId(cid)
                                .withDynamicTextCampaign(new DynamicTextCampaignUpdateItemMap()
                                        .withPlacementTypes(requestedPlacementTypes)
                                )
                        ),
                ExpectedResult.success());

        GetResponse getResponse = api.userSteps.campaignSteps().campaignsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new CampaignsSelectionCriteriaMap()
                                        .withIds(cid)
                        )
                        .withAllFieldNames()
                        .withAllDynamicTextCampaignFieldNames()
        );

        assertThat("вернулось правильное значение PlacementTypes",
                getResponse.getCampaigns().get(0).getDynamicTextCampaign().getPlacementTypes().getItems(),
                containsInAnyOrder(expectedPlacementTypes));
    }

    private static DynamicTextCampaignPlacementTypeMap productGalleryYes() {
        return new DynamicTextCampaignPlacementTypeMap()
                .withType(PlacementTypesEnum.PRODUCT_GALLERY)
                .withValue(YesNoEnum.YES);
    }

    private static DynamicTextCampaignPlacementTypeMap productGalleryNo() {
        return new DynamicTextCampaignPlacementTypeMap()
                .withType(PlacementTypesEnum.PRODUCT_GALLERY)
                .withValue(YesNoEnum.NO);
    }

    private static DynamicTextCampaignPlacementTypeMap searchResultsYes() {
        return new DynamicTextCampaignPlacementTypeMap()
                .withType(PlacementTypesEnum.SEARCH_RESULTS)
                .withValue(YesNoEnum.YES);
    }

    private static DynamicTextCampaignPlacementTypeMap searchResultsNo() {
        return new DynamicTextCampaignPlacementTypeMap()
                .withType(PlacementTypesEnum.SEARCH_RESULTS)
                .withValue(YesNoEnum.NO);
    }

    private static PlacementType wsdlProductGalleryYes() {
        PlacementType result = new PlacementType();
        result.setType(PlacementTypesEnum.PRODUCT_GALLERY);
        result.setValue(YesNoEnum.YES);
        return result;
    }

    private static PlacementType wsdlProductGalleryNo() {
      PlacementType result = new PlacementType();
        result.setType(PlacementTypesEnum.PRODUCT_GALLERY);
        result.setValue(YesNoEnum.NO);
        return result;
    }

    private static PlacementType wsdlSearchResultsYes() {
        PlacementType result = new PlacementType();
        result.setType(PlacementTypesEnum.SEARCH_RESULTS);
        result.setValue(YesNoEnum.YES);
        return result;
    }

    private static PlacementType wsdlSearchResultsNo() {
      PlacementType result = new PlacementType();
        result.setType(PlacementTypesEnum.SEARCH_RESULTS);
        result.setValue(YesNoEnum.NO);
        return result;
    }

}
