package ru.yandex.autotests.direct.api.campaigns.update.dynamictextcampaign.fieldvalidation;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.general.OperationEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.PriorityGoalsUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.PriorityGoalsUpdateSettingMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

@Aqua.Test
@Features(CampaignsFeatures.UPDATE)
@Description("Проверка валидации PriorityGoals при обновлении")
@Issue("https://st.yandex-team.ru/DIRECT-98633")
@RunWith(Parameterized.class)
public class UpdatePriorityGoalsNegativeTest {

    private static String client = CampaignsLogins.UPDATE_CLIENT;
    private static final Integer COUNTER_ID = 34981090;
    private static final Long GOAL_ID = 17108070L;
    // цель CampaignsLogins.CLIENT, недоступная UPDATE_CLIENT
    private static final Integer ALIEN_COUNTER_ID = 32265784;
    private static final Long ALIEN_GOAL_ID = 13088934L;

    private static Long cid;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(5).as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public DynamicTextCampaignUpdateItemMap dynamicTextCampaignUpdate;

    @Parameterized.Parameter(2)
    public ExpectedResult expectedResult;

    @Parameterized.Parameters(name = "{0}")
    public static Collection testData() {

        Object[][] data = new Object[][]{
                {"invalid operation ADD",
                        new DynamicTextCampaignUpdateItemMap().withPriorityGoals(
                                new PriorityGoalsUpdateSettingMap().withItems(new PriorityGoalsUpdateItemMap()
                                        .withOperation(OperationEnum.ADD)
                                        .withEngagedSessionGoalId()
                                        .withValue(1_000_000L))),
                        ExpectedResult.errors(new Notification(3500,
                                Api5ErrorDetails.PRIORITY_GOAL_NOT_SUPPORTED_OPERATION))
                },
                {"invalid operation REMOVE",
                        new DynamicTextCampaignUpdateItemMap().withPriorityGoals(
                                new PriorityGoalsUpdateSettingMap().withItems(new PriorityGoalsUpdateItemMap()
                                        .withOperation(OperationEnum.REMOVE)
                                        .withEngagedSessionGoalId()
                                        .withValue(1_000_000L))),
                        ExpectedResult.errors(new Notification(3500,
                                Api5ErrorDetails.PRIORITY_GOAL_NOT_SUPPORTED_OPERATION))
                },
                {"zero goal id",
                        new DynamicTextCampaignUpdateItemMap().withPriorityGoals(
                                new PriorityGoalsUpdateSettingMap().withItems(new PriorityGoalsUpdateItemMap()
                                        .withOperation(OperationEnum.SET)
                                        .withGoalId(0L)
                                        .withValue(1_000_000L))),
                        ExpectedResult.errorsIgnoringDetails(new Notification(8800,
                                Api5ErrorDetails.PRIORITY_GOAL_ID_NOT_FOUND,
                                0L))
                },
                {"invalid goal id",
                        new DynamicTextCampaignUpdateItemMap()
                                .withCounterIds(COUNTER_ID)
                                .withPriorityGoals(new PriorityGoalsUpdateSettingMap()
                                    .withItems(new PriorityGoalsUpdateItemMap()
                                        .withOperation(OperationEnum.SET)
                                        .withGoalId(999L)
                                        .withValue(1_000_000L))
                                ),
                        ExpectedResult.errorsIgnoringDetails(new Notification(8800,
                                Api5ErrorDetails.PRIORITY_GOAL_ID_NOT_FOUND,
                                999L))
                },
                {"valid goal id without counter",
                        new DynamicTextCampaignUpdateItemMap()
                                .withPriorityGoals(new PriorityGoalsUpdateSettingMap()
                                .withItems(new PriorityGoalsUpdateItemMap()
                                        .withOperation(OperationEnum.SET)
                                        .withGoalId(GOAL_ID)
                                        .withValue(1_000_000L))
                        ),
                        ExpectedResult.errorsIgnoringDetails(new Notification(8800,
                                Api5ErrorDetails.PRIORITY_GOAL_ID_NOT_FOUND,
                                GOAL_ID))
                },
                {"inaccessible valid goal id",
                        new DynamicTextCampaignUpdateItemMap()
                                .withCounterIds(ALIEN_COUNTER_ID)
                                .withPriorityGoals(new PriorityGoalsUpdateSettingMap()
                                .withItems(new PriorityGoalsUpdateItemMap()
                                        .withOperation(OperationEnum.SET)
                                        .withGoalId(ALIEN_GOAL_ID)
                                        .withValue(1_000_000L))
                        ),
                        ExpectedResult.errorsIgnoringDetails(new Notification(8800,
                                Api5ErrorDetails.PRIORITY_GOAL_ID_NOT_FOUND,
                                ALIEN_GOAL_ID))
                },
                {"too small value",
                        new DynamicTextCampaignUpdateItemMap().withPriorityGoals(
                                new PriorityGoalsUpdateSettingMap().withItems(new PriorityGoalsUpdateItemMap()
                                        .withOperation(OperationEnum.SET)
                                        .withEngagedSessionGoalId()
                                        .withValue(0L))),
                        ExpectedResult.errorsIgnoringDetails(new Notification(5005,
                                Api5ErrorDetails.PRIORITY_GOAL_VALUE_TOO_SMALL,
                                PriorityGoalsUpdateItemMap.ENGAGED_SESSION_GOAL_ID,
                                "0.30", Currency.RUB.value().toLowerCase()))
                },
                {"too big value",
                        new DynamicTextCampaignUpdateItemMap().withPriorityGoals(
                                new PriorityGoalsUpdateSettingMap().withItems(new PriorityGoalsUpdateItemMap()
                                        .withOperation(OperationEnum.SET)
                                        .withEngagedSessionGoalId()
                                        .withValue(4_000_000_000_000_000_000L))),
                        ExpectedResult.errorsIgnoringDetails(new Notification(5005,
                                Api5ErrorDetails.PRIORITY_GOAL_VALUE_TOO_BIG,
                                PriorityGoalsUpdateItemMap.ENGAGED_SESSION_GOAL_ID,
                                "300 000 000.00", Currency.RUB.value().toLowerCase()))
                },
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        cid = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        DirectJooqDbSteps dbSteps = api.userSteps.getDirectJooqDbSteps().useShardForLogin(client);
        Long clientId = Long.parseLong(User.get(client).getClientID());
        dbSteps.featuresSteps().setClientFeature(clientId, "direct_unavailable_goals_allowed", false);
    }

    @Test
    public void updateWithInvalidPriorityGoals() {
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(new CampaignUpdateItemMap()
                                .withId(cid)
                                .withDynamicTextCampaign(dynamicTextCampaignUpdate)
                        ),
                expectedResult);
    }
}
