package ru.yandex.autotests.direct.api.campaigns.update.dynamictextcampaign.fieldvalidation;

import com.yandex.direct.api.v5.general.OperationEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.db.steps.CampaignsSteps;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.PriorityGoalsItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.PriorityGoalsUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ArrayOfIntegerMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.direct.api.campaigns.CampaignCommonMatchers.getMeaningfulGoalsJsonMatcher;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-98633")
@Features(CampaignsFeatures.UPDATE)
@Description("Проверка перевалидации поля PriorityGoals")
public class UpdatePriorityGoalsNoRevalidation {

    private static String client = CampaignsLogins.UPDATE_CLIENT;
    private static final Integer COUNTER_ID = 34981090;
    private static final Long GOAL_ID = 17108070L;
    private static CampaignsSteps campaignJooqSteps;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(5).as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @BeforeClass
    public static void createCampaign() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        campaignJooqSteps = api.userSteps.getDirectJooqDbSteps().useShardForLogin(client).campaignsSteps();
    }

    @Test
    public void updateDropCounterIdsSameGoalsNoRevalidation() {
        Long cid = api.userSteps.campaignSteps().addCampaign(new CampaignAddItemMap()
                .defaultCampaignAddItem()
                .withDynamicTextCampaign(new DynamicTextCampaignAddItemMap()
                        .withBiddingStrategy(new DynamicTextCampaignStrategyAddMap()
                                .defaultDynamicTextCampaignStrategy())
                        .withCounterIds(COUNTER_ID)
                        .withPriorityGoals(new PriorityGoalsItemMap()
                                .withGoalId(GOAL_ID)
                                .withValue(1_000_000L))
                ));

        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(new CampaignUpdateItemMap()
                                .withId(cid)
                                .withDynamicTextCampaign(new DynamicTextCampaignUpdateItemMap()
                                        .withCounterIds((ArrayOfIntegerMap) null)
                                        .withPriorityGoals(new PriorityGoalsUpdateItemMap()
                                                .withGoalId(GOAL_ID)
                                                .withValue(1_000_000L)
                                                .withOperation(OperationEnum.SET)
                                        )
                                )
                        ),
                ExpectedResult.success());

        assertThat("meaningful_goals содержит правильный json",
                campaignJooqSteps.getCampOptionsById(cid).getMeaningfulGoals(),
                getMeaningfulGoalsJsonMatcher(GOAL_ID, 1L));
    }

    @Test
    public void updateDropCounterIdsNoRevalidation() {
        Long cid = api.userSteps.campaignSteps().addCampaign(new CampaignAddItemMap()
                .defaultCampaignAddItem()
                .withDynamicTextCampaign(new DynamicTextCampaignAddItemMap()
                        .withBiddingStrategy(new DynamicTextCampaignStrategyAddMap()
                                .defaultDynamicTextCampaignStrategy())
                        .withCounterIds(COUNTER_ID)
                        .withPriorityGoals(new PriorityGoalsItemMap()
                                .withGoalId(GOAL_ID)
                                .withValue(1_000_000L))
                ));

        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(new CampaignUpdateItemMap()
                                .withId(cid)
                                .withDynamicTextCampaign(new DynamicTextCampaignUpdateItemMap()
                                        .withCounterIds((ArrayOfIntegerMap) null)
                                )
                        ),
                ExpectedResult.success());

        assertThat("meaningful_goals содержит правильный json",
                campaignJooqSteps.getCampOptionsById(cid).getMeaningfulGoals(),
                getMeaningfulGoalsJsonMatcher(GOAL_ID, 1L));
    }
}
