package ru.yandex.autotests.direct.api.campaigns.update.dynamictextcampaign.strategy;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import com.yandex.direct.api.v5.campaigns.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.CampaignGetItem;
import com.yandex.direct.api.v5.campaigns.DynamicTextCampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.DynamicTextCampaignSearchStrategyTypeEnum;
import com.yandex.direct.api.v5.campaigns.DynamicTextCampaignStrategy;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignNetworkStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignSearchStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyAverageRoiMap;
import ru.yandex.autotests.directapi.model.campaigns.MetrikaGoals;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by chicos on 04.09.2015.
 */
@Aqua.Test
@Features(CampaignsFeatures.UPDATE)
@RunWith(Parameterized.class)
@Description("Позитивные сценарии создания динамической текстовой кампании с автостратегиями для Search")
public class StrategyCombinationsAutoSearchTest {
    private static final String client = CampaignsLogins.CLIENT;
    private static final Currency currency = Currency.RUB;
    private static final Integer counterId = MetrikaGoals.getCounterForLogin(client);
    private static final Long goalId = MetrikaGoals.getGoalForCounter(counterId);
    private Long campaignId;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public String searchName;

    @Parameterized.Parameter(value = 1)
    public String contextName;

    @Parameterized.Parameter(value = 2)
    public DynamicTextCampaignSearchStrategyMap searchStrategy;

    @Parameterized.Parameter(value = 3)
    public DynamicTextCampaignNetworkStrategyMap networkStrategy;

    @Parameterized.Parameter(value = 4)
    public DynamicTextCampaignSearchStrategyMap expectedSearchStrategy;

    @Parameterized.Parameters(name = "search = {0}, context = {1}")
    public static Collection strategies() {
        Object[][] data = new Object[][]{
                //DIRECT-45818
                //ServingOff для Network
                {"AverageCpc", "ServingOff",
                        new DynamicTextCampaignSearchStrategyMap().defaultAverageCpc(currency),
                        new DynamicTextCampaignNetworkStrategyMap().defaultServingOff(),
                        new DynamicTextCampaignSearchStrategyMap().defaultAverageCpc(currency)},
                {"AverageCpa", "ServingOff",
                        new DynamicTextCampaignSearchStrategyMap().defaultAverageCpa(currency, goalId),
                        new DynamicTextCampaignNetworkStrategyMap().defaultServingOff(),
                        new DynamicTextCampaignSearchStrategyMap().defaultAverageCpa(currency, goalId)},
                {"MaximumConversionRate", "ServingOff",
                        new DynamicTextCampaignSearchStrategyMap().defaultWbMaximumConversionRate(currency, goalId),
                        new DynamicTextCampaignNetworkStrategyMap().defaultServingOff(),
                        new DynamicTextCampaignSearchStrategyMap().defaultWbMaximumConversionRate(currency, goalId)},
                {"MaximumClicks", "ServingOff",
                        new DynamicTextCampaignSearchStrategyMap().defaultWbMaximumClicks(currency),
                        new DynamicTextCampaignNetworkStrategyMap().defaultServingOff(),
                        new DynamicTextCampaignSearchStrategyMap().defaultWbMaximumClicks(currency)},
                {"AverageRoi", "ServingOff",
                        new DynamicTextCampaignSearchStrategyMap().defaultAverageRoi(goalId),
                        new DynamicTextCampaignNetworkStrategyMap().defaultServingOff(),
                        new DynamicTextCampaignSearchStrategyMap()
                                .withBiddingStrategyType(DynamicTextCampaignSearchStrategyTypeEnum.AVERAGE_ROI)
                                .withAverageRoi(new StrategyAverageRoiMap()
                                .defaultStrategyAverageRoi()
                                .withGoalId(goalId)
                                .withProfitability(null)
                                .withWeeklySpendLimit(null)
                                .withBidCeiling(null))},
        };
        return Arrays.asList(data);
    }

    @Before
    @Step("Подготовим данные для теста")
    public void clearUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("958")
    public void strategyNetworkTest() {
        campaignId = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        int shard = api.userSteps.clientFakeSteps().getUserShard(client);
        api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps()
                .addCampMetrikaGoals(campaignId, goalId, 100L, 100L);

        api.userSteps.campaignSteps().campaignsUpdateWithCheck(new CampaignUpdateItemMap()
                .withId(campaignId)
                .withDynamicTextCampaign(new DynamicTextCampaignUpdateItemMap()
                        .withBiddingStrategy(new DynamicTextCampaignStrategyMap()
                                .withSearch(searchStrategy)
                                .withNetwork(networkStrategy))));

        List<CampaignGetItem> campaigns = api.userSteps.campaignSteps().getCampaigns(
                new GetRequestMap().withSelectionCriteria(new CampaignsSelectionCriteriaMap()
                        .withIds(campaignId))
                        .withFieldNames(CampaignFieldEnum.ID)
                        .withDynamicTextCampaignFieldNames(DynamicTextCampaignFieldEnum.BIDDING_STRATEGY));
        assumeThat("получили кампанию", campaigns, hasSize(1));
        DynamicTextCampaignStrategy actualStrategy = campaigns.get(0).getDynamicTextCampaign().getBiddingStrategy();
        assumeThat("получили стратегии кампании", actualStrategy, notNullValue());

        DynamicTextCampaignStrategyMap expectedStrategy = new DynamicTextCampaignStrategyMap()
                .withSearch(expectedSearchStrategy)
                .withNetwork(networkStrategy);

        assertThat("получили корректные стратегии", actualStrategy,
                beanDifferV5((DynamicTextCampaignStrategy) expectedStrategy.getBean()));
    }
}
