package ru.yandex.autotests.direct.api.campaigns.update.dynamictextcampaign.strategy;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import com.yandex.direct.api.v5.campaigns.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.CampaignGetItem;
import com.yandex.direct.api.v5.campaigns.DynamicTextCampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.DynamicTextCampaignNetworkStrategyTypeEnum;
import com.yandex.direct.api.v5.campaigns.DynamicTextCampaignSearchStrategyTypeEnum;
import com.yandex.direct.api.v5.campaigns.DynamicTextCampaignStrategy;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignNetworkStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignSearchStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by chicos on 28.08.2015.
 */
@Aqua.Test
@Features(CampaignsFeatures.UPDATE)
@RunWith(Parameterized.class)
@Description("Обновление динамической текстовой кампании с ручными стратегиями для Search")
public class StrategyCombinationsManualSearchTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());
    private static final String client = CampaignsLogins.CLIENT;
    private static final Currency currency = Currency.RUB;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public String description;

    @Parameterized.Parameter(value = 1)
    public DynamicTextCampaignSearchStrategyMap searchStrategy;

    @Parameterized.Parameter(value = 2)
    public DynamicTextCampaignNetworkStrategyMap networkStrategy;

    @Parameterized.Parameter(value = 3)
    public DynamicTextCampaignSearchStrategyAddMap searchStrategyAdd;

    @Parameterized.Parameter(value = 4)
    public DynamicTextCampaignNetworkStrategyAddMap networkStrategyAdd;

    @Parameterized.Parameters(name = "Strategy = {0}")
    public static Collection roles() {
        Object[][] data = new Object[][]{
                //DIRECT-45770
                {"HighestPosition + ServingOff",
                        new DynamicTextCampaignSearchStrategyMap()
                                .withBiddingStrategyType(DynamicTextCampaignSearchStrategyTypeEnum.HIGHEST_POSITION),
                        new DynamicTextCampaignNetworkStrategyMap()
                                .withBiddingStrategyType(DynamicTextCampaignNetworkStrategyTypeEnum.SERVING_OFF),
                        new DynamicTextCampaignSearchStrategyAddMap()
                                .withBiddingStrategyType(DynamicTextCampaignSearchStrategyTypeEnum.HIGHEST_POSITION),
                        new DynamicTextCampaignNetworkStrategyAddMap()
                                .withBiddingStrategyType(DynamicTextCampaignNetworkStrategyTypeEnum.SERVING_OFF)}
        };
        return Arrays.asList(data);
    }

    @Before
    @Step("Подготовим данные для теста")
    public void clearUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("959")
    public void updateCampaignStrategyTest() {
        Long campaignId = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(
                new UpdateRequestMap().withCampaigns(new CampaignUpdateItemMap()
                        .defaultCampaignUpdateItem()
                        .withId(campaignId)
                        .withDynamicTextCampaign(new DynamicTextCampaignUpdateItemMap()
                                .withBiddingStrategy(new DynamicTextCampaignStrategyMap()
                                        .withSearch(searchStrategy)
                                        .withNetwork(networkStrategy)))),
                ExpectedResult.success(campaignId));

        List<CampaignGetItem> campaigns = api.userSteps.campaignSteps().getCampaigns(
                new GetRequestMap().withSelectionCriteria(new CampaignsSelectionCriteriaMap()
                        .withIds(campaignId))
                        .withFieldNames(CampaignFieldEnum.ID)
                        .withDynamicTextCampaignFieldNames(DynamicTextCampaignFieldEnum.BIDDING_STRATEGY));
        assumeThat("получили кампанию", campaigns, hasSize(1));
        DynamicTextCampaignStrategy actualStrategy = campaigns.get(0).getDynamicTextCampaign().getBiddingStrategy();
        assumeThat("получили стратегии кампании", actualStrategy, notNullValue());

        DynamicTextCampaignStrategyMap expectedStrategy = new DynamicTextCampaignStrategyMap()
                .withSearch(searchStrategy)
                .withNetwork(networkStrategy);

        assertThat("получили корректные стратегии", actualStrategy,
                beanDifferV5((DynamicTextCampaignStrategy) expectedStrategy.getBean()));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("960")
    public void updateToAutoStrategyTest() {
        //DIRECT-46187
        List<Long> ids = api.userSteps.campaignSteps().campaignsAddWithCheck(new CampaignAddItemMap()
                .defaultCampaignAddItem()
                .withDynamicTextCampaign(new DynamicTextCampaignAddItemMap()
                        .withBiddingStrategy(new DynamicTextCampaignStrategyAddMap()
                                .withSearch(searchStrategyAdd)
                                .withNetwork(networkStrategyAdd))));
        assumeThat("создана кампания", ids, hasSize(1));

        log.info("Изменим стратегию кампании на автобюджетную");
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(
                new UpdateRequestMap().withCampaigns(new CampaignUpdateItemMap()
                        .defaultCampaignUpdateItem()
                        .withId(ids.get(0))
                        .withDynamicTextCampaign(new DynamicTextCampaignUpdateItemMap()
                                .withBiddingStrategy(new DynamicTextCampaignStrategyMap()
                                        .withSearch(
                                                new DynamicTextCampaignSearchStrategyMap().defaultAverageCpc(currency))
                                        .withNetwork(
                                                new DynamicTextCampaignNetworkStrategyMap().defaultServingOff())))),
                ExpectedResult.success(ids.get(0)));

        List<CampaignGetItem> campaigns = api.userSteps.campaignSteps().getCampaigns(
                new GetRequestMap().withSelectionCriteria(new CampaignsSelectionCriteriaMap()
                        .withIds(ids.get(0)))
                        .withFieldNames(CampaignFieldEnum.ID)
                        .withDynamicTextCampaignFieldNames(DynamicTextCampaignFieldEnum.BIDDING_STRATEGY));
        assumeThat("получили кампанию", campaigns, hasSize(1));
        DynamicTextCampaignStrategy actualStrategy = campaigns.get(0).getDynamicTextCampaign().getBiddingStrategy();
        assumeThat("получили стратегии кампании", actualStrategy, notNullValue());

        DynamicTextCampaignStrategyMap expectedStrategy = new DynamicTextCampaignStrategyMap()
                .withSearch(new DynamicTextCampaignSearchStrategyMap().defaultAverageCpc(currency))
                .withNetwork(new DynamicTextCampaignNetworkStrategyMap().defaultServingOff());

        assertThat("стратегия изменена на автобюджетную", actualStrategy,
                beanDifferV5((DynamicTextCampaignStrategy) expectedStrategy.getBean()));
    }
}
