package ru.yandex.autotests.direct.api.campaigns.update.dynamictextcampaign.strategy;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import com.yandex.direct.api.v5.campaigns.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.CampaignGetItem;
import com.yandex.direct.api.v5.campaigns.DynamicTextCampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.DynamicTextCampaignSearchStrategyTypeEnum;
import com.yandex.direct.api.v5.campaigns.DynamicTextCampaignStrategy;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignNetworkStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignSearchStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyAverageRoiMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * https://st.yandex-team.ru/DIRECT-69356
 */
@Aqua.Test
@Features(CampaignsFeatures.UPDATE)
@RunWith(Parameterized.class)
@Issue("https://st.yandex-team.ru/DIRECT-64814")
@Description("Использование ecommerce цели в параметрах стратегии при обновлении кампании")
public class StrategyWithEcommerceGoalIdTest {
    private static final String client = CampaignsLogins.CLIENT;
    private static final Currency currency = Currency.RUB;
    private Long campaignId;
    static Long ecommerceGoalId = 3088178171L; // counter = 88178171 для at-campaigns-client

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public String description;

    @Parameterized.Parameter(value = 1)
    public DynamicTextCampaignSearchStrategyMap searchStrategy;

    @Parameterized.Parameter(value = 2)
    public DynamicTextCampaignNetworkStrategyMap networkStrategy;

    @Parameterized.Parameter(value = 3)
    public DynamicTextCampaignSearchStrategyMap expectedSearchStrategy;

    @Parameterized.Parameter(value = 4)
    public DynamicTextCampaignNetworkStrategyMap expectedNetworkStrategy;

    @Parameterized.Parameters(name = "{0}")
    public static Collection strategies() {
        Object[][] data = new Object[][]{
                {"Search:WbMaximumConversionRate with ecommerce",
                        new DynamicTextCampaignSearchStrategyMap().defaultWbMaximumConversionRate(currency, ecommerceGoalId),
                        new DynamicTextCampaignNetworkStrategyMap().defaultServingOff(),
                        new DynamicTextCampaignSearchStrategyMap().defaultWbMaximumConversionRate(currency, ecommerceGoalId),
                        new DynamicTextCampaignNetworkStrategyMap().defaultServingOff()},
                {"Search:AverageCpa with ecommerce",
                        new DynamicTextCampaignSearchStrategyMap().defaultAverageCpa(currency, ecommerceGoalId),
                        new DynamicTextCampaignNetworkStrategyMap().defaultServingOff(),
                        new DynamicTextCampaignSearchStrategyMap().defaultAverageCpa(currency, ecommerceGoalId),
                        new DynamicTextCampaignNetworkStrategyMap().defaultServingOff()},
                {"Search:AverageRoi with ecommerce",
                        new DynamicTextCampaignSearchStrategyMap().withBiddingStrategyType(DynamicTextCampaignSearchStrategyTypeEnum.AVERAGE_ROI)
                                .withAverageRoi(new StrategyAverageRoiMap()
                                        .defaultStrategyAverageRoi()
                                        .withWeeklySpendLimit(MoneyCurrency.get(currency).getMinWeeklyBudgetAmount().bidLong().longValue())
                                        .withProfitability(StrategyAverageRoiMap.DEFAULT_PROFITABILITY)
                                        .withBidCeiling(null)
                                        .withGoalId(ecommerceGoalId)),
                        new DynamicTextCampaignNetworkStrategyMap().defaultServingOff(),
                        new DynamicTextCampaignSearchStrategyMap().withBiddingStrategyType(DynamicTextCampaignSearchStrategyTypeEnum.AVERAGE_ROI)
                                .withAverageRoi(new StrategyAverageRoiMap()
                                .defaultStrategyAverageRoi()
                                .withWeeklySpendLimit(MoneyCurrency.get(currency).getMinWeeklyBudgetAmount().bidLong().longValue())
                                .withProfitability(StrategyAverageRoiMap.DEFAULT_PROFITABILITY)
                                .withBidCeiling(null)
                                .withGoalId(ecommerceGoalId)),
                        new DynamicTextCampaignNetworkStrategyMap().defaultServingOff()}
        };
        return Arrays.asList(data);
    }

    @Before
    @Step("Подготовим данные для теста")
    public void clearUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        campaignId = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        api.userSteps.getDirectJooqDbSteps().useShardForLogin(client).campMetrikaGoalsSteps()
                .createCampMetrikaGoals(campaignId, ecommerceGoalId, 100L, 100L);
    }

    @Test
    public void strategyWithECommerceGoalIdTest() {
        api.userSteps.campaignSteps().campaignsUpdateWithCheck(new CampaignUpdateItemMap()
                .withId(campaignId)
                .withDynamicTextCampaign(new DynamicTextCampaignUpdateItemMap()
                        .withBiddingStrategy(new DynamicTextCampaignStrategyMap()
                                .withSearch(searchStrategy)
                                .withNetwork(networkStrategy))));

        List<CampaignGetItem> campaigns = api.userSteps.campaignSteps().getCampaigns(
                new GetRequestMap().withSelectionCriteria(new CampaignsSelectionCriteriaMap()
                        .withIds(campaignId))
                        .withFieldNames(CampaignFieldEnum.ID)
                        .withDynamicTextCampaignFieldNames(DynamicTextCampaignFieldEnum.BIDDING_STRATEGY));
        assumeThat("получили кампанию", campaigns, hasSize(1));
        DynamicTextCampaignStrategy actualStrategy = campaigns.get(0).getDynamicTextCampaign().getBiddingStrategy();
        assumeThat("получили стратегии кампании", actualStrategy, notNullValue());

        DynamicTextCampaignStrategyMap expectedStrategy = new DynamicTextCampaignStrategyMap()
                .withSearch(expectedSearchStrategy)
                .withNetwork(expectedNetworkStrategy);

        assertThat("получили корректные стратегии", actualStrategy,
                beanDifferV5((DynamicTextCampaignStrategy) expectedStrategy.getBean()));
    }
}

