package ru.yandex.autotests.direct.api.campaigns.update.dynamictextcampaign.strategy.averagecpa;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.campaigns.DynamicTextCampaignSearchStrategyTypeEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignNetworkStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignSearchStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyAverageCpaMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.campaigns.MetrikaGoals;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult.both;

/**
 * Created by chicos on 04.09.2015.
 */
@Aqua.Test
@Features(CampaignsFeatures.UPDATE)
@RunWith(Parameterized.class)
@Description("Проверка взаимных сочетаний параметров BidCeiling, AverageCPA, WeeklySpendLimit при обновлении кампании со стратегией AverageCpa")
@Tag(TagDictionary.TRUNK)
public class StrategyAverageCpaPriceCombinationsTest {
    private static final String client = CampaignsLogins.CLIENT;
    private static final Currency currency = Currency.RUB;
    private static final Integer counterId = MetrikaGoals.getCounterForLogin(client);
    private static final Long goalId = MetrikaGoals.getGoalForCounter(counterId);
    private Long campaignId;

    private static final MoneyCurrency moneyCurrency = MoneyCurrency.get(currency);

    private DynamicTextCampaignStrategyMap strategyMap;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public Money bidCeiling;

    @Parameterized.Parameter(value = 1)
    public Money averageCpa;

    @Parameterized.Parameter(value = 2)
    public Money weeklyLimit;

    @Parameterized.Parameter(value = 3)
    public JavaOrPerlExpectedResult expectedResult;

    @Parameterized.Parameters(name = "bidCeiling = {0}, averageCpa = {1}, limit = {2}")
    public static Collection strategies() {
        Object[][] data = new Object[][]{
                //допустимые значения
                //minCpa <= cpa <= limit
                //minPrice <= bid <= limit
                //minWeeklyLimit <= limit <= maxWeeklyLimit
                //взаимозависимости между cpa и bid - нет

                //cpa < bid < limit
                {moneyCurrency.getMinAveragePrice().getNext(), moneyCurrency.getMinAveragePrice(),
                        moneyCurrency.getMinWeeklyBudgetAmount(),
                        both(ExpectedResult.success())},
                //bid = cpa (= minCpa)
                {moneyCurrency.getMinAveragePrice(), moneyCurrency.getMinAveragePrice(), null,
                        both(ExpectedResult.success())},
                //bid = cpa (= maxPrice)
                {moneyCurrency.getMaxPrice(), moneyCurrency.getMaxPrice(), null,
                        both(ExpectedResult.success())},
                //cpa < limit
                {null, moneyCurrency.getMinAveragePrice(), moneyCurrency.getMinWeeklyBudgetAmount(),
                        both(ExpectedResult.success())},

                //cpa = bid = limit
                {moneyCurrency.getMinWeeklyBudgetAmount(), moneyCurrency.getMinWeeklyBudgetAmount(),
                        moneyCurrency.getMinWeeklyBudgetAmount(),
                        both(ExpectedResult.success())},
                //cpa = limit
                {null, moneyCurrency.getMinWeeklyBudgetAmount(), moneyCurrency.getMinWeeklyBudgetAmount(),
                        both(ExpectedResult.success())},
                //bid = limit
                {moneyCurrency.getMinWeeklyBudgetAmount(), moneyCurrency.getMinWeeklyBudgetAmount().getPrevious(),
                        moneyCurrency.getMinWeeklyBudgetAmount(),
                        both(ExpectedResult.success())},

                //bid < cpa - DIRECT-46055
                {moneyCurrency.getMinAveragePrice(), moneyCurrency.getMinAveragePrice().getNext(), null,
                        both(ExpectedResult.success())},
                //bid > limit
                {moneyCurrency.getMinWeeklyBudgetAmount().getNext(),
                        moneyCurrency.getMinWeeklyBudgetAmount().getPrevious(),
                        moneyCurrency.getMinWeeklyBudgetAmount(),
                        JavaOrPerlExpectedResult
                                .java(ExpectedResult.errors(new Notification(4000,
                                        Api5ErrorDetailsJava.MUST_BE_LESS_THAN_OR_EQUAL_TO_WEEKLY_BUDGET,
                                        "BidCeiling")))
                                .perl(ExpectedResult.errors(new Notification(4000,
                                        Api5ErrorDetails.WEEKLY_BUDGET_MUST_BE_GREATER_THAN_MAXIMUM_BID)))},
                //cpa > limit
                {null, moneyCurrency.getMinWeeklyBudgetAmount().getNext(), moneyCurrency.getMinWeeklyBudgetAmount(),
                        JavaOrPerlExpectedResult
                                .java(ExpectedResult.errors(new Notification(4000,
                                        Api5ErrorDetailsJava.MUST_BE_LESS_THAN_OR_EQUAL_TO_WEEKLY_BUDGET,
                                        "AverageCpa")))
                                .perl(ExpectedResult.errors(new Notification(4000,
                                        Api5ErrorDetails.WEEKLY_LIMIT_SHOULD_BE_GREATER_THAN_AVERAGE_CPA)))},
        };
        return Arrays.asList(data);
    }

    @Before
    @Step("Подготовим данные для теста")
    public void clearUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        campaignId = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        int shard = api.userSteps.clientFakeSteps().getUserShard(client);
        api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps()
                .addCampMetrikaGoals(campaignId, goalId, 100L, 100L);

        StrategyAverageCpaMap params = new StrategyAverageCpaMap();
        if (weeklyLimit != null) {
            params.withWeeklySpendLimit(weeklyLimit.bidLong().longValue());
        }
        if (bidCeiling != null) {
            params.withBidCeiling(bidCeiling.bidLong().longValue());
        }
        strategyMap = new DynamicTextCampaignStrategyMap()
                .withSearch(new DynamicTextCampaignSearchStrategyMap()
                        .withBiddingStrategyType(DynamicTextCampaignSearchStrategyTypeEnum.AVERAGE_CPA)
                        .withAverageCpa(params
                                .withGoalId(goalId)
                                .withAverageCpa(averageCpa.bidLong().longValue())))
                .withNetwork(new DynamicTextCampaignNetworkStrategyMap().defaultServingOff());
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("969")
    public void priceCombinationsTest() {
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(
                new UpdateRequestMap().withCampaigns(new CampaignUpdateItemMap()
                        .withId(campaignId)
                        .withDynamicTextCampaign(new DynamicTextCampaignUpdateItemMap()
                                .withBiddingStrategy(strategyMap))),
                expectedResult);
    }
}
