package ru.yandex.autotests.direct.api.campaigns.update.dynamictextcampaign.strategy.averagecpa;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.campaigns.DynamicTextCampaignSearchStrategyTypeEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.direct.utils.money.MoneyFormat;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignNetworkStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignSearchStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyAverageCpaMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.campaigns.MetrikaGoals;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by chicos on 03.09.2015.
 */
@Aqua.Test
@Features(CampaignsFeatures.UPDATE)
@RunWith(Parameterized.class)
@Description("Негативные сценарии проверки параметра WeeklySpendLimit при обновлении кампании со стратегией AverageCpa")
public class StrategyAverageCpaWeeklySpendLimitNegativeTest {
    private static final String client = CampaignsLogins.CLIENT;
    private static final Currency currency = Currency.RUB;
    private static final Integer counterId = MetrikaGoals.getCounterForLogin(client);
    private static final Long goalId = MetrikaGoals.getGoalForCounter(counterId);
    private static MoneyCurrency moneyCurrency = MoneyCurrency.get(currency);
    private Long campaignId;

    private static final Money averageCPA = moneyCurrency.getMinAveragePrice().bidLong();
    private static final Money minLimit = moneyCurrency.getMinWeeklyBudgetAmount();
    private static final Money maxLimit = moneyCurrency.getMaxWeeklyBudgetAmount();

    private DynamicTextCampaignStrategyMap strategyMap;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public String description;

    @Parameterized.Parameter(value = 1)
    public Long weeklyLimit;

    @Parameterized.Parameter(value = 2)
    public JavaOrPerlExpectedResult expectedResult;

    @Parameterized.Parameters(name = "test = {0}")
    public static Collection strategies() {
        Object[][] data = new Object[][]{
                //DIRECT-45834
                {"Нулевое значение", 0L, JavaOrPerlExpectedResult
                        .java(ExpectedResult.errors(
                                new Notification(4000,
                                        Api5ErrorDetailsJava.VALUE_MUST_NOT_BE_LESS_WITHOUT_CURRENCY,
                                        "WeeklySpendLimit",
                                        minLimit.stringValue(MoneyFormat.WITHOUT_EXTRA_ZEROS)),
                                new Notification(4000,
                                        Api5ErrorDetailsJava.MUST_BE_LESS_THAN_OR_EQUAL_TO_WEEKLY_BUDGET,
                                        "AverageCpa")))
                        .perl(ExpectedResult.errors(
                                new Notification(4000,
                                        Api5ErrorDetails.WEEKLY_LIMIT_SHOULD_BE_MORE_THAN,
                                        minLimit.stringValue(MoneyFormat.TWO_DIGITS_POINT_SEPARATED),
                                        moneyCurrency.getApiDescription())))},
                //DIRECT-46089
                {"Отрицательное значение", -1L, JavaOrPerlExpectedResult
                        .java(ExpectedResult.errors(
                                new Notification(4000,
                                        Api5ErrorDetailsJava.VALUE_MUST_NOT_BE_LESS_WITHOUT_CURRENCY,
                                        "WeeklySpendLimit",
                                        minLimit.stringValue(MoneyFormat.WITHOUT_EXTRA_ZEROS)),
                                new Notification(4000,
                                        Api5ErrorDetailsJava.MUST_BE_LESS_THAN_OR_EQUAL_TO_WEEKLY_BUDGET,
                                        "AverageCpa")))
                        .perl(ExpectedResult.errors(
                                new Notification(4000,
                                        Api5ErrorDetails.WEEKLY_LIMIT_SHOULD_BE_MORE_THAN,
                                        minLimit.stringValue(MoneyFormat.TWO_DIGITS_POINT_SEPARATED),
                                        moneyCurrency.getApiDescription())))},
                {"Значение меньше минимального",
                        minLimit.getPrevious().bidLong().longValue(), JavaOrPerlExpectedResult
                        .java(ExpectedResult.errors(
                                new Notification(4000,
                                        Api5ErrorDetailsJava.VALUE_MUST_NOT_BE_LESS_WITHOUT_CURRENCY,
                                        "WeeklySpendLimit",
                                        minLimit.stringValue(MoneyFormat.WITHOUT_EXTRA_ZEROS))))
                        .perl(ExpectedResult.errors(
                                new Notification(4000,
                                        Api5ErrorDetails.WEEKLY_LIMIT_SHOULD_BE_MORE_THAN,
                                        minLimit.stringValue(MoneyFormat.TWO_DIGITS_POINT_SEPARATED),
                                        moneyCurrency.getApiDescription())))},
                {"Значение больше максимального",
                        maxLimit.getNext().bidLong().longValue(), JavaOrPerlExpectedResult
                        .java(ExpectedResult.errors(new Notification(4000,
                                Api5ErrorDetailsJava.VALUE_MUST_NOT_BE_GREATER_THAN,
                                "WeeklySpendLimit",
                                maxLimit.stringValue(MoneyFormat.WITHOUT_EXTRA_ZEROS))))
                        .perl(ExpectedResult.errors(new Notification(4000,
                                Api5ErrorDetails.WEEKLY_LIMIT_IS_TOO_HIGH,
                                maxLimit.stringValue(MoneyFormat.TWO_DIGITS_POINT_SEPARATED),
                                moneyCurrency.getApiDescription())))},
        };
        return Arrays.asList(data);
    }

    @Before
    @Step("Подготовим данные для теста")
    public void clearUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        campaignId = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        int shard = api.userSteps.clientFakeSteps().getUserShard(client);
        api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps()
                .addCampMetrikaGoals(campaignId, goalId, 100L, 100L);

        strategyMap = new DynamicTextCampaignStrategyMap()
                .withSearch(new DynamicTextCampaignSearchStrategyMap()
                        .withBiddingStrategyType(DynamicTextCampaignSearchStrategyTypeEnum.AVERAGE_CPA)
                        .withAverageCpa(new StrategyAverageCpaMap()
                                .withWeeklySpendLimit(weeklyLimit)
                                .withAverageCpa(averageCPA.longValue())
                                .withGoalId(goalId)))
                .withNetwork(new DynamicTextCampaignNetworkStrategyMap().defaultServingOff());
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("970")
    public void weeklyLimitNegativeTest() {
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(
                new UpdateRequestMap().withCampaigns(new CampaignUpdateItemMap()
                        .withId(campaignId)
                        .withDynamicTextCampaign(new DynamicTextCampaignUpdateItemMap()
                                .withBiddingStrategy(strategyMap))),
                expectedResult);
    }
}
