package ru.yandex.autotests.direct.api.campaigns.update.dynamictextcampaign.strategy.averageroi;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.campaigns.DynamicTextCampaignSearchStrategyTypeEnum;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignNetworkStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignSearchStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyAverageRoiMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.campaigns.MetrikaGoals;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by chicos on 04.09.2015.
 */
@Aqua.Test
@Features(CampaignsFeatures.UPDATE)
@RunWith(Parameterized.class)
@Description("Проверка взаимных сочетаний параметров ReserveReturn, RoiCoef, Profitability при обновлении кампании со стратегией AverageRoi")
public class StrategyAverageRoiFieldCombinationsNegativeTest {
    private static final String client = CampaignsLogins.CLIENT;
    private static final Long goalId = MetrikaGoals.getGoalsForLogin(client, 1).get(0);
    private static Long campaignId;

    private DynamicTextCampaignStrategyMap strategyMap;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public Integer reserveReturn;

    @Parameterized.Parameter(value = 1)
    public Long roiCoef;

    @Parameterized.Parameter(value = 2)
    public Long profitability;

    @Parameterized.Parameter(value = 3)
    public JavaOrPerlExpectedResult expectedResult;

    @Parameterized.Parameters(name = "reserveReturn = {0}, roiCoef = {1}, profitability = {2}")
    public static Collection strategies() {
        Object[][] data = new Object[][]{
                {StrategyAverageRoiMap.DEFAULT_RESERVE_RETURN + 7, StrategyAverageRoiMap.DEFAULT_ROI_COEF,
                        StrategyAverageRoiMap.DEFAULT_PROFITABILITY,
                        JavaOrPerlExpectedResult.both(ExpectedResult.errors(new Notification(4000,
                                Api5ErrorDetails.RESERVE_RETURN_SHOULD_BE_IN_INTERVAL_AND_MULTIPLE_OF_TEN)))
                },
                {StrategyAverageRoiMap.MIN_RESERVE_RETURN - 10, StrategyAverageRoiMap.DEFAULT_ROI_COEF,
                        StrategyAverageRoiMap.DEFAULT_PROFITABILITY,
                        JavaOrPerlExpectedResult.both(ExpectedResult.errors(new Notification(4000,
                                Api5ErrorDetails.RESERVE_RETURN_SHOULD_BE_IN_INTERVAL_AND_MULTIPLE_OF_TEN)))
                },
                {StrategyAverageRoiMap.MAX_RESERVE_RETURN + 10, StrategyAverageRoiMap.DEFAULT_ROI_COEF,
                        StrategyAverageRoiMap.DEFAULT_PROFITABILITY,
                        JavaOrPerlExpectedResult.both(ExpectedResult.errors(new Notification(4000,
                                Api5ErrorDetails.RESERVE_RETURN_SHOULD_BE_IN_INTERVAL_AND_MULTIPLE_OF_TEN)))
                },

                {StrategyAverageRoiMap.DEFAULT_RESERVE_RETURN, StrategyAverageRoiMap.MIN_ROI_COEF - 10000L,
                        StrategyAverageRoiMap.DEFAULT_PROFITABILITY,
                        JavaOrPerlExpectedResult.both(ExpectedResult.errors(
                                new Notification(4000, Api5ErrorDetails.ROI_COEF_SHOULD_BE_GREATER_THAN)))
                },

                //DIRECT-46126
                {StrategyAverageRoiMap.DEFAULT_RESERVE_RETURN, StrategyAverageRoiMap.DEFAULT_ROI_COEF,
                        StrategyAverageRoiMap.MIN_PROFITABILITY - 1000000L,
                        JavaOrPerlExpectedResult
                                .java(ExpectedResult.errors(new Notification(4000,
                                        Api5ErrorDetailsJava.VALUE_MUST_NOT_BE_LESS_WITHOUT_CURRENCY,
                                        "Profitability", "0")))
                                .perl(ExpectedResult.errors(
                                        new Notification(4000, Api5ErrorDetails.PROFITABILITY_SHOULD_BE_IN_INTERVAL)))
                },
                {StrategyAverageRoiMap.DEFAULT_RESERVE_RETURN, StrategyAverageRoiMap.DEFAULT_ROI_COEF,
                        StrategyAverageRoiMap.MAX_PROFITABILITY + 1000000L,
                        JavaOrPerlExpectedResult
                                .java(ExpectedResult.errors(new Notification(4000,
                                        Api5ErrorDetailsJava.VALUE_MUST_NOT_BE_GREATER_THAN,
                                        "Profitability", "100")))
                                .perl(ExpectedResult.errors(
                                        new Notification(4000, Api5ErrorDetails.PROFITABILITY_SHOULD_BE_IN_INTERVAL)))
                }
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void addCampaign() {
        campaignId = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();

        int shard = api.userSteps.clientFakeSteps().getUserShard(client);
        api.userSteps.getDirectJooqDbSteps().useShard(shard).campMetrikaGoalsSteps()
                .addOrUpdateMetrikaGoals(campaignId, goalId, 100L, 100L);
    }

    @Before
    @Step("Подготовим данные для теста")
    public void clearUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        strategyMap = new DynamicTextCampaignStrategyMap()
                .withSearch(new DynamicTextCampaignSearchStrategyMap()
                        .withBiddingStrategyType(DynamicTextCampaignSearchStrategyTypeEnum.AVERAGE_ROI)
                        .withAverageRoi(new StrategyAverageRoiMap()
                                .withGoalId(goalId)
                                .withReserveReturn(reserveReturn)
                                .withRoiCoef(roiCoef)
                                .withProfitability(profitability)))
                .withNetwork(new DynamicTextCampaignNetworkStrategyMap().defaultServingOff());
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("978")
    public void roiOptimizationNegativeTest() {
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(
                new UpdateRequestMap().withCampaigns(new CampaignUpdateItemMap()
                        .withId(campaignId)
                        .withDynamicTextCampaign(new DynamicTextCampaignUpdateItemMap()
                                .withBiddingStrategy(strategyMap))),
                expectedResult);
    }
}
