package ru.yandex.autotests.direct.api.campaigns.update.dynamictextcampaign.strategy.averageroi;

import com.yandex.direct.api.v5.general.OperationEnum;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.PriorityGoalsUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.PriorityGoalsUpdateSettingMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.campaigns.MetrikaGoals;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

@Aqua.Test
@Features(CampaignsFeatures.UPDATE)
@Description("Проверка параметра GoalId при обновлении кампании со стратегией AverageRoi, когда к кампании привязан " +
        "счётчик метрики соответсвующий этому GoalId (это полезный тест т.к. в ядре есть 2 разные ветки - " +
        "когда в кампании есть счётчики метрики и когда их нет).")
public class StrategyAverageRoiGoalIdWithMetrikaCountersTest {

    private static final String client = CampaignsLogins.CLIENT;
    private static Long campaignId;
    private static final Integer COUNTER_ID = 32265784;
    private static final Long goalId = MetrikaGoals.getConterGoalIds(COUNTER_ID, 1)[0];

    @ClassRule
    public static final ApiSteps api = new ApiSteps().as(client);

    @ClassRule
    public static final SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @BeforeClass
    public static void prepareCampaign() {
        campaignId = api.userSteps.campaignSteps().addCampaign(new CampaignAddItemMap()
                .defaultCampaignAddItem()
                .withDynamicTextCampaign(new DynamicTextCampaignAddItemMap()
                        .withBiddingStrategy(new DynamicTextCampaignStrategyAddMap()
                                .defaultDynamicTextCampaignStrategy())
                        .withCounterIds(COUNTER_ID)
                )
        );
    }

    @Before
    public void clearUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
    }

    @Test
    public void counterAddedToCampaign_updatePriorityGoal_Success() {
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(
                new UpdateRequestMap().withCampaigns(new CampaignUpdateItemMap()
                        .withId(campaignId)
                        .withDynamicTextCampaign(new DynamicTextCampaignUpdateItemMap()
                                .withPriorityGoals(new PriorityGoalsUpdateSettingMap()
                                        .withItems(new PriorityGoalsUpdateItemMap()
                                                .withGoalId(goalId)
                                                .withValue(13_000_000L)
                                                .withOperation(OperationEnum.SET)))
                        )),
                ExpectedResult.success());
    }
}
