package ru.yandex.autotests.direct.api.campaigns.update.dynamictextcampaign.strategy.averageroi;

import com.yandex.direct.api.v5.general.OperationEnum;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.PriorityGoalsUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.PriorityGoalsUpdateSettingMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.campaigns.MetrikaGoals;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

@Aqua.Test
@Features(CampaignsFeatures.UPDATE)
@Description("Проверка параметра GoalId при обновлении кампании со стратегией AverageRoi, когда к кампании привязан " +
        "счётчик метрики НЕ соответсвующий этому GoalId.")
public class StrategyAverageRoiGoalIdWithWrongMetrikaCountersTest {

    private static final String client = CampaignsLogins.CLIENT;
    private static Long campaignId;
    private static final Integer COUNTER_ID = 31844711;
    private static final Long goalId = MetrikaGoals.getConterGoalIds(32265784, 1)[0];

    @ClassRule
    public static final ApiSteps api = new ApiSteps().as(client);

    @ClassRule
    public static final SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @BeforeClass
    public static void prepareCampaign() {
        campaignId = api.userSteps.campaignSteps().addCampaign(new CampaignAddItemMap()
                .defaultCampaignAddItem()
                .withDynamicTextCampaign(new DynamicTextCampaignAddItemMap()
                        .withBiddingStrategy(new DynamicTextCampaignStrategyAddMap()
                                .defaultDynamicTextCampaignStrategy())
                        .withCounterIds(COUNTER_ID)
                )
        );
    }

    @Before
    public void clearUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
    }

    @Test
    @Description("Если привязан goalId и счётчик не от этого goalId, то такой goalId можно использовать в " +
            "PriorityGoals (так работал perl и так переписали на Java)")
    public void goalAddedToCampaign_updatePriorityGoal_Success() {
        api.userSteps.getDirectJooqDbSteps().useShardForLogin(client).campaignsSteps()
                .addCampMetrikaGoals(campaignId, goalId, 0L, 100L);

        api.userSteps.campaignSteps().shouldGetResultOnUpdate(
                new UpdateRequestMap().withCampaigns(new CampaignUpdateItemMap()
                        .withId(campaignId)
                        .withDynamicTextCampaign(new DynamicTextCampaignUpdateItemMap()
                                .withPriorityGoals(new PriorityGoalsUpdateSettingMap()
                                        .withItems(new PriorityGoalsUpdateItemMap()
                                                .withGoalId(goalId)
                                                .withValue(13_000_000L)
                                                .withOperation(OperationEnum.SET)))
                        )),
                ExpectedResult.success());
    }


    @Test
    @Description("Если goalId не привязан и счётчик от goalId не привязан, то такой goalId нельзя использовать в " +
            "PriorityGoals")
    public void goalNotAddedToCampaign_updatePriorityGoal_Error() {
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(
                new UpdateRequestMap().withCampaigns(new CampaignUpdateItemMap()
                        .withId(campaignId)
                        .withDynamicTextCampaign(new DynamicTextCampaignUpdateItemMap()
                                .withPriorityGoals(new PriorityGoalsUpdateSettingMap()
                                        .withItems(new PriorityGoalsUpdateItemMap()
                                                .withGoalId(goalId)
                                                .withValue(13_000_000L)
                                                .withOperation(OperationEnum.SET)))
                        )),
                JavaOrPerlExpectedResult
                        .java(ExpectedResult.errors(new Notification(8800,
                                Api5ErrorDetailsJava.NOT_FOUND_PATH_AND_VALUE,
                                "PriorityGoals[0].GoalId", goalId)))
                        .perl(ExpectedResult.errors(new Notification(8800,
                                Api5ErrorDetails.PRIORITY_GOAL_ID_NOT_FOUND,
                                goalId))));
    }

}