package ru.yandex.autotests.direct.api.campaigns.update.dynamictextcampaign.strategy.averageroi;

import com.yandex.direct.api.v5.campaigns.DynamicTextCampaignSearchStrategyTypeEnum;
import com.yandex.direct.api.v5.general.OperationEnum;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignNetworkStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignSearchStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.PriorityGoalsUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.PriorityGoalsUpdateSettingMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyAverageRoiMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.directapi.model.api5.campaigns.StrategyAverageRoiAddMap.MEANINGFUL_GOAL_OPTIMIZATION_GOAL_ID;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by pashkus on 21.06.2019.
 */
@Aqua.Test
@Features(CampaignsFeatures.UPDATE)
@Description("Проверка обновлении стратегии на AverageRoi с установкой оптимизации по ключевым целям")
public class StrategyAverageRoiMeaningfulGoalIdDbTest {
    private static final String client = CampaignsLogins.CLIENT;
    private static Long campaignId;

    private static final Integer COUNTER_ID = 32265784;
    private static final Long GOAL_ID = 13088934L;

    private DynamicTextCampaignStrategyMap strategyMap;

    @ClassRule
    public static final ApiSteps api = new ApiSteps().as(client);

    @ClassRule
    public static final SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);


    @BeforeClass
    public static void prepareCampaign() {
        campaignId = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
    }

    @Before
    public void clearUnits() {
        strategyMap = new DynamicTextCampaignStrategyMap()
                .withSearch(new DynamicTextCampaignSearchStrategyMap()
                        .withBiddingStrategyType(DynamicTextCampaignSearchStrategyTypeEnum.AVERAGE_ROI)
                        .withAverageRoi(new StrategyAverageRoiMap()
                                .defaultStrategyAverageRoi()
                                .withGoalId(MEANINGFUL_GOAL_OPTIMIZATION_GOAL_ID)))
                .withNetwork(new DynamicTextCampaignNetworkStrategyMap().defaultServingOff());
    }

    @Test
    public void settingRoiPriorityGoalsOptimizationAndPriorityGoalsTest() {
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(
                new UpdateRequestMap().withCampaigns(new CampaignUpdateItemMap()
                        .withId(campaignId)
                        .withDynamicTextCampaign(new DynamicTextCampaignUpdateItemMap()
                                .withCounterIds(COUNTER_ID)
                                .withPriorityGoals(new PriorityGoalsUpdateSettingMap()
                                        .withItems(new PriorityGoalsUpdateItemMap()
                                                .withGoalId(GOAL_ID)
                                                .withValue(13_000_000L)
                                                .withOperation(OperationEnum.SET)))
                                .withBiddingStrategy(strategyMap))),
                ExpectedResult.success(campaignId));



        assertThat("campaigns.strategy_data.goal_id соответствует ожиданиям",
                api.userSteps.getDirectJooqDbSteps().useShardForLogin(client).campaignsSteps()
                        .getCampaignById(campaignId).getStrategyData().getAsJsonObject().get("goal_id").getAsLong(),
                equalTo(MEANINGFUL_GOAL_OPTIMIZATION_GOAL_ID));
    }


    @Test
    public void settingRoiPriorityGoalsOptimizationForExistentPriorityGoals() {

        //устанавливаем ключевые цели
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(
                new UpdateRequestMap().withCampaigns(new CampaignUpdateItemMap()
                        .withId(campaignId)
                        .withDynamicTextCampaign(new DynamicTextCampaignUpdateItemMap()
                                .withCounterIds(COUNTER_ID)
                                .withPriorityGoals(new PriorityGoalsUpdateSettingMap()
                                        .withItems(new PriorityGoalsUpdateItemMap()
                                                .withGoalId(GOAL_ID)
                                                .withValue(13_000_000L)
                                                .withOperation(OperationEnum.SET))))),
                ExpectedResult.success(campaignId));

        //а затем переходим на оптимизацию по КЦ
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(
                new UpdateRequestMap().withCampaigns(new CampaignUpdateItemMap()
                        .withId(campaignId)
                        .withDynamicTextCampaign(new DynamicTextCampaignUpdateItemMap()
                                .withBiddingStrategy(strategyMap))),
                ExpectedResult.success(campaignId));

        api.userSteps.getDirectJooqDbSteps().useShardForLogin(client).campaignsSteps()
                .getCampaignById(campaignId).getStrategyData().getAsJsonObject().get("goal_id");

        assertThat("campaigns.strategy_data.goal_id соответствует ожиданиям",
                api.userSteps.getDirectJooqDbSteps().useShardForLogin(client).campaignsSteps()
                        .getCampaignById(campaignId).getStrategyData().getAsJsonObject().get("goal_id").getAsLong(),
                equalTo(MEANINGFUL_GOAL_OPTIMIZATION_GOAL_ID));
    }
}
