package ru.yandex.autotests.direct.api.campaigns.update.dynamictextcampaign.strategy.bids;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import com.yandex.direct.api.v5.dynamictextadtargets.WebpageFieldEnum;
import com.yandex.direct.api.v5.dynamictextadtargets.WebpageGetItem;
import com.yandex.direct.api.v5.general.PriorityEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignNetworkStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignSearchStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.SetBidsItemMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.SetBidsRequestMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.WebpageAddItemMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.WebpageGetItemMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanEquivalentV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

@Aqua.Test
@Features(CampaignsFeatures.UPDATE)
@RunWith(Parameterized.class)
@Description("Проверка возможных изменений ставок при переключениях между автоматическими стратегиями кампании на поиске/сети")
@Tag(TagDictionary.TRUNK)
public class StrategyAutoToAutoChangeBidsTest {
    private static final String client = CampaignsLogins.CLIENT;
    private static final Currency currency = Currency.RUB;
    private static MoneyCurrency moneyCurrency = MoneyCurrency.get(currency);

    private static DynamicTextCampaignStrategyMap strategyMap;
    private Long campaignId;
    private Long webpageId;
    private static final Money defaultBid = moneyCurrency.getMinPrice();

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public String description;

    @Parameterized.Parameter(value = 1)
    public DynamicTextCampaignSearchStrategyAddMap searchStrategyPrevious;

    @Parameterized.Parameter(value = 2)
    public DynamicTextCampaignNetworkStrategyAddMap networkStrategyPrevious;

    @Parameterized.Parameter(value = 3)
    public DynamicTextCampaignSearchStrategyMap searchStrategy;

    @Parameterized.Parameter(value = 4)
    public DynamicTextCampaignNetworkStrategyMap networkStrategy;
    private Long groupId;

    @Parameterized.Parameters(name = "test = {0}")
    public static Collection strategies() {
        Object[][] data = new Object[][]{
                {"Auto1 - ServingOff -> Авто2 - ServingOff",
                        new DynamicTextCampaignSearchStrategyAddMap().defaultAverageCpc(currency),
                        new DynamicTextCampaignNetworkStrategyAddMap().defaultServingOff(),
                        new DynamicTextCampaignSearchStrategyMap().defaultWbMaximumClicks(currency),
                        new DynamicTextCampaignNetworkStrategyMap().defaultServingOff()},
                {"Auto1 - ServingOff -> Авто2 - ServingOff",
                        new DynamicTextCampaignSearchStrategyAddMap().defaultWbMaximumClicks(currency),
                        new DynamicTextCampaignNetworkStrategyAddMap().defaultServingOff(),
                        new DynamicTextCampaignSearchStrategyMap().defaultAverageCpc(currency),
                        new DynamicTextCampaignNetworkStrategyMap().defaultServingOff()}
        };
        return Arrays.asList(data);
    }

    @Before
    @Step("Подготовим данные для теста")
    public void clearUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        List<Long> ids = api.userSteps.campaignStepsV5().campaignsAddWithCheck(new CampaignAddItemMap()
                .defaultCampaignAddItem()
                .withDynamicTextCampaign(new DynamicTextCampaignAddItemMap()
                        .withBiddingStrategy(new DynamicTextCampaignStrategyAddMap()
                                .withSearch(searchStrategyPrevious)
                                .withNetwork(networkStrategyPrevious))));
        assumeThat("создана кампания", ids, hasSize(1));
        campaignId = ids.get(0);
        groupId = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(campaignId, client);
        api.userSteps.adsSteps().addDefaultDynamicTextAd(groupId);
        webpageId = api.userSteps.dynamicTextAdTargetsSteps().addWebpage(new WebpageAddItemMap()
                .defaultWebpage(groupId), client);

        api.userSteps.dynamicTextAdTargetsSteps().dynamicTextAdTargetsSetBids(new SetBidsRequestMap()
                        .withBids(new SetBidsItemMap()
                                .withId(webpageId)
                                .withStrategyPriority(PriorityEnum.HIGH)
                                .withBid(defaultBid.getNext().bidLong().longValue())
                                .withContextBid(defaultBid.getNext().bidLong().longValue())));

        strategyMap = new DynamicTextCampaignStrategyMap()
                .withSearch(searchStrategy)
                .withNetwork(networkStrategy);
    }

    @Test
    public void bidChangeOnStrategyUpdateTest() {
        api.userSteps.campaignStepsV5().campaignsUpdateWithCheck(new CampaignUpdateItemMap()
                .withId(campaignId)
                .withDynamicTextCampaign(new DynamicTextCampaignUpdateItemMap()
                        .withBiddingStrategy(strategyMap)));

        List<WebpageGetItem> webpages = api.userSteps.dynamicTextAdTargetsSteps()
                .dynamicTextAdTargetsGetFieldNamesById(webpageId, client,
                        WebpageFieldEnum.BID, WebpageFieldEnum.CONTEXT_BID, WebpageFieldEnum.STRATEGY_PRIORITY)
                .getWebpages();
        assumeThat("получили условие", webpages, hasSize(1));

        WebpageGetItemMap expectedWebpage = new WebpageGetItemMap()
                .withStrategyPriority(PriorityEnum.HIGH)
                .withBid(defaultBid.getNext().bidLong().longValue())
                .withContextBid(defaultBid.getNext().bidLong().longValue());

        assertThat("корректные ставки условия", webpages.get(0), beanEquivalentV5(expectedWebpage.getBean()));
    }
}
