package ru.yandex.autotests.direct.api.campaigns.update.dynamictextcampaign.strategy.maximumclicks;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import com.yandex.direct.api.v5.campaigns.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.CampaignGetItem;
import com.yandex.direct.api.v5.campaigns.DynamicTextCampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.DynamicTextCampaignSearchStrategyTypeEnum;
import com.yandex.direct.api.v5.campaigns.DynamicTextCampaignStrategy;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignNetworkStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignSearchStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyMaximumClicksAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyMaximumClicksMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by chicos on 07.09.2015.
 */
@Aqua.Test
@Features(CampaignsFeatures.UPDATE)
@RunWith(Parameterized.class)
@Description("Позитивные сценарии проверки параметра WeeklySpendLimit при обновлении кампании со стратегией MaximumClicks")
public class StrategyMaximumClicksWeeklySpendLimitTest {
    private static final String client = CampaignsLogins.CLIENT;
    private static final Currency currency = Currency.RUB;

    private static final Money minLimit = MoneyCurrency.get(currency).getMinWeeklyBudgetAmount();
    private static final Money maxLimit = MoneyCurrency.get(currency).getMaxWeeklyBudgetAmount();

    private DynamicTextCampaignStrategyMap strategyMap;
    private Long campaignId;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public String description;

    @Parameterized.Parameter(value = 1)
    public Long weeklyLimit;

    @Parameterized.Parameter(value = 2)
    public Long bidCeiling;

    @Parameterized.Parameters(name = "test = {0}")
    public static Collection strategies() {
        Object[][] data = new Object[][]{
                {"Значение больше минимального", minLimit.getNext().bidLong().longValue(), null},
                {"Минимальное значение", minLimit.bidLong().longValue(), null},
                {"Максимальное значение", maxLimit.bidLong().longValue(), null},
                {"Значение бюджета равно максимальной ставке", minLimit.bidLong().longValue(),
                        minLimit.bidLong().longValue()}
        };
        return Arrays.asList(data);
    }

    @Before
    @Step("Подготовим данные для теста")
    public void clearUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        campaignId = api.userSteps.campaignSteps().addCampaign(new CampaignAddItemMap()
                .defaultCampaignAddItem()
                .withDynamicTextCampaign(new DynamicTextCampaignAddItemMap()
                        .withBiddingStrategy(new DynamicTextCampaignStrategyAddMap()
                                .withSearch(new DynamicTextCampaignSearchStrategyAddMap()
                                        .withBiddingStrategyType(
                                                DynamicTextCampaignSearchStrategyTypeEnum.WB_MAXIMUM_CLICKS)
                                        .withWbMaximumClicks(new StrategyMaximumClicksAddMap()
                                                .withWeeklySpendLimit(minLimit.multiply(2f).bidLong().longValue())
                                                .withBidCeiling(MoneyCurrency.get(currency).getMinPrice().bidLong()
                                                        .longValue())))
                                .withNetwork(new DynamicTextCampaignNetworkStrategyAddMap().defaultServingOff()))));
        strategyMap = new DynamicTextCampaignStrategyMap()
                .withSearch(new DynamicTextCampaignSearchStrategyMap()
                        .withBiddingStrategyType(DynamicTextCampaignSearchStrategyTypeEnum.WB_MAXIMUM_CLICKS)
                        .withWbMaximumClicks(new StrategyMaximumClicksMap()
                                .withWeeklySpendLimit(weeklyLimit)
                                .withBidCeiling(bidCeiling)))
                .withNetwork(new DynamicTextCampaignNetworkStrategyMap().defaultServingOff());
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("986")
    public void weeklyLimitTest() {
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(
                new UpdateRequestMap().withCampaigns(new CampaignUpdateItemMap()
                        .withId(campaignId)
                        .withDynamicTextCampaign(new DynamicTextCampaignUpdateItemMap()
                                .withBiddingStrategy(strategyMap))),
                ExpectedResult.success(campaignId));

        List<CampaignGetItem> campaigns = api.userSteps.campaignSteps().getCampaigns(
                new GetRequestMap().withSelectionCriteria(new CampaignsSelectionCriteriaMap()
                        .withIds(campaignId))
                        .withFieldNames(CampaignFieldEnum.ID)
                        .withDynamicTextCampaignFieldNames(DynamicTextCampaignFieldEnum.BIDDING_STRATEGY));
        assumeThat("получили кампанию", campaigns, hasSize(1));
        DynamicTextCampaignStrategy actualStrategy = campaigns.get(0).getDynamicTextCampaign().getBiddingStrategy();
        assumeThat("получили стратегии кампании", actualStrategy, notNullValue());

        assertThat("получили корректные стратегии", actualStrategy,
                beanDifferV5((DynamicTextCampaignStrategy) strategyMap.getBean()));
    }
}
