package ru.yandex.autotests.direct.api.campaigns.update.dynamictextcampaign.strategy.payforconversion;

import com.yandex.direct.api.v5.campaigns.DynamicTextCampaignSearchStrategyTypeEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.direct.utils.money.MoneyFormat;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignNetworkStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignSearchStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyPayForConversionMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.campaigns.MetrikaGoals;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by pashkus on 28.05.2020.
 * Тест работает с включенными фичей cpa_pay_for_conversions_extended_mode
 */
@Aqua.Test
@Features(CampaignsFeatures.UPDATE)
@Description("Негативные сценарии проверки при обновлении стратегии PayForConversion")
@Tag(TagDictionary.TRUNK)
public class StrategyPayForConversionRestrictionsTest {
    private static final String client = CampaignsLogins.CLIENT;
    private static final Currency currency = Currency.RUB;
    private static final Integer counterId = 32265784;
    private static final Long goalId = MetrikaGoals.getGoalForCounter(counterId);
    private static final Money minCpa = Money.valueOf(500);
    private static final Money weekSpendLimit = Money.valueOf(10000);
    private static final int PAY_FOR_CONVERSION_SUM_TO_AVG_CPA_MIN_RATIO = 20;
    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);
    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    private static MoneyCurrency moneyCurrency = MoneyCurrency.get(currency);
    @Rule
    public Trashman trasher = new Trashman(api);
    private Long campaignId;

    private static StrategyPayForConversionMap getDefaultPayForConversionStrategy() {
        return new StrategyPayForConversionMap()
                .withWeeklySpendLimit(weekSpendLimit.bidLong().longValue())
                .withGoalId(goalId)
                .withCpa(minCpa.bidLong().longValue());
    }

    @Before
    @Step("Подготовим данные для теста")
    public void prepare() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        campaignId = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        int shard = api.userSteps.clientFakeSteps().getUserShard(client);

        DirectJooqDbSteps dbSteps = api.userSteps.getDirectJooqDbSteps().useShard(shard);
        dbSteps.campMetrikaGoalsSteps()
                .addOrUpdateMetrikaGoals(campaignId, goalId.longValue(), 100L, 100L);

        api.userSteps.campaignSteps().shouldGetResultOnUpdate(
                new UpdateRequestMap().withCampaigns(new CampaignUpdateItemMap()
                        .withId(campaignId)
                        .withDynamicTextCampaign(new DynamicTextCampaignUpdateItemMap()
                                .withBiddingStrategy(new DynamicTextCampaignStrategyMap()
                                        .withSearch(new DynamicTextCampaignSearchStrategyMap()
                                                .withBiddingStrategyType(
                                                        DynamicTextCampaignSearchStrategyTypeEnum.PAY_FOR_CONVERSION)
                                                .withPayForConversion(getDefaultPayForConversionStrategy()))
                                        .withNetwork(new DynamicTextCampaignNetworkStrategyMap().defaultServingOff())))),
                ExpectedResult.success());
    }

    @Test
    public void updateStrategyPayForConversionCpaExceedUpperBoundErrorTest() {
        // умножаем на 3, потому что включена фича increased_cpa_limit_for_pay_for_conversion
        Money maxPayForConversionCpa = moneyCurrency.getMaxPayForConversionCpa().multiply(3);
        Long cpa = maxPayForConversionCpa.getNext().bidLong().longValue();
        checkAvgCpaBiddingStrategyUpdateRequest(
                getDefaultPayForConversionStrategy()
                        .withCpa(cpa)
                        .withWeeklySpendLimit(cpa),
                JavaOrPerlExpectedResult
                        .java(ExpectedResult.errors(new Notification(4000,
                                Api5ErrorDetailsJava.VALUE_MUST_NOT_BE_GREATER_THAN,
                                "AverageCpa",
                                maxPayForConversionCpa.stringValue(MoneyFormat.WITHOUT_EXTRA_ZEROS))))
                        .perl(ExpectedResult.errors(new Notification(4000,
                                Api5ErrorDetails.AVERAGE_CPA_SHOULD_BE_NO_MORE_THAN,  //todo: поменять текст ошибки в ядре?
                                maxPayForConversionCpa.stringValue(MoneyFormat.TWO_DIGITS_POINT_SEPARATED),
                                moneyCurrency.getApiDescription())))
        );
    }

    @Test
    @Ignore("DIRECT-140102: отказались от ограничения 20*CPA. Позитивный тест " +
            "updateStrategyPayForConversionWeekSpendLimitLessThanLowerBoundTest")
    public void updateStrategyPayForConversionWeekSpendLimitLessThanLowerBoundErrorTest() {
        checkAvgCpaBiddingStrategyUpdateRequest(
                getDefaultPayForConversionStrategy()
                        .withWeeklySpendLimit(weekSpendLimit.divide(2).bidLong().longValue()),
                JavaOrPerlExpectedResult.both(ExpectedResult.errors(new Notification(4000,
                        Api5ErrorDetails.WEEKLY_BUDGET_MUST_BE_GREATER_THAN_AVG_CPA_MULTIPLIED_BY_RATIO,
                        PAY_FOR_CONVERSION_SUM_TO_AVG_CPA_MIN_RATIO)))
        );
    }

    @Test
    public void updateStrategyPayForConversionWeekSpendLimitLessThanLowerBoundTest() {
        checkAvgCpaBiddingStrategyUpdateRequest(
                getDefaultPayForConversionStrategy()
                        .withWeeklySpendLimit(weekSpendLimit.divide(2).bidLong().longValue()),
                JavaOrPerlExpectedResult.both(ExpectedResult.success()));
    }

    private void checkAvgCpaBiddingStrategyUpdateRequest(StrategyPayForConversionMap strategyPayForConversionMap,
                                                         JavaOrPerlExpectedResult expectedResult) {
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(
                new UpdateRequestMap().withCampaigns(new CampaignUpdateItemMap()
                        .withId(campaignId)
                        .withDynamicTextCampaign(new DynamicTextCampaignUpdateItemMap()
                                .withBiddingStrategy(new DynamicTextCampaignStrategyMap()
                                        .withSearch(new DynamicTextCampaignSearchStrategyMap()
                                                .withBiddingStrategyType(
                                                        DynamicTextCampaignSearchStrategyTypeEnum.PAY_FOR_CONVERSION)
                                                .withPayForConversion(strategyPayForConversionMap))
                                        .withNetwork(new DynamicTextCampaignNetworkStrategyMap().defaultServingOff())))),
                expectedResult);
    }
}
