package ru.yandex.autotests.direct.api.campaigns.update.fieldvalidation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignBaseMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;
import static ru.yandex.autotests.directapi.apiclient.errors.Path.path;
import static ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult.bothJavaAndPerl;

/**
 * Created by ginger on 21.08.15.
 * https://st.yandex-team.ru/TESTIRT-6809
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-34570")
@Features(CampaignsFeatures.UPDATE)
@Description("Проверка обновления поля BlockedIps. Негативные сценарии")
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class UpdateBlockedIpsNegativeTest {

    private static String client = CampaignsLogins.UPDATE_CLIENT;

    private static Long id;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(5).as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public String[] blockedIps;

    @Parameterized.Parameter(2)
    public JavaOrPerlExpectedResult expectedResult;

    @Parameterized.Parameters(name = "{0}")
    public static Collection testData() {
        List<String> overLengthBlockedIps = new ArrayList<String>();
        for (int i = 0; i <= CampaignAddItemMap.MAX_AMOUNT_OF_BLOCKED_IPS; i++) {
            overLengthBlockedIps.add(CampaignBaseMap.generateRandomNotPrivateIp());
        }
        String someString = "someString";
        String invalidFormat = "8.8.8";
        String localhost = "127.0.0.1";
        String privateSubnetwork = "192.168.0.1";
        Object[][] data = new Object[][]{
                {"пустая строка", new String[]{""}, JavaOrPerlExpectedResult
                        .java(ExpectedResult.errors(new Notification(5004,
                                Api5ErrorDetailsJava.VALUE_INVALID_FORMAT_IN_FILED,
                                path(capitalize(CampaignAddItemMap.BLOCKED_IPS), 0))))
                        .perl(ExpectedResult.errors(new Notification(5005,
                                Api5ErrorDetails.ELEMENT_OF_ARRAY_CANT_BE_EMPTY_STRING,
                                capitalize(CampaignUpdateItemMap.BLOCKED_IPS))))},
                {"пробел", new String[]{" "}, JavaOrPerlExpectedResult
                        .java(ExpectedResult.errors(new Notification(5004,
                                Api5ErrorDetailsJava.VALUE_INVALID_FORMAT_IN_FILED,
                                path(capitalize(CampaignAddItemMap.BLOCKED_IPS), 0))))
                        .perl(ExpectedResult.errors(new Notification(5005,
                                Api5ErrorDetails.ELEMENT_OF_ARRAY_CANT_BE_EMPTY_STRING,
                                capitalize(CampaignUpdateItemMap.BLOCKED_IPS))))},
                {"строка", new String[]{someString}, JavaOrPerlExpectedResult
                        .java(ExpectedResult.errors(new Notification(5004,
                                Api5ErrorDetailsJava.VALUE_INVALID_FORMAT_IN_FILED,
                                path(capitalize(CampaignAddItemMap.BLOCKED_IPS), 0))))
                        .perl(ExpectedResult.errors(new Notification(5004,
                                Api5ErrorDetails.WRONG_IP_ADDRESS_FORMAT, someString)))},
                {"повторяющееся значение", new String[]{"8.8.8.8", "8.8.8.8"},
                        bothJavaAndPerl(9802, Api5ErrorDetails.ELEMENT_PRESENT_IN_LIST_MORE_THAN_ONE_TIME,
                                        "8.8.8.8", capitalize(CampaignAddItemMap.BLOCKED_IPS))},
                {invalidFormat, new String[]{invalidFormat}, JavaOrPerlExpectedResult
                        .java(ExpectedResult.errors(new Notification(5004,
                                Api5ErrorDetailsJava.VALUE_INVALID_FORMAT_IN_FILED,
                                path(capitalize(CampaignAddItemMap.BLOCKED_IPS), 0))))
                        .perl(ExpectedResult.errors(new Notification(5004,
                                Api5ErrorDetails.WRONG_IP_ADDRESS_FORMAT, invalidFormat)))},
                {localhost, new String[]{localhost},
                        bothJavaAndPerl(5006, Api5ErrorDetails.YOU_CANNOT_BLOCK_PRIVATE_SUBNETWORK_IPS, localhost)},
                {privateSubnetwork, new String[]{privateSubnetwork},
                        bothJavaAndPerl(5006, Api5ErrorDetails.YOU_CANNOT_BLOCK_PRIVATE_SUBNETWORK_IPS, privateSubnetwork)},
                {"Количество элементов, превышающее максимальную длину", overLengthBlockedIps.toArray(new String[]{}),
                        // локально падает, т.к. в network-config.allow-all.json все ip объявляются внутренними
                        // для локального тестирования убрать из конфига секцию internal
                        JavaOrPerlExpectedResult
                                .java(ExpectedResult.errorsIgnoringDetails(new Notification(7001)))
                                .perl(ExpectedResult.errors(new Notification(7001,
                                        Api5ErrorDetails.MAXIMUM_NUMBER_OF_BLOCKED_IPS_EXCEEDED,
                                        CampaignAddItemMap.MAX_AMOUNT_OF_BLOCKED_IPS)))}
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void createCampaign() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        id = api.userSteps.campaignSteps().addDefaultTextCampaign();
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1005")
    public void tryUpdateBlockedIps() {
        //DIRECT-45935
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(new CampaignUpdateItemMap()
                                .withId(id)
                                .withBlockedIps(blockedIps)
                        ),
                expectedResult);
    }
}
