package ru.yandex.autotests.direct.api.campaigns.update.fieldvalidation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import com.yandex.direct.api.v5.campaigns.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.CampaignGetItem;
import com.yandex.direct.api.v5.general.ArrayOfString;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignBaseMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.containsInAnyOrder;
import static org.hamcrest.Matchers.is;
import static org.hamcrest.Matchers.notNullValue;
import static org.hamcrest.Matchers.nullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by ginger on 21.08.15.
 * https://st.yandex-team.ru/TESTIRT-6809
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-34570")
@Features(CampaignsFeatures.UPDATE)
@Description("Проверка обновления поля BlockedIps")
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class UpdateBlockedIpsTest {

    private static String client = CampaignsLogins.UPDATE_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(5).as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long id;

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public String[] blockedIps;

    @Parameterized.Parameter(2)
    public ProtocolType protocolType;

    @Parameterized.Parameters(name = "{0}")
    public static Collection<Object[]> data() {
        List<String> maxLengthBlockedIps = new ArrayList<String>();
        for (int i = 0; i < CampaignAddItemMap.MAX_AMOUNT_OF_BLOCKED_IPS; i++) {
            maxLengthBlockedIps.add(CampaignBaseMap.generateRandomNotPrivateIp());
        }
        return Arrays.asList(new Object[][]{
                {"8.8.8.8", new String[]{"8.8.8.8"}, ProtocolType.JSON},
                {"Максимальное количество элементов", maxLengthBlockedIps.toArray(new String[]{}), ProtocolType.JSON},
                {"null JSON", null, ProtocolType.JSON},
                {"null SOAP", null, ProtocolType.SOAP},
        });
    }

    @BeforeClass
    public static void createCampaign() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        id = api.userSteps.campaignSteps().addDefaultTextCampaign();
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1006")
    public void updateBlockedIps() {
        api.protocol(protocolType);
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(new CampaignUpdateItemMap()
                                .withId(id)
                                .withBlockedIps(blockedIps)
                        ),
                ExpectedResult.success(id));
        CampaignGetItem campaignGetItem =
                api.userSteps.campaignSteps().campaignsGet(id, CampaignFieldEnum.BLOCKED_IPS);

        ArrayOfString actualBlockedIps = campaignGetItem.getBlockedIps().getValue();
        if (blockedIps == null) {
            assertThat("поле BlockedIps пустое", actualBlockedIps, is(nullValue()));
        } else {
            assertThat("поле BlockedIps заполнено", actualBlockedIps, is(notNullValue()));
            assertThat("поле BlockedIps сохранилось верно",
                    actualBlockedIps.getItems(), containsInAnyOrder(blockedIps));
        }
    }
}
