package ru.yandex.autotests.direct.api.campaigns.update.fieldvalidation;

import java.util.Arrays;
import java.util.Collection;

import org.apache.commons.lang3.RandomStringUtils;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by ginger on 21.08.15.
 * https://st.yandex-team.ru/TESTIRT-6809
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-34570")
@Features(CampaignsFeatures.UPDATE)
@Description("Проверка обновления поля ClientInfo")
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class UpdateClientInfoNegativeTest {

    private static final String CLIENT = CampaignsLogins.UPDATE_CLIENT;

    private static Long id;

    @ClassRule
    public static final ApiSteps api = new ApiSteps().version(5).as(CLIENT);

    @ClassRule
    public static final SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public String clientInfo;

    @Parameterized.Parameter(2)
    public JavaOrPerlExpectedResult expectedResult;

    @Parameterized.Parameters(name = "{0}")
    public static Collection<Object[]> data() {
        JavaOrPerlExpectedResult invalidCharsError = JavaOrPerlExpectedResult
                .java(ExpectedResult.errors(new Notification(5002,
                        Api5ErrorDetailsJava.INVALID_CHARS, "ClientInfo")))
                .perl(ExpectedResult.errors(new Notification(5002,
                        Api5ErrorDetails.CLIENT_NAME_CONTAINS_SPECIAL_CHARACTERS)));
        return Arrays.asList(new Object[][]{
                {"Тег", "</Name>", invalidCharsError},
                {"Перенос строки в имени", "name\n",invalidCharsError},
                {"Табуляция в имени", "name\t",invalidCharsError},
                {"Превышение максимальной длины",
                        RandomStringUtils.randomAlphabetic(CampaignAddItemMap.MAX_CLIENT_INFO_LENGTH + 1),
                        JavaOrPerlExpectedResult
                                .java(ExpectedResult.errors(new Notification(5001,
                                        Api5ErrorDetailsJava.MAX_STR_LENGTH,
                                        "ClientInfo",
                                        CampaignAddItemMap.MAX_CLIENT_INFO_LENGTH)))
                                .perl(ExpectedResult.errors(new Notification(5001,
                                        Api5ErrorDetails.CLIENT_INFO_LENGTH_EXCEEDED,
                                        CampaignAddItemMap.MAX_CLIENT_INFO_LENGTH)))
                        },
        });
    }

    @BeforeClass
    public static void createCampaign() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
        id = api.userSteps.campaignSteps().addDefaultTextCampaign();
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1007")
    public void tryUpdateClientInfoValidToInvalid() {
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(new CampaignUpdateItemMap()
                                .withId(id)
                                .withClientInfo(clientInfo)
                        ),
                expectedResult);
    }
}
